/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dplm.ui.test;

import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.impl.DevicesFactoryImpl;
import org.eclipse.mtj.api.enumerations.DeviceCommunicationProtocol;
import org.eclipse.mtj.api.enumerations.DeviceStatus;
import org.eclipse.mtj.api.enumerations.PlatformType;
import org.eclipse.mtj.api.extension.DeploymentProvider;
import org.eclipse.mtj.api.extension.impl.MtjExtensionImpl;
import org.eclipse.mtj.exception.MtjException;

public class TestDeploymentProviderImpl
extends MtjExtensionImpl
implements DeploymentProvider {
    private String name = "";
    private String description = "";

    TestDeploymentProviderImpl(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public Device[] getDevices() {
        Device[] devices = new Device[6];
        DevicesFactoryImpl devicesFactory = new DevicesFactoryImpl();
        int i = 0;
        while (i < 5) {
            devices[i] = devicesFactory.createDevice();
            devices[i].setName("Device " + i);
            devices[i].setDescription("This is the device " + i + " and it has some of the following characteristics:" + "\n- it belongs to the platform type " + i + 1 + "\n- the ID number is " + 1001 + i + "\n\nVendor: Nokia\n\nVersion: 1.0.1");
            devices[i].setVendor("Nokia");
            devices[i].setVersion("1.0.1");
            ++i;
        }
        devices[5] = devicesFactory.createDevice();
        devices[5].setName("Series 60 emulator");
        devices[5].setDescription("This is the Nokia Series 60 emulator");
        devices[5].setVendor("Nokia");
        devices[5].setVersion("1.0.0");
        return devices;
    }

    public Device[] getTargetDevices() {
        Vector<Device> targetDevices = new Vector<Device>();
        int i = 0;
        while (i < this.getDevices().length) {
            if (this.getDevices()[i].getName().endsWith("2") || this.getDevices()[i].getName().endsWith("3") || this.getDevices()[i].getName().endsWith("emulator")) {
                targetDevices.add(this.getDevices()[i]);
            }
            ++i;
        }
        return targetDevices.toArray(new Device[targetDevices.size()]);
    }

    public boolean isConnected(Device device) {
        return device.getName().endsWith("2") || device.getName().endsWith("4") || device.getName().endsWith("emulator");
    }

    public PlatformType getPlatformType() {
        return null;
    }

    public DeviceCommunicationProtocol[] getSupportedProtocols() {
        return null;
    }

    public void deploy(Deployment deployment, Device[] devices, DeviceCommunicationProtocol transferProtocol, IProgressMonitor monitor) {
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public DeviceStatus getStatus(Device device) throws MtjException {
        if (device.getName().endsWith("2") || device.getName().endsWith("4") || device.getName().endsWith("emulator")) {
            return DeviceStatus.DEVICE_STATUS_OK_LITERAL;
        }
        return DeviceStatus.DEVICE_STATUS_NOT_CONNECTED_LITERAL;
    }
}

