/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.jad.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.mtj.jad.util.MIDletDescriptor;
import org.eclipse.mtj.jad.util.PropertyFile;
import org.eclipse.mtj.jad.util.PropertyLine;

public class JadFileDescriptor
extends PropertyFile {
    public ArrayList midletList;
    public String midpVersion;
    public static final String MIDP10 = "MIDP-1.0";
    public static final String MIDP20 = "MIDP-2.0";
    public static final String[] MIDP_VALID_VALUES = new String[]{"MIDP-1.0", "MIDP-2.0"};
    public static final String MIDP_DEFAULT_VALUE = "MIDP-2.0";
    public static final String CLDC10 = "CLDC-1.0";
    public static final String CLDC11 = "CLDC-1.1";
    public static final String[] CLDC_VALID_VALUES = new String[]{"CLDC-1.0", "CLDC-1.1"};
    public static final String CLDC_DEFAULT_VALUE = "CLDC-1.1";
    public static final String MIDLET_PREFIX = "MIDlet-";
    public static final String MICROEDITION_PREFIX = "MicroEdition-";
    public static final int NAME = 0;
    public static final int VERSION = 1;
    public static final int VENDOR = 2;
    public static final int DESCRIPTION = 3;
    public static final int JAR_SIZE = 4;
    public static final int JAR_URL = 5;
    public static final int ICON = 6;
    public static final int INFO_URL = 7;
    public static final int DATA_SIZE = 8;
    public static final int PROFILE_NAME = 9;
    public static final int CONFIGURATION_NAME = 10;
    public static final int PERMISSIONS = 11;
    public static final int PERMISSIONS_OPT = 12;
    public static final int INSTALL_NOTIFY = 13;
    public static final int DELETE_NOTIFY = 14;
    public static final int DELETE_CONFIRM = 15;
    public static final int JAR_RSA_SHA1 = 16;
    public static final int CERTIFICATE1 = 17;
    public static final String S_NAME = "MIDlet-Name";
    public static final String S_VERSION = "MIDlet-Version";
    public static final String S_VENDOR = "MIDlet-Vendor";
    public static final String S_DESCRIPTION = "MIDlet-Description";
    public static final String S_JAR_SIZE = "MIDlet-Jar-Size";
    public static final String S_JAR_URL = "MIDlet-Jar-URL";
    public static final String S_PROFILE_NAME = "MicroEdition-Profile";
    public static final String S_CONFIGURATION_NAME = "MicroEdition-Configuration";
    public static final String S_ICON = "MIDlet-Icon";
    public static final String S_INFO_URL = "MIDlet-Info-URL";
    public static final String S_DATA_SIZE = "MIDlet-Data-Size";
    public static final String S_PERMISSIONS = "MIDlet-Permissions";
    public static final String S_PERMISSIONS_OPT = "MIDlet-Permissions-Opt";
    public static final String S_INSTALL_NOTIFY = "MIDlet-Install-Notify";
    public static final String S_DELETE_NOTIFY = "MIDlet-Delete-Notify";
    public static final String S_DELETE_CONFIRM = "MIDlet-Delete-Confirm";
    public static final String S_JAR_RSA_SHA1 = "MIDlet-Jar-RSA-SHA1";
    public static final String S_CERTIFICATE1_1 = "MIDlet-Certificate-1-1";
    static final String[] midp10JadFields = new String[]{"MIDlet-Name", "MIDlet-Version", "MIDlet-Vendor", "MIDlet-Description", "MIDlet-Jar-Size", "MIDlet-Jar-URL", "MIDlet-Icon", "MIDlet-Info-URL", "MIDlet-Data-Size", "MicroEdition-Profile", "MicroEdition-Configuration"};
    static final String[] midp20JadFields = new String[]{"MIDlet-Name", "MIDlet-Version", "MIDlet-Vendor", "MIDlet-Description", "MIDlet-Jar-Size", "MIDlet-Jar-URL", "MIDlet-Icon", "MIDlet-Info-URL", "MIDlet-Data-Size", "MicroEdition-Profile", "MicroEdition-Configuration", "MIDlet-Permissions", "MIDlet-Permissions-Opt", "MIDlet-Install-Notify", "MIDlet-Delete-Notify", "MIDlet-Delete-Confirm", "MIDlet-Jar-RSA-SHA1", "MIDlet-Certificate-1-1"};

    public String[] getFieldNames() {
        return JadFileDescriptor.getFieldNames(this.midpVersion);
    }

    public static String[] getFieldNames(String midpVersion) {
        if (midpVersion.compareTo("MIDP-2.0") == 0) {
            return midp20JadFields;
        }
        return midp10JadFields;
    }

    private void initializeRequiredFields() {
        String[] fieldNames = this.getFieldNames();
        this.setProperty(fieldNames[0], "");
        this.setProperty(fieldNames[1], "");
        this.setProperty(fieldNames[2], "");
        this.setProperty(fieldNames[4], "");
        this.setProperty(fieldNames[5], "");
    }

    protected JadFileDescriptor(String midpVersion) {
        this.midpVersion = midpVersion;
        this.midletList = new ArrayList();
        this.initializeRequiredFields();
    }

    public MIDletDescriptor getMIDlet(int index) {
        return (MIDletDescriptor)this.midletList.get(index - 1);
    }

    public int getMIDletCount() {
        return this.midletList.size();
    }

    public void setMIDlet(int index, MIDletDescriptor d) {
        String key = JadFileDescriptor.getMIDletKey(index);
        d.setKey(key);
        this.setPropertyLine(d);
        this.setupMIDlets();
    }

    public void addMIDlet(String name, String icon, String classname) {
        MIDletDescriptor d = new MIDletDescriptor(name, icon, classname);
        this.addMIDlet(d);
    }

    public void addMIDlet(MIDletDescriptor d) {
        String key = JadFileDescriptor.getMIDletKey(this.midletList.size() + 1);
        d.setKey(key);
        this.setPropertyLine(d);
        this.midletList.add(d);
    }

    public static String getMIDletKey(int index) {
        return MIDLET_PREFIX + index;
    }

    public static boolean isMidletNrKey(String key) {
        try {
            String numberString = key.substring(MIDLET_PREFIX.length(), key.length());
            Integer.parseInt(numberString);
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public void removeMIDlet(int index) {
        int max = this.midletList.size();
        super.removeProperty(JadFileDescriptor.getMIDletKey(index));
        super.removeProperty(JadFileDescriptor.getMIDletKey(max));
        int i = index;
        while (i < max) {
            super.setProperty(JadFileDescriptor.getMIDletKey(i), ((MIDletDescriptor)this.midletList.get(i)).getValue());
            ++i;
        }
        this.midletList.remove(index - 1);
    }

    public void setProperty(int index, String value) {
        this.setProperty(this.getFieldNames()[index], value);
    }

    public String getProperty(int index) {
        return this.getProperty(this.getFieldNames()[index]);
    }

    public String[] getCustomKeys() {
        Set keySet = this.keySet();
        ArrayList<String> list = new ArrayList<String>(keySet.size());
        for (String key : keySet) {
            if (!this.isCustomKey(key)) continue;
            list.add(key);
        }
        String[] keys = new String[list.size()];
        return list.toArray(keys);
    }

    public boolean isCustomKey(String key) {
        return !key.startsWith(MIDLET_PREFIX) && !key.startsWith(MICROEDITION_PREFIX);
    }

    public void swap(int index1, int index2) {
        int length = this.midletList.size();
        if (index1 - 1 > length || index2 - 1 > length) {
            return;
        }
        String mid1 = JadFileDescriptor.getMIDletKey(index1);
        String mid2 = JadFileDescriptor.getMIDletKey(index2);
        MIDletDescriptor d1 = (MIDletDescriptor)this.getPropertyLine(mid1);
        MIDletDescriptor d2 = (MIDletDescriptor)this.getPropertyLine(mid2);
        if (d1 == null || d2 == null) {
            return;
        }
        String value1 = d1.getValue();
        d1.setValue(d2.getValue());
        d2.setValue(value1);
        this.setupMIDlets();
    }

    public Set getMIDletClassnames() {
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        int max = this.midletList.size();
        while (i < max) {
            set.add(((MIDletDescriptor)this.midletList.get((int)i)).classname);
            ++i;
        }
        return set;
    }

    public static JadFileDescriptor getDescriptor(IProject project) {
        JadFileDescriptor descriptor = new JadFileDescriptor("MIDP-2.0");
        return descriptor;
    }

    public static JadFileDescriptor getDescriptor() {
        JadFileDescriptor descriptor = new JadFileDescriptor("MIDP-2.0");
        return descriptor;
    }

    public static JadFileDescriptor getDescriptor(IFile file) throws CoreException, IOException {
        JadFileDescriptor instance = new JadFileDescriptor("MIDP-2.0");
        instance.loadInto(file, false);
        return instance;
    }

    public void setupMIDlets() {
        String key;
        PropertyLine line;
        this.midletList.clear();
        int i = 0;
        while ((line = this.getPropertyLine(key = JadFileDescriptor.getMIDletKey(i + 1))) != null) {
            MIDletDescriptor d = MIDletDescriptor.convertFrom(line);
            if (line != d) {
                d.setKey(key);
                this.setPropertyLine(d);
            }
            this.midletList.add(i, d);
            ++i;
        }
    }

    private boolean isMidpX(String version) {
        String configuration = this.getProperty(9);
        if (configuration == null) {
            return false;
        }
        return configuration.compareTo(version) == 0;
    }

    public boolean isMidp20() {
        return this.isMidpX("MIDP-2.0");
    }

    public boolean isMidp10() {
        return this.isMidpX(MIDP10);
    }

    private boolean isCldcX(String version) {
        String configuration = this.getProperty(10);
        if (configuration == null) {
            return false;
        }
        return configuration.compareTo(version) == 0;
    }

    public boolean isCldc10() {
        return this.isCldcX(CLDC10);
    }

    public boolean isCldc11() {
        return this.isCldcX("CLDC-1.1");
    }

    public Object clone() {
        JadFileDescriptor clone = new JadFileDescriptor(this.midpVersion);
        Iterator i = this.lineIterator();
        while (i.hasNext()) {
            PropertyLine line = (PropertyLine)i.next();
            clone.setPropertyLine((PropertyLine)line.clone());
        }
        clone.setupMIDlets();
        return clone;
    }

    public void removeProperty(String key) {
        super.removeProperty(key);
        if (JadFileDescriptor.isMidletNrKey(key)) {
            this.setupMIDlets();
        }
    }

    public void setProperty(String key, String value) {
        super.setProperty(key, value);
        if (JadFileDescriptor.isMidletNrKey(key)) {
            this.setupMIDlets();
        }
    }
}

