/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.ui.page;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.ui.Messages;
import org.eclipse.mtj.core.ui.page.ExtensionPropertyPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class ExtensionNavigator
extends Composite {
    TreeViewer treeViewer;
    ExtensionPropertyPage _parent;

    public ExtensionNavigator(Composite parent, int style, ExtensionPropertyPage _parent) {
        super(parent, style);
        this._parent = _parent;
        this.init();
    }

    protected void init() {
        this.setLayout((Layout)new GridLayout(1, true));
        GridData gd = new GridData(1);
        gd.horizontalSpan = 1;
        this.setLayoutData(gd);
        this.treeViewer = new TreeViewer(this.getParent(), 4);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TreeViewLabelProvider());
        this.treeViewer.setContentProvider((IContentProvider)new TreeViewContentProvider());
        this.treeViewer.setInput(this.getInput());
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)new TreeViewSelectionChangedListener());
        gd = new GridData(1);
        gd.horizontalSpan = 1;
        gd.widthHint = 200;
        gd.heightHint = 450;
        this.treeViewer.getTree().setLayoutData((Object)gd);
    }

    public void changedExtensionActivity(boolean active) {
        Object i;
        Object o;
        if (this.treeViewer.getSelection() != null && this.treeViewer.getSelection() instanceof StructuredSelection && (o = ((StructuredSelection)this.treeViewer.getSelection()).getFirstElement()) instanceof ExtensionImplNode && (i = ((ExtensionImplNode)o).impl) != null && i instanceof MtjExtension) {
            ((MtjExtension)i).setActive(active);
            this.treeViewer.refresh(o, true);
        }
    }

    private Object getInput() {
        ArrayList<ExtensionNode> arr = new ArrayList<ExtensionNode>();
        Iterator it = ExtensionType.VALUES.iterator();
        while (it.hasNext()) {
            arr.add(new ExtensionNode(it.next().toString(), null));
        }
        return arr.toArray();
    }

    class TreeViewLabelProvider
    extends LabelProvider {
        TreeViewLabelProvider() {
        }

        public String getText(Object obj) {
            return obj.toString();
        }

        public Image getImage(Object obj) {
            return null;
        }
    }

    class TreeViewContentProvider
    implements ITreeContentProvider {
        TreeViewContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof ExtensionNode) {
                ExtensionNode node = (ExtensionNode)parentElement;
                if (node.implementations == null) {
                    ExtensionType e = ExtensionType.get((String)node.name);
                    MtjExtension[] list = MtjServices.getInstance().getImplementations(e, null, null, false);
                    if (list.length > 0) {
                        ArrayList<ExtensionImplNode> arr = new ArrayList<ExtensionImplNode>();
                        int i = 0;
                        while (i < list.length) {
                            MtjExtension m = list[i];
                            ExtensionImplNode ein = new ExtensionImplNode(null, m);
                            arr.add(ein);
                            ++i;
                        }
                        return arr.toArray();
                    }
                    Object[] o = new Object[]{};
                    return o;
                }
                return node.implementations;
            }
            if (parentElement instanceof Object[]) {
                return (Object[])parentElement;
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof ExtensionImplNode) {
                return ((ExtensionImplNode)element).parent;
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof ExtensionNode) {
                return ((ExtensionNode)element).hasChildren();
            }
            if (element instanceof ExtensionImplNode) {
                return ((ExtensionImplNode)element).hasChildren();
            }
            return false;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class TreeViewSelectionChangedListener
    implements ISelectionChangedListener {
        TreeViewSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object f;
            if (event.getSelection() instanceof StructuredSelection && ((StructuredSelection)event.getSelection()).size() > 0 && (f = ((StructuredSelection)event.getSelection()).getFirstElement()) instanceof ExtensionImplNode) {
                ExtensionImplNode s = (ExtensionImplNode)f;
                if (s.impl instanceof MtjExtension) {
                    ExtensionNavigator.this._parent.newSelection(s);
                }
            }
        }
    }

    class ExtensionNode {
        public String name;
        public ExtensionImplNode[] implementations;

        public ExtensionNode(String name, ExtensionImplNode[] implementations) {
            this.name = name;
            this.implementations = implementations;
        }

        public String toString() {
            return this.name;
        }

        public boolean hasChildren() {
            return true;
        }
    }

    class ExtensionImplNode {
        public String name;
        public Object impl;
        public Composite adminPage;
        public ExtensionNode parent;

        public ExtensionImplNode(String name, Object impl) {
            this.name = name;
            this.impl = impl;
        }

        public String toString() {
            if (this.impl instanceof MtjExtension) {
                MtjExtension m = (MtjExtension)this.impl;
                return String.valueOf(m.isActive() ? Messages.ExtensionNavigator_Active : Messages.ExtensionNavigator_NotActive) + m.getVendor() + Messages.ExtensionNavigator_0 + m.getVersion();
            }
            return this.name;
        }

        public boolean hasChildren() {
            return false;
        }
    }
}

