/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.ui.preferences.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.ui.Messages;
import org.eclipse.mtj.core.ui.MtjCoreUiPlugin;
import org.eclipse.mtj.core.ui.preferences.control.TableViewerSorter;
import org.eclipse.mtj.core.ui.preferences.model.ExtensionContentProvider;
import org.eclipse.mtj.core.ui.preferences.model.ExtensionImplNode;
import org.eclipse.mtj.core.ui.preferences.model.ExtensionLabelProvider;
import org.eclipse.mtj.core.ui.preferences.view.MTJProviderViewUI;
import org.eclipse.mtj.core.ui.preferences.view.ProjectScopeDialog;
import org.eclipse.mtj.core.ui.util.GridUtil;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ProviderPrefPage
extends PreferencePage
implements MouseListener,
SelectionListener {
    public static final String PREF_ID = "org.eclipse.mtj.extension.rpm.ui.preferences.ProjectRuntimeMgmtPreferencePage";
    public static final String PROP_ID = "org.eclipse.mtj.extension.rpm.ui.preferences.ProjectRuntimeMgmtPreferencePage";
    public static final String PLUGIN_ID = "org.eclipse.mtj.extension.devide";
    public static final String MTJ_NATURE_ID = "org.eclipse.mtj.extension.devide.nature";
    protected static String srvProvFilter = "PROVIDER";
    private MTJProviderViewUI mtjProviderViewUI;
    private static final String[] COLUMNS = new String[]{"STRING", "STRING", "STRING"};
    private int rowIndex = 0;
    private ArrayList listeners = new ArrayList(2);
    private IProject fProject;
    private IJavaProject[] selectedProjects = null;
    public static final String DATA_NO_LINK = "PropertyAndPreferencePage.nolink";
    private Composite composite = null;

    public ProviderPrefPage(IPreferenceStore preferenceStore) {
    }

    public ProviderPrefPage(String title) {
        super(title);
    }

    public ProviderPrefPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public Control createContents(Composite parent) {
        this.composite = new Composite(parent, 0);
        Link lnkProjectSettings = new Link(this.composite, 0);
        GridData gd = new GridData(128);
        lnkProjectSettings.setLayoutData((Object)gd);
        lnkProjectSettings.setText(Messages.ProviderPrefPage_ConfigureMtjProjectSpecificSettingsText);
        lnkProjectSettings.setToolTipText(Messages.ProviderPrefPage_ConfigureMTJProjectSpecificSettings);
        lnkProjectSettings.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ProviderPrefPage.this.doLinkActivated((Link)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ProviderPrefPage.this.doLinkActivated((Link)e.widget);
            }
        });
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        this.composite.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        this.composite.setLayoutData((Object)data);
        this.mtjProviderViewUI = new MTJProviderViewUI(COLUMNS);
        this.mtjProviderViewUI.createControl(this.composite);
        this.createControl(this.composite);
        this.initializeDefaults();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.composite, String.valueOf(MtjCoreUiPlugin.getPluginId()) + ".mtjcore0003");
        return this.composite;
    }

    private void addListener() {
        this.mtjProviderViewUI.get_tableList().addSelectionListener((SelectionListener)this);
        this.mtjProviderViewUI.get_tableList().addMouseListener((MouseListener)this);
        this.mtjProviderViewUI.get_tableList().addSelectionListener((SelectionListener)this);
    }

    public void createControl(Composite parent) {
        this.mtjProviderViewUI.getTableViewer().setContentProvider((IContentProvider)new ExtensionContentProvider());
        this.mtjProviderViewUI.getTableViewer().setLabelProvider((IBaseLabelProvider)new ExtensionLabelProvider());
        this.addListener();
        TableViewerSorter.setTableSorter(this.mtjProviderViewUI.getTableViewer(), 0, true);
        this.mtjProviderViewUI.getTableViewer().getTable().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem tableItem = (TableItem)event.item;
                ExtensionImplNode node = (ExtensionImplNode)tableItem.getData();
                MtjExtension mtjExtension = null;
                ProviderPrefPage.this.rowIndex = ProviderPrefPage.this.mtjProviderViewUI.getTableViewer().getTable().getSelectionIndex();
                if (tableItem.getChecked()) {
                    if (node.getImpl() instanceof MtjExtension) {
                        mtjExtension = (MtjExtension)node.getImpl();
                        mtjExtension.setActive(true);
                        node.setActive(Boolean.TRUE.toString());
                    }
                } else if (node.getImpl() instanceof MtjExtension) {
                    mtjExtension = (MtjExtension)node.getImpl();
                    mtjExtension.setActive(false);
                    node.setActive(Boolean.FALSE.toString());
                }
                ProviderPrefPage.this.mtjProviderViewUI.getTableViewer().getTable().redraw();
            }
        });
        this.mtjProviderViewUI.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ((IStructuredSelection)ProviderPrefPage.this.mtjProviderViewUI.getTableViewer().getSelection()).getFirstElement();
                ProviderPrefPage.this.mtjProviderViewUI.getTableViewer().getTable().getItemCount();
            }
        });
        this.mtjProviderViewUI.getTableViewer().setInput((Object)parent);
        this.mtjProviderViewUI.getTableViewer().refresh();
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        this.notifyListeners(e);
        int idx = this.mtjProviderViewUI.get_tableList().getSelectionIndex();
        if (idx > 0) {
            this.rowIndex = idx;
            ExtensionImplNode cfr_ignored_0 = (ExtensionImplNode)this.mtjProviderViewUI.get_tableList().getItem(idx - 1).getData();
        }
        if (idx != -1) {
            this.rowIndex = idx;
            ExtensionImplNode cfr_ignored_1 = (ExtensionImplNode)this.mtjProviderViewUI.get_tableList().getItem(idx).getData();
        }
    }

    private static void showDetailDialog(MtjExtension mtjExtension) {
        PreferencePage page = null;
        try {
            page = MtjServices.getInstance().getCorrespondingAdminGuiProvider(mtjExtension).getPreferencePage();
        }
        catch (MtjException e) {
            e.printStackTrace();
        }
        private class InfoDialog
        extends TitleAreaDialog {
            private PreferencePage page;
            private MtjExtension extension;

            public InfoDialog(PreferencePage page, MtjExtension extension) {
                MtjCorePlugin.getDefault();
                super(MtjCorePlugin.getActiveShell());
                this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
                this.page = page;
                this.extension = extension;
            }

            protected Control createDialogArea(Composite parent) {
                this.setTitle(Messages.ProviderPrefPage_ProviderInfo);
                this.setMessage(this.extension.getId());
                if (this.page != null) {
                    this.page.createControl(parent);
                }
                return parent;
            }
        }
        InfoDialog dialog = new InfoDialog(page, mtjExtension);
        dialog.open();
    }

    public void addListener(SelectionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(SelectionListener listener) {
        this.listeners.remove(listener);
    }

    final void doLinkActivated(Link link) {
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put(DATA_NO_LINK, Boolean.TRUE);
        IJavaProject[] projects = null;
        if (this.isProjectPreferencePage()) {
            this.openWorkspacePreferences(data);
        } else {
            HashSet<IJavaProject> projectsWithSpecifics = new HashSet<IJavaProject>();
            try {
                projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
                int i = 0;
                while (i < projects.length) {
                    IJavaProject curr = projects[i];
                    if (this.hasProjectSpecificOptions(curr.getProject())) {
                        projectsWithSpecifics.add(curr);
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {
            }
            catch (CoreException ex) {
                MtjCorePlugin.getDefault();
                MtjCoreUiPlugin.displayError(MtjCorePlugin.getActiveShell(), 1, 1, Messages.ProviderPrefPage_Error, Messages.ProviderPrefPage_ErrorOccured, ex);
            }
            MtjCorePlugin.getDefault();
            ProjectScopeDialog _dialog = new ProjectScopeDialog(MtjCorePlugin.getActiveShell(), Messages.ProviderPrefPage_SelectMTJProjects, projectsWithSpecifics, projects);
            if (_dialog.open() == 0) {
                IJavaProject[] _selectedProjects = _dialog.getSelectionResult();
                this.setSelectedProjects(null);
                this.setSelectedProjects(_selectedProjects);
                int i = 0;
                while (i < _selectedProjects.length) {
                    IJavaProject cfr_ignored_0 = _selectedProjects[i];
                    ++i;
                }
            }
        }
    }

    protected boolean isProjectPreferencePage() {
        return this.fProject != null;
    }

    protected final void openWorkspacePreferences(Object data) {
        String id = this.getPreferencePageID();
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id, (String[])new String[]{id}, (Object)data).open();
    }

    protected final void openProjectProperties(IProject project, Object data) {
        String id = this.getPropertyPageID();
        if (id != null) {
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)project, (String)id, (String[])new String[]{id}, (Object)data).open();
        }
    }

    private IJavaProject[] getSelectedProjects() {
        if (this.selectedProjects.length > 0) {
            return this.selectedProjects;
        }
        return null;
    }

    protected void setSelectedProjects(IJavaProject[] _prj) {
        this.selectedProjects = _prj;
    }

    private String getPreferencePageID() {
        return "org.eclipse.mtj.extension.rpm.ui.preferences.ProjectRuntimeMgmtPreferencePage";
    }

    protected String getPropertyPageID() {
        return "org.eclipse.mtj.extension.rpm.ui.preferences.ProjectRuntimeMgmtPreferencePage";
    }

    protected boolean hasProjectSpecificOptions(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        int i = 0;
        while (i < natures.length) {
            if (ProviderPrefPage.getNatureID().equals(natures[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasMtjNature(IProject project) throws CoreException {
        return project.hasNature(MTJ_NATURE_ID);
    }

    public static String getNatureID() {
        return MTJ_NATURE_ID;
    }

    public void storeValues() {
        boolean _hasProjectScope = false;
        if (this.selectedProjects != null && this.selectedProjects.length > 0) {
            _hasProjectScope = true;
        }
        TableItem[] items = this.mtjProviderViewUI.getTableViewer().getTable().getItems();
        int i = 0;
        while (i < items.length) {
            ExtensionImplNode _cd = (ExtensionImplNode)items[i].getData();
            if (_cd.getImpl() != null && _cd.getImpl() instanceof MtjExtension) {
                MtjExtension mtjE = (MtjExtension)_cd.getImpl();
                try {
                    if (_hasProjectScope) {
                        int ix = 0;
                        while (ix < this.selectedProjects.length) {
                            IProject _prj = this.selectedProjects[ix].getProject();
                            MtjServices.getInstance().setActive(mtjE.getId(), mtjE.getType(), _prj.getName(), items[i].getChecked());
                            ++ix;
                        }
                    } else {
                        MtjServices.getInstance().setActive(mtjE.getId(), mtjE.getType(), items[i].getChecked());
                    }
                }
                catch (MtjException mtjEx) {
                    MtjCorePlugin.getDefault();
                    MtjCoreUiPlugin.displayError(MtjCorePlugin.getActiveShell(), 1, 1, Messages.ProviderPrefPage_Error, Messages.ProviderPrefPage_ErrorOccurred, mtjEx);
                }
            }
            ++i;
        }
    }

    public void notifyListeners(SelectionEvent e) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((SelectionListener)this.listeners.get(i)).widgetSelected(e);
            ++i;
        }
    }

    public int getSelectedRow_Index() {
        return this.rowIndex;
    }

    protected void moveDown(int idx, Table _list) {
        this.mtjProviderViewUI.getTableViewer().getTable().deselect(idx);
        this.mtjProviderViewUI.getTableViewer().getTable().select(idx + 1);
        this.rowIndex = idx + 1;
    }

    protected void moveUp(int idx, Table _list) {
        this.mtjProviderViewUI.getTableViewer().getTable().deselect(idx);
        this.mtjProviderViewUI.getTableViewer().getTable().select(idx - 1);
        this.rowIndex = idx - 1;
    }

    public MTJProviderViewUI getMtjProviderViewUI() {
        return this.mtjProviderViewUI;
    }

    private void initializeDefaults() {
        this.initializeValues(true);
    }

    private void initializeValues(boolean _startUp) {
        if (_startUp) {
            this.mtjProviderViewUI.getTableViewer().addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    ExtensionImplNode _cd = (ExtensionImplNode)element;
                    return _cd.getName().toUpperCase().endsWith(srvProvFilter);
                }
            });
        }
        if (this.mtjProviderViewUI.getTableViewer().getTable().getItemCount() > 0) {
            this.mtjProviderViewUI.getTableViewer().getTable().select(0);
        }
        int idx = 0;
        while (idx < this.mtjProviderViewUI.getTableViewer().getTable().getItemCount()) {
            try {
                TableItem _item = this.mtjProviderViewUI.getTableViewer().getTable().getItem(idx);
                ExtensionImplNode _cd = (ExtensionImplNode)_item.getData();
                MtjExtension _m = null;
                if (_cd.getImpl() instanceof MtjExtension) {
                    _m = (MtjExtension)_cd.getImpl();
                    _item.setChecked(_m.isActive());
                }
            }
            catch (Exception ex) {
                MtjCorePlugin.getDefault();
                MtjCoreUiPlugin.displayError(MtjCorePlugin.getActiveShell(), 1, 1, Messages.ProviderPrefPage_Error, Messages.ProviderPrefPage_ErrorOccurred, ex);
            }
            ++idx;
        }
    }

    public void performDefaults() {
        this.initializeDefaults();
    }

    public void performApply() {
        StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)new StatusInfo(1, Messages.ProviderPrefPage_ProviderPerformApply));
        this.storeValues();
        super.performApply();
    }

    public boolean performCancel() {
        StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)new StatusInfo(8, Messages.ProviderPrefPage_ProviderPerformCancel));
        return super.performCancel();
    }

    public void performHelp() {
        StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)new StatusInfo(1, Messages.ProviderPrefPage_ProviderPerformHelp));
        super.performHelp();
    }

    public boolean performOk() {
        StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)new StatusInfo(0, Messages.ProviderPrefPage_ProviderPerformOK));
        this.storeValues();
        return super.performOk();
    }
}

