/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.ui.util;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.mtj.core.ui.util.CompositePrototype;
import org.eclipse.mtj.core.ui.util.DialogController;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class CompositeDialog
extends TitleAreaDialog {
    private CompositePrototype composite;
    private DialogController dialogController;
    private String title;
    private String message;
    private boolean isSetter = true;
    private String titleBarLabel = null;
    private Composite c;

    public CompositeDialog(Shell parent, CompositePrototype composite, DialogController dialogController, String title, String message, boolean isSetter) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
        this.composite = composite;
        this.dialogController = dialogController;
        this.title = title;
        this.message = message;
        this.isSetter = isSetter;
    }

    public CompositeDialog(Shell parent, CompositePrototype composite, DialogController dialogController, String titleBarLabel, String title, String message) {
        this(parent, composite, dialogController, title, message, true);
        this.setTitleBarLabel(titleBarLabel);
    }

    public void setTitleBarLabel(String title) {
        this.titleBarLabel = new String(title);
    }

    public Composite getDefaultComposite() {
        return this.c;
    }

    protected Control createDialogArea(Composite parent) {
        this.setBlockOnOpen(true);
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout());
        container.setLayoutData((Object)new GridData(1808));
        this.setMessage(this.message, 1);
        this.c = this.composite.clone();
        this.c.setParent(container);
        return this.c;
    }

    protected void okPressed() {
        if (this.dialogController != null) {
            this.dialogController.handleOK();
        }
        super.okPressed();
    }

    public static CompositeDialog createDialog(Composite composite, DialogController controller, String title, String message, boolean isSetter) {
        private class Composite
        implements CompositePrototype {
            private org.eclipse.swt.widgets.Composite c;
            private DialogController controller;

            public Composite(org.eclipse.swt.widgets.Composite c, DialogController controller) {
                this.c = c;
                this.controller = controller;
            }

            public org.eclipse.swt.widgets.Composite clone() {
                return this.c;
            }

            public DialogController getController() {
                return this.controller;
            }
        }
        Composite c = new Composite(composite, controller);
        CompositeDialog d = new CompositeDialog(composite.getShell(), (CompositePrototype)c, c.getController(), title, message, isSetter);
        return d;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        if (this.titleBarLabel != null) {
            newShell.setText(this.titleBarLabel);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        if (this.isSetter) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        }
    }
}

