/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.rpm;

import java.util.Properties;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.mtj.extension.rpm.Messages;
import org.osgi.framework.BundleContext;

public class RpmPlugin
extends Plugin {
    private static final String LOGGING_LEVEL = "logging.level";
    private static final Logger log;
    private static RpmPlugin plugin;

    static {
        Logger l = Logger.getLogger("");
        Properties p = new Properties();
        try {
            p.load(RpmPlugin.class.getClassLoader().getResourceAsStream("org/eclipse/mtj/extension/rpm/rpm.properties"));
        }
        catch (Exception e) {
            l.log(Level.WARNING, Messages.RpmPlugin_CouldNotLoadRpmProperties, e);
        }
        String levelString = System.getProperty(LOGGING_LEVEL, p.getProperty(LOGGING_LEVEL, "WARNING"));
        Level level = Level.parse(levelString);
        l.setLevel(level);
        Handler[] h = l.getHandlers();
        int i = 0;
        while (i < h.length) {
            l.removeHandler(h[i]);
            ++i;
        }
        ConsoleHandler ch = new ConsoleHandler();
        ch.setLevel(level);
        l.addHandler(ch);
        l.info(Messages.RpmPlugin_Init);
        log = Logger.getLogger(RpmPlugin.class.getName());
    }

    public RpmPlugin() {
        log.info(Messages.RpmPlugin_ConstructingPlugin);
        plugin = this;
    }

    public static String getPluginId() {
        return RpmPlugin.getDefault().getBundle().getSymbolicName();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static RpmPlugin getDefault() {
        return plugin;
    }
}

