/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.rpm.preferences;

import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mtj.api.runtimes.RuntimePlatform;
import org.eclipse.mtj.extension.rpm.Messages;
import org.eclipse.mtj.extension.rpm.RpmPlugin;
import org.eclipse.mtj.extension.rpm.model.MtjServiceHandler;
import org.eclipse.mtj.extension.rpm.preferences.RpmController;
import org.eclipse.mtj.extension.rpm.ui.preferences.RuntimeListComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class RpmPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static Logger log = Logger.getLogger(RpmPreferencePage.class.getName());
    private RuntimeListComposite runtimeListComposite;
    private RpmController rpmController;

    public RpmPreferencePage() {
        log.info(Messages.RpmPreferencePage_ConstructingRpmPreferencePage);
        this.setTitle(Messages.RpmPreferencePage_RuntimePlatform);
        this.setDescription(Messages.RpmPreferencePage_CreateAndModifyRuntimePlatforms);
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, String.valueOf(RpmPlugin.getPluginId()) + ".mtjcore0000");
        this.runtimeListComposite = new RuntimeListComposite(parent);
        this.rpmController = new RpmController(this.runtimeListComposite);
        return this.runtimeListComposite;
    }

    public void init(IWorkbench workbench) {
    }

    public void performDefaults() {
        MessageDialog dialog = new MessageDialog(this.getShell(), Messages.RpmController_Confirm, null, Messages.RpmPreferencePage_ConfirmRemovalDescription, 3, new String[]{Messages.RpmController_Ok, Messages.RpmController_Cancel}, 0);
        if (dialog.open() == 0) {
            this.rpmController.setDefaults();
        }
    }

    private boolean storeRuntimes(RuntimePlatform[] runtimes) {
        boolean okToStore = MtjServiceHandler.storeRuntimes(runtimes);
        log.info("Runtime store performed in rpm preferences page : " + okToStore);
        if (okToStore) {
            return super.performOk();
        }
        return okToStore;
    }

    public boolean performOk() {
        return this.storeRuntimes(this.rpmController.getRuntimePlatforms() != null ? this.rpmController.getRuntimePlatforms() : new RuntimePlatform[]{});
    }
}

