/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.rpm.preferences;

import java.util.ArrayList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.runtimes.RuntimePlatform;

class RuntimePlatformContentProvider
implements IStructuredContentProvider {
    private TableViewer myViewer;
    private RuntimePlatform[] myInput;

    public RuntimePlatformContentProvider(TableViewer viewer) {
        this.myViewer = viewer;
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof RuntimePlatform[]) {
            return (RuntimePlatform[])inputElement;
        }
        if (inputElement instanceof EList) {
            return (RuntimePlatform[])((EList)inputElement).toArray();
        }
        return null;
    }

    public Object addVariable(Object inputElement, RuntimePlatform newRp) {
        RuntimePlatform[] newInput = null;
        if (inputElement == null) {
            inputElement = new RuntimePlatform[]{newRp};
            newInput = inputElement;
        } else if (inputElement instanceof EList) {
            EList cfr_ignored_0 = (EList)inputElement;
            ((EList)inputElement).add((Object)newRp);
            newInput = inputElement;
        } else if (inputElement instanceof RuntimePlatform[]) {
            RuntimePlatform[] oldInput = inputElement;
            RuntimePlatform[] newRpInput = new RuntimePlatform[oldInput.length + 1];
            int i = 0;
            while (i < oldInput.length) {
                newRpInput[i] = oldInput[i];
                ++i;
            }
            newRpInput[oldInput.length] = newRp;
            newInput = newRpInput;
        }
        this.myViewer.setInput((Object)newInput);
        return newInput;
    }

    public RuntimePlatform[] removeVariable(Object oldInputElement, RuntimePlatform selectedRp) {
        if (oldInputElement instanceof RuntimePlatform[]) {
            RuntimePlatform[] oldInput = (RuntimePlatform[])oldInputElement;
            if (oldInput.length == 1) {
                return null;
            }
            ArrayList<RuntimePlatform> list = new ArrayList<RuntimePlatform>();
            int i = 0;
            while (i < oldInput.length) {
                if (oldInput[i].getName().intern() != selectedRp.getName().intern()) {
                    list.add(oldInput[i]);
                }
                ++i;
            }
            RuntimePlatform[] newInput = new RuntimePlatform[list.size()];
            return list.toArray(newInput);
        }
        if (oldInputElement instanceof EList) {
            EList list = (EList)oldInputElement;
            if (list.size() == 1) {
                return null;
            }
            list.remove((Object)selectedRp);
            return (RuntimePlatform[])list.toArray();
        }
        return null;
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.myViewer = (TableViewer)viewer;
        if (newInput instanceof EList) {
            this.myInput = (RuntimePlatform[])((EList)newInput).toArray();
        } else if (newInput instanceof RuntimePlatform[]) {
            this.myInput = (RuntimePlatform[])newInput;
        } else if (newInput instanceof RuntimePlatform) {
            this.myInput = new RuntimePlatform[1];
            this.myInput[0] = (RuntimePlatform)newInput;
        } else {
            this.myInput = null;
        }
    }
}

