/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.bp.eclipse.midp;

import java.util.Properties;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.core.SourceType;
import org.eclipse.mtj.api.enumerations.DeploymentType;
import org.eclipse.mtj.api.extension.PackagingProvider;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.core.ui.util.MidletSearchScope;
import org.eclipse.mtj.core.util.EclipseUtil;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.bp.eclipse.BuildProviderUtil;

public class MidpPackaging {
    private IMtjProject mtjProject;
    private IFolder binaryFolder;
    private IFolder binaryLibFolder;
    private IFolder deploymentFolder;
    private IProgressMonitor monitor;

    public MidpPackaging(IMtjProject mtjProject, IProgressMonitor monitor) {
        this.mtjProject = mtjProject;
        this.monitor = monitor;
    }

    public void performPackaging(String natureId) throws MtjException, CoreException {
        DeploymentType dtype = BuildProviderUtil.getDeploymentType(this.mtjProject);
        PackagingProvider provider = BuildProviderUtil.getPackagingProvider(this.mtjProject, dtype);
        IResource[] outputResources = new IResource[]{this.getBinaryFolder(), this.getBinaryLibFolder()};
        IJavaProject project = this.mtjProject.getJavaProject();
        IClasspathEntry[] e = project.getRawClasspath();
        Properties p = new Properties();
        int i = 0;
        while (i < e.length) {
            if (e[i].getEntryKind() == 3 && e[i].getContentKind() == 1) {
                this.addMidlets(p, e[i].getPath());
            }
            ++i;
        }
        provider.setMidletProperties(p);
        provider.createDeployment(this.mtjProject.getProject().getName(), this.mtjProject.getProjectData(), outputResources, this.getDeploymentFolder(), dtype, natureId, this.monitor);
        EclipseUtil.setResourcesAsDerived((IContainer)this.getDeploymentFolder());
    }

    private void addMidlets(Properties p, IPath path) throws MtjException, CoreException {
        IJavaProject project = this.mtjProject.getJavaProject();
        SearchPattern pattern = SearchPattern.createPattern((String)"*", (int)0, (int)0, (int)10);
        MidletSearchScope scope = new MidletSearchScope(project);
        SearchEngine searchEngine = new SearchEngine();
        private class Requestor
        extends SearchRequestor {
            private Properties p;

            public Requestor(Properties p) {
                this.p = p;
            }

            public void acceptSearchMatch(SearchMatch match) {
                if (match.getElement() instanceof SourceType) {
                    String className = ((SourceType)match.getElement()).getElementName();
                    String classPath = ((SourceType)match.getElement()).getFullyQualifiedName();
                    this.p.setProperty("MIDlet-", String.valueOf(className) + ", , " + classPath);
                }
            }
        }
        searchEngine.search(pattern, new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, (IJavaSearchScope)scope, (SearchRequestor)new Requestor(p), null);
    }

    public IFolder getDeploymentFolder() throws CoreException {
        if (this.deploymentFolder == null) {
            this.deploymentFolder = this.mtjProject.getDeploymentFolder(this.monitor);
            if (this.deploymentFolder.exists()) {
                this.deploymentFolder.delete(true, this.monitor);
            }
            this.deploymentFolder.create(true, true, this.monitor);
        }
        if (!this.deploymentFolder.exists()) {
            this.deploymentFolder.create(true, true, this.monitor);
        }
        return this.deploymentFolder;
    }

    public void setDeploymentFolder(IFolder deploymentFolder) throws CoreException {
        if (deploymentFolder.exists()) {
            deploymentFolder.delete(true, this.monitor);
        }
        deploymentFolder.create(true, true, this.monitor);
        this.deploymentFolder = deploymentFolder;
    }

    public IFolder getBinaryFolder() throws CoreException {
        if (this.binaryFolder == null) {
            this.binaryFolder = this.mtjProject.getVerifiedClassesOutputFolder(this.monitor);
        }
        return this.binaryFolder;
    }

    public void setBinaryFolder(IFolder outputFolder) {
        this.binaryFolder = outputFolder;
    }

    public IFolder getBinaryLibFolder() throws CoreException {
        if (this.binaryLibFolder == null) {
            this.binaryLibFolder = this.mtjProject.getVerifiedLibrariesOutputFolder(this.monitor);
        }
        return this.binaryLibFolder;
    }

    public void setBinaryLibFolder(IFolder binaryLibFolder) {
        this.binaryLibFolder = binaryLibFolder;
    }
}

