/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.core;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.core.util.MtjEmfUtil;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.project.MtjProject;

public class J2MEClasspathContainer
implements IClasspathContainer {
    public static final String J2ME_CONTAINER = Messages.JavaMEClasspathContainer_Container;
    public static final String J2ME_LIBRARY_LABEL = Messages.JavaMEClasspathContainer_Library;
    private IJavaProject project;
    private IPath path;
    private String description;
    private IClasspathEntry[] cachedEntries;

    public J2MEClasspathContainer(IJavaProject project, IPath path) throws CoreException {
        this.project = project;
        this.path = path;
    }

    public static IClasspathEntry[] getClasspathEntries(RuntimePlatformDefinition rpd) {
        if (rpd != null) {
            return MtjEmfUtil.getClasspathEntries((RuntimePlatformDefinition)rpd);
        }
        return new IClasspathEntry[0];
    }

    public static IClasspathEntry[] getClasspathEntries(IJavaProject project) {
        RuntimePlatformDefinition rpd = null;
        try {
            rpd = J2MEClasspathContainer.getProjectRPD(project);
        }
        catch (MtjException e) {
            e.printStackTrace();
            return null;
        }
        if (rpd != null) {
            return MtjEmfUtil.getClasspathEntries((RuntimePlatformDefinition)rpd);
        }
        return new IClasspathEntry[0];
    }

    public IClasspathEntry[] getClasspathEntries() {
        if (this.cachedEntries == null) {
            if (!this.project.exists()) {
                try {
                    Project openProject = MtjProject.getTemporaryProjectData(this.project);
                    TargetDevice targetDevice = openProject.getDefaultTargetDevice();
                    RuntimePlatformDefinition rpd = targetDevice.getRuntimePlatform();
                    return J2MEClasspathContainer.getClasspathEntries(rpd);
                }
                catch (MtjException e) {
                    e.printStackTrace();
                    return new IClasspathEntry[0];
                }
            }
            this.cachedEntries = J2MEClasspathContainer.getClasspathEntries(this.project);
        }
        return this.cachedEntries;
    }

    public String getDescription() {
        if (this.description == null) {
            this.description = String.valueOf(J2ME_LIBRARY_LABEL) + Messages.JavaMEClasspathContainer_Failed_get_library_information;
            try {
                RuntimePlatformDefinition rpd = J2MEClasspathContainer.getProjectRPD(this.project);
                if (rpd != null) {
                    this.description = new String(String.valueOf(J2ME_LIBRARY_LABEL) + " [ " + rpd.getName() + " ]");
                }
            }
            catch (MtjException mtjException) {}
        }
        return this.description;
    }

    public int getKind() {
        return 1;
    }

    public IPath getPath() {
        return this.path;
    }

    private static RuntimePlatformDefinition getProjectRPD(IJavaProject project) throws MtjException {
        Project proj;
        RuntimePlatformDefinition rpd = null;
        IMtjProject mtjproject = MtjProject.getMtjProject(project);
        if (mtjproject != null && (proj = mtjproject.getProjectData()) != null && proj.getDefaultTargetDevice() != null && proj.getDefaultTargetDevice().getRuntimePlatform() != null) {
            rpd = proj.getDefaultTargetDevice().getRuntimePlatform();
        }
        if (rpd == null) {
            try {
                Project openProject = MtjProject.getTemporaryProjectData(project);
                TargetDevice targetDevice = openProject.getDefaultTargetDevice();
                rpd = targetDevice.getRuntimePlatform();
            }
            catch (MtjException mtjException) {}
        }
        return rpd;
    }
}

