/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.project;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.enumerations.DeploymentType;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.enumerations.ProjectType;
import org.eclipse.mtj.api.extension.DeviceManagement;
import org.eclipse.mtj.api.extension.PersistentStoreProvider;
import org.eclipse.mtj.api.extension.ProjectExtensionProvider;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.model.preverifier.IPreverificationPolicy;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.MtjDevIdePlugin;
import org.eclipse.mtj.extension.devide.core.J2MEClasspathContainer;
import org.eclipse.mtj.extension.devide.nature.MtjNature;

public class MtjProject
implements IMtjProject {
    public static final String PROJECT_DATA_FILE_NAME = "mtj.project";
    public static final String CLASSES_DIRECTORY = "classes";
    public static final String LIBS_DIRECTORY = "libs";
    private static final Map projectSuiteMap = new HashMap();
    private static final QualifiedName DEPLOYMENT_UP_TO_DATE_PROP = new QualifiedName("org.eclipse.mtj.core.ui", "deployed_up_to_date");
    private IJavaProject javaProject;
    private ProjectExtensionProvider projectExtension;

    public static IMtjProject getMtjProject(IJavaProject javaProject) throws MtjException {
        block7: {
            block6: {
                if (javaProject != null) break block6;
                return null;
            }
            if (javaProject.exists()) break block7;
            return null;
        }
        try {
            if (MtjNature.hasMtjNature(javaProject.getProject())) {
                return MtjProject.getMtjProject(javaProject, null);
            }
        }
        catch (CoreException e) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)5002), (Throwable)e);
        }
        catch (MtjException e) {
            throw e;
        }
        return null;
    }

    public static IMtjProject getMtjProject(IProject project) throws MtjException {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        return MtjProject.getMtjProject(javaProject);
    }

    public static IMtjProject getMtjProject(String projectName) throws MtjException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        return MtjProject.getMtjProject(project);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IMtjProject getMtjProject(IJavaProject javaProject, ProjectExtensionProvider projectExtension) throws MtjException {
        IMtjProject suite = null;
        Map map = projectSuiteMap;
        synchronized (map) {
            suite = (IMtjProject)projectSuiteMap.get(javaProject);
            if (suite == null) {
                suite = new MtjProject(javaProject);
                projectSuiteMap.put(javaProject, suite);
            }
        }
        if (projectExtension != null) {
            suite.setProjectExtensionProvider(projectExtension);
        } else {
            Project project = suite.getProjectData();
            if (project == null) {
                throw new MtjException(Messages.MtjProject_Project_data_not_found);
            }
            ProjectType projectType = project.getType();
            if (projectType == null) {
                throw new MtjException(Messages.MtjProject_Project_type_not_defined);
            }
            ProjectExtensionProvider projectExtensionProvider = MtjServices.getInstance().getProjectExtension(projectType);
            suite.setProjectExtensionProvider(projectExtensionProvider);
        }
        return suite;
    }

    public void setProjectExtensionProvider(ProjectExtensionProvider projectExtension) {
        this.projectExtension = projectExtension;
    }

    private MtjProject(IJavaProject javaProject) {
        this.javaProject = javaProject;
    }

    public IFolder getVerifiedClassesOutputFolder(IProgressMonitor monitor) throws CoreException {
        String outputFolderName = this.projectExtension.getLaunchableClassesFolder(monitor);
        return this.getFolder(outputFolderName, monitor);
    }

    public IFolder getFolder(String folderName, IProgressMonitor monitor) throws CoreException {
        IFolder ret = null;
        String folder = folderName.replace('\\', '/');
        StringTokenizer st = new StringTokenizer(folder, "/");
        while (st.hasMoreTokens()) {
            String fl = st.nextToken();
            if ((ret = ret == null ? this.getProject().getFolder(fl) : ret.getFolder(fl)).exists()) continue;
            ret.create(true, true, monitor);
        }
        return ret;
    }

    public IProject getProject() {
        return this.javaProject.getProject();
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public IFolder getDeploymentFolder(IProgressMonitor monitor) throws CoreException {
        String outputFolderName = this.projectExtension.getDeploymentFolder(monitor);
        IFolder outputFolder = this.getProject().getFolder(outputFolderName);
        if (!outputFolder.exists()) {
            outputFolder.create(true, true, monitor);
        }
        return outputFolder;
    }

    public IFolder getVerifiedLibrariesOutputFolder(IProgressMonitor monitor) throws CoreException {
        String outputFolderName = this.projectExtension.getLaunchableLibsFolder(monitor);
        return this.getFolder(outputFolderName, monitor);
    }

    public IFolder getClassesOutputFolder(IProgressMonitor monitor) throws CoreException {
        IFolder outputFolder;
        IPath outputLocation = this.getJavaProject().getOutputLocation();
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        try {
            outputFolder = workspaceRoot.getFolder(outputLocation);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            outputFolder = workspaceRoot.getFolder(outputLocation.append("preverifyOutput"));
        }
        return outputFolder;
    }

    public DevicePlatform getPlatformDefinition() throws MtjException {
        try {
            String name;
            TargetDevice td;
            Project project = this.getProjectData();
            if (project != null && (td = project.getDefaultTargetDevice()) != null && (name = td.getDevicePlatformName()) != null) {
                DeviceManagement dm = (DeviceManagement)MtjServices.getInstance().getImplementations(ExtensionType.DEVICE_MANAGEMENT_LITERAL, null, null)[0];
                DevicePlatform dp = dm.getDevicePlatformByName(name);
                if (dp == null) {
                    throw new MtjException(String.valueOf(Messages.MtjProject_Device_platform_does_not_exist) + name);
                }
                return dp;
            }
        }
        catch (Exception ex) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)1001), (Throwable)ex);
        }
        throw new MtjException(Messages.MtjProject_Device_platform_not_found);
    }

    public Device[] getDevices() throws MtjException {
        ArrayList<Device> list = new ArrayList<Device>();
        try {
            Project project = this.getProjectData();
            if (project != null) {
                for (TargetDevice td : project.getTargetDevices()) {
                    String deviceName;
                    String name;
                    Device device;
                    if (td == null || (device = this.getDevice(name = td.getDevicePlatformName(), deviceName = td.getDeviceName())) == null) continue;
                    list.add(device);
                }
            }
        }
        catch (Exception ex) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)1001), (Throwable)ex);
        }
        Device[] ds = new Device[list.size()];
        int i = 0;
        while (i < list.size()) {
            ds[i] = (Device)list.get(i);
            ++i;
        }
        return ds;
    }

    public Device getDefaultDevice() throws MtjException {
        try {
            String deviceName;
            String name;
            Device device;
            TargetDevice td;
            Project project = this.getProjectData();
            if (project != null && (td = project.getDefaultTargetDevice()) != null && (device = this.getDevice(name = td.getDevicePlatformName(), deviceName = td.getDeviceName())) != null) {
                return device;
            }
        }
        catch (Exception ex) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)1001), (Throwable)ex);
        }
        throw new MtjException(Messages.MtjProject_Device_platform_not_found_2);
    }

    public Device getDevice(TargetDevice targetDevice) throws MtjException {
        return this.getDevice(targetDevice.getDevicePlatformName(), targetDevice.getDeviceName());
    }

    private Device getDevice(String devicePlatformName, String deviceName) throws MtjException {
        DeviceManagement dm;
        DevicePlatform platform;
        if (devicePlatformName != null && deviceName != null && (platform = (dm = (DeviceManagement)MtjServices.getInstance().getImplementations(ExtensionType.DEVICE_MANAGEMENT_LITERAL, null, null)[0]).getDevicePlatformByName(devicePlatformName)) != null) {
            for (Device device : platform.getDevices()) {
                if (!deviceName.equals(device.getName())) continue;
                return device;
            }
        }
        return null;
    }

    public Project getProjectData() throws MtjException {
        IFile file;
        PersistentStoreProvider pstore;
        block5: {
            try {
                pstore = (PersistentStoreProvider)MtjServices.getInstance().getImplementations(ExtensionType.PERSISTENT_STORE_PROVIDER_LITERAL, null, null)[0];
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IWorkspaceRoot root = workspace.getRoot();
                IProject project2 = root.getProject(this.javaProject.getProject().getName());
                file = project2.getFile(PROJECT_DATA_FILE_NAME);
                if (!project2.exists()) {
                    throw new MtjException(String.valueOf(Messages.MtjProject_Project_does_not_exist) + this.javaProject.getProject().getName());
                }
                if (!project2.isOpen()) {
                    project2.open(null);
                }
                if (file.exists()) break block5;
                return null;
            }
            catch (Exception ex) {
                throw new MtjException(MtjCoreErrors.getErrorMessage((int)1001), (Throwable)ex);
            }
        }
        String fileName = file.getLocation().toFile().toURI().toString();
        EList list = (EList)pstore.get(0, "project", fileName);
        return (Project)list.get(0);
    }

    public static Project getTemporaryProjectData(IJavaProject javaProject) throws MtjException {
        String projectName = javaProject.getProject().getName();
        return MtjProject.getTemporaryProjectData(projectName);
    }

    public static boolean isTemporaryProjectDataExisting(String projectName) {
        IPath path = MtjProject.getMetadataTemporaryStorage(projectName);
        return path.toFile().exists();
    }

    public static Project getTemporaryProjectData(String projectName) throws MtjException {
        IPath filePath;
        PersistentStoreProvider pstore;
        block3: {
            try {
                pstore = (PersistentStoreProvider)MtjServices.getInstance().getImplementations(ExtensionType.PERSISTENT_STORE_PROVIDER_LITERAL, null, null)[0];
                IPath path = MtjProject.getMetadataTemporaryStorage(projectName);
                filePath = path.append(PROJECT_DATA_FILE_NAME);
                if (filePath.toFile().exists()) break block3;
                return null;
            }
            catch (Exception ex) {
                throw new MtjException(MtjCoreErrors.getErrorMessage((int)1001), (Throwable)ex);
            }
        }
        String fileName = filePath.toFile().toURI().toString();
        EList list = (EList)pstore.get(0, "project", fileName);
        return (Project)list.get(0);
    }

    public static IPath getMetadataTemporaryStorage(String projectName) {
        IPath metaDataArea = MtjDevIdePlugin.getDefault().getStateLocation();
        IPath metadataPath = metaDataArea.append(projectName);
        return metadataPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProjectData(IJavaProject javaProject, Project project) throws MtjException {
        block7: {
            try {
                if (!MtjNature.hasMtjNature(javaProject.getProject())) break block7;
                IMtjProject suite = null;
                Map map = projectSuiteMap;
                synchronized (map) {
                    suite = (IMtjProject)projectSuiteMap.get(javaProject);
                    if (suite == null) {
                        suite = new MtjProject(javaProject);
                        projectSuiteMap.put(javaProject, suite);
                    }
                    suite.setProjectData(project);
                }
            }
            catch (CoreException e) {
                throw new MtjException(MtjCoreErrors.getErrorMessage((int)5002), (Throwable)e);
            }
            catch (MtjException e) {
                throw e;
            }
        }
    }

    public void setProjectData(Project project) throws MtjException {
        try {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            IProject project2 = root.getProject(this.javaProject.getProject().getName());
            IFile file = project2.getFile(PROJECT_DATA_FILE_NAME);
            if (!project2.exists()) {
                throw new MtjException(String.valueOf(Messages.MtjProject_Project_does_not_exist) + this.javaProject.getProject().getName());
            }
            if (!project2.isOpen()) {
                project2.open(null);
            }
            String fileName = file.getLocation().toFile().toURI().toString();
            PersistentStoreProvider pstore = (PersistentStoreProvider)MtjServices.getInstance().getImplementations(ExtensionType.PERSISTENT_STORE_PROVIDER_LITERAL, null, null)[0];
            pstore.store((Object)project, 0, "project", fileName);
            file.refreshLocal(0, (IProgressMonitor)new NullProgressMonitor());
            this.updateProjectClasspath((IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception ex) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)1001), (Throwable)ex);
        }
    }

    public static void setProjectDataTemporaryLocation(Project project, IPath path) throws MtjException {
        try {
            boolean success;
            IPath filePath = path.append(PROJECT_DATA_FILE_NAME);
            path.toFile().mkdirs();
            File outputFile = filePath.toFile();
            if (outputFile.exists() && !(success = outputFile.delete())) {
                throw new MtjException(String.valueOf(Messages.MtjProject_Error_deleting_temporary_file) + outputFile.toURI());
            }
            outputFile.createNewFile();
            String fileName = outputFile.toURI().toString();
            PersistentStoreProvider pstore = (PersistentStoreProvider)MtjServices.getInstance().getImplementations(ExtensionType.PERSISTENT_STORE_PROVIDER_LITERAL, null, null)[0];
            pstore.store((Object)project, 0, "project", fileName);
        }
        catch (Exception ex) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)1001), (Throwable)ex);
        }
    }

    public static void deleteProjectData(String projectName) {
        IPath metadataPath = MtjProject.getMetadataTemporaryStorage(projectName);
        IPath filePath = metadataPath.append(PROJECT_DATA_FILE_NAME);
        filePath.toFile().delete();
        metadataPath.toFile().delete();
    }

    public Deployment getDeployment() throws CoreException {
        if (this.projectExtension == null) {
            return null;
        }
        try {
            return this.projectExtension.getDeployment((IMtjProject)this);
        }
        catch (MtjException e) {
            Status status = new Status(4, "org.eclipse.mtj.core.ui", 5001, MtjCoreErrors.getErrorMessage((int)5001), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    public Deployment getDeployment(String launchableApplication) throws CoreException {
        if (this.projectExtension == null) {
            return null;
        }
        try {
            return this.projectExtension.getDeployment((IMtjProject)this, launchableApplication);
        }
        catch (MtjException e) {
            Status status = new Status(4, "org.eclipse.mtj.core.ui", 5001, MtjCoreErrors.getErrorMessage((int)5001), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    public boolean isDeployedJarUpToDate() throws CoreException {
        String upToDateString = this.getProject().getPersistentProperty(DEPLOYMENT_UP_TO_DATE_PROP);
        return upToDateString == null ? false : upToDateString.equals("true");
    }

    public DeploymentType getDeploymentType() throws CoreException {
        if (this.projectExtension == null) {
            return null;
        }
        try {
            return this.projectExtension.getDeploymentType();
        }
        catch (MtjException e) {
            Status status = new Status(4, "org.eclipse.mtj.core.ui", 5002, MtjCoreErrors.getErrorMessage((int)5002), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    public IJavaSearchScope getJavaSearchScope(IJavaProject javaProject) throws CoreException {
        if (this.projectExtension == null) {
            return null;
        }
        try {
            return this.projectExtension.getJavaSearchScope(javaProject);
        }
        catch (MtjException e) {
            Status status = new Status(4, "org.eclipse.mtj.core.ui", 5003, MtjCoreErrors.getErrorMessage((int)5003), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    public IPreverificationPolicy getPreverificationPolicy(RuntimePlatformDefinition targetPlatform) throws CoreException {
        if (this.projectExtension == null) {
            return null;
        }
        try {
            return this.projectExtension.getPreverificationPolicy(targetPlatform);
        }
        catch (MtjException e) {
            Status status = new Status(4, "org.eclipse.mtj.core.ui", 5002, MtjCoreErrors.getErrorMessage((int)5003), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    public void updateProjectClasspath(IProgressMonitor monitor) throws CoreException {
        JavaCore.setClasspathContainer((IPath)new Path(J2MEClasspathContainer.J2ME_CONTAINER), (IJavaProject[])new IJavaProject[]{this.getJavaProject()}, (IClasspathContainer[])new IClasspathContainer[1], (IProgressMonitor)monitor);
        this.getProject().build(6, monitor);
    }

    public void initializeNewProject(IProgressMonitor monitor) throws CoreException {
        if (this.projectExtension == null) {
            return;
        }
        try {
            this.projectExtension.initializeNewProject(this.getJavaProject(), monitor);
        }
        catch (MtjException e) {
            Status status = new Status(4, "org.eclipse.mtj.core.ui", 5002, MtjCoreErrors.getErrorMessage((int)5003), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        this.updateProjectClasspath(monitor);
    }

    public void addClasspathContainerIfMissing(IProgressMonitor monitor) throws CoreException {
        if (!MtjProject.containsJ2MEClasspathContainer(this.getJavaProject())) {
            Path entryPath = new Path(J2MEClasspathContainer.J2ME_CONTAINER);
            IClasspathEntry newEntry = JavaCore.newContainerEntry((IPath)entryPath);
            IClasspathEntry[] rawClasspath = this.javaProject.getRawClasspath();
            LinkedHashSet<IClasspathEntry> currentClasspath = new LinkedHashSet<IClasspathEntry>(rawClasspath.length);
            int i = 0;
            while (i < rawClasspath.length) {
                IClasspathEntry entry = rawClasspath[i];
                if (entry.getEntryKind() == 4) {
                    entry = JavaCore.getResolvedClasspathEntry((IClasspathEntry)entry);
                }
                currentClasspath.add(entry);
                ++i;
            }
            IClasspathEntry[] platformEntries = J2MEClasspathContainer.getClasspathEntries(this.javaProject);
            int i2 = 0;
            while (i2 < platformEntries.length) {
                IClasspathEntry entry = platformEntries[i2];
                if (currentClasspath.contains(entry)) {
                    currentClasspath.remove(entry);
                }
                ++i2;
            }
            currentClasspath.add(newEntry);
            IClasspathEntry[] newClasspath = currentClasspath.toArray(new IClasspathEntry[currentClasspath.size()]);
            this.javaProject.setRawClasspath(newClasspath, monitor);
        }
    }

    public static boolean containsJ2MEClasspathContainer(IJavaProject javaProject) throws JavaModelException {
        boolean contains = false;
        IClasspathEntry[] classpath = javaProject.getRawClasspath();
        int i = 0;
        while (i < classpath.length) {
            IClasspathEntry entry = classpath[i];
            if (entry.getEntryKind() == 5 && entry.getPath().segment(0).equals(J2MEClasspathContainer.J2ME_CONTAINER)) {
                contains = true;
                break;
            }
            ++i;
        }
        return contains;
    }
}

