/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.ui.wizard.projectcreation;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPage;
import org.eclipse.mtj.api.enumerations.ProjectType;
import org.eclipse.mtj.api.project.Project;
import org.eclipse.mtj.api.project.ProjectFactory;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.core.ui.model.ProjectCreationModel;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.core.J2MEClasspathContainer;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.mtj.extension.devide.ui.wizard.midletsuite.MidletSuitePackagingWizardPage;
import org.eclipse.mtj.extension.devide.ui.wizard.projectcreation.MTJNewProjectSelectLibraryWizardPage;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class MTJNewProjectWizardPage
extends NewJavaProjectWizardPage {
    static char sep = (char)47;
    public ProjectCreationModel projectModel;
    MTJNewProjectSelectLibraryWizardPage javaSDKPage;
    MidletSuitePackagingWizardPage midletPage;
    TargetDevice lastTargetDevice = null;
    boolean forMIDP = false;
    String binDirectoryName = null;
    String srcDirectoryName = null;
    private boolean savedTemporaryMetadata = false;

    public MTJNewProjectWizardPage(IWorkspaceRoot root, WizardNewProjectCreationPage mainpage, ProjectCreationModel projectModel, MTJNewProjectSelectLibraryWizardPage javaSDKPage, MidletSuitePackagingWizardPage midletPage) {
        super(root, mainpage);
        this.projectModel = projectModel;
        this.javaSDKPage = javaSDKPage;
        this.midletPage = midletPage;
        this.setImageDescriptor(JavaPluginImages.DESC_WIZBAN_ADD_LIBRARY);
    }

    public void setForMidp(boolean value) {
        this.forMIDP = value;
    }

    public void setForMidp() {
        this.forMIDP = true;
    }

    public Control getControl() {
        this.setProjectModified();
        return super.getControl();
    }

    protected void initBuildPaths() {
        if (!this.updateDefaultClassPath()) {
            return;
        }
        boolean useSrcAndOutputDir = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects");
        if (useSrcAndOutputDir) {
            String srcbinBINName = PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersBinName");
            Path path = new Path(String.valueOf(sep) + this.getProjectHandle().getName() + sep + srcbinBINName);
            this.setDefaultOutputFolder((IPath)path);
        } else {
            String srcbinBINName = "bin";
            Path path = new Path(String.valueOf(sep) + this.getProjectHandle().getName() + sep + srcbinBINName);
            this.setDefaultOutputFolder((IPath)path);
        }
        super.initBuildPaths();
    }

    private boolean updateDefaultClassPath() {
        TargetDevice[] targetDevice = this.javaSDKPage.getProjectModelData();
        if (targetDevice == null || targetDevice.length == 0 || targetDevice[0].getRuntimePlatform() == null) {
            return false;
        }
        this.lastTargetDevice = targetDevice[0];
        Path entryPath = new Path(J2MEClasspathContainer.J2ME_CONTAINER);
        ArrayList<IClasspathEntry> classpathEntries = new ArrayList<IClasspathEntry>();
        classpathEntries.add(this.getSrcEntry());
        classpathEntries.add(JavaCore.newContainerEntry((IPath)entryPath));
        IClasspathEntry[] newEntry = classpathEntries.toArray(new IClasspathEntry[classpathEntries.size()]);
        if (this.forMIDP) {
            this.storeProjectData(ProjectType.PROJECT_TYPE_MIDP_LITERAL, targetDevice);
        } else {
            this.storeProjectData(ProjectType.PROJECT_TYPE_PERSONAL_PROFILE_LITERAL, targetDevice);
        }
        this.setProjectModified();
        super.setDefaultClassPath(newEntry, false);
        return true;
    }

    private void storeProjectData(ProjectType projectType, TargetDevice[] targetDevice) {
        Project project = ProjectFactory.eINSTANCE.createProject();
        project.setType(projectType);
        if (targetDevice != null && targetDevice.length > 0) {
            project.setDefaultTargetDevice(targetDevice[0]);
        }
        if (targetDevice != null && targetDevice.length > 1) {
            int i = 1;
            while (i < targetDevice.length) {
                project.getTargetDevices().add((Object)targetDevice[i]);
                ++i;
            }
        }
        IPath metadataPath = MtjProject.getMetadataTemporaryStorage(this.getProjectName());
        try {
            MtjProject.setProjectDataTemporaryLocation(project, metadataPath);
            this.savedTemporaryMetadata = true;
        }
        catch (MtjException e) {
            e.printStackTrace();
        }
    }

    public IClasspathEntry getSrcEntry() {
        boolean useSrcAndOutputDir = PreferenceConstants.getPreferenceStore().getBoolean("org.eclipse.jdt.ui.wizards.srcBinFoldersInNewProjects");
        String srcbinSRCName = useSrcAndOutputDir ? PreferenceConstants.getPreferenceStore().getString("org.eclipse.jdt.ui.wizards.srcBinFoldersSrcName") : "src";
        Path path = new Path(String.valueOf(sep) + this.getProjectHandle().getName() + sep + srcbinSRCName);
        return JavaCore.newSourceEntry((IPath)path);
    }

    public void dispose() {
        if (this.savedTemporaryMetadata) {
            MtjProject.deleteProjectData(this.getProjectName());
        }
        super.dispose();
    }

    public String getProjectName() {
        if (this.getProjectHandle() != null) {
            return this.getProjectHandle().getName();
        }
        return "";
    }

    public IProject getProject() {
        if (this.javaSDKPage.isPageComplete() && this.getProjectHandle() != null) {
            return this.getProjectHandle().getProject();
        }
        return null;
    }

    public boolean isPageComplete() {
        if (this.midletPage != null) {
            String project = this.getProjectName();
            this.midletPage.setProjectName(project);
        }
        return super.isPageComplete();
    }
}

