/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.executable.uei;

import java.io.File;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mtj.api.devices.Configuration;
import org.eclipse.mtj.api.devices.ConfigurationItem;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DeviceDescription;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.devices.DevicesFactory;
import org.eclipse.mtj.api.devices.ProtectionDomain;
import org.eclipse.mtj.api.enumerations.PlatformType;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.api.runtimes.RuntimesFactory;
import org.eclipse.mtj.api.runtimes.ServiceApi;
import org.eclipse.mtj.core.toolkit.DevicePlatformImporter;
import org.eclipse.mtj.executable.uei.AbstractServiceApiImporter;
import org.eclipse.mtj.executable.uei.IServiceApiImporter;
import org.eclipse.mtj.executable.uei.UEIConstants;
import org.eclipse.mtj.executable.uei.UeiExecutable;
import org.eclipse.mtj.executable.uei.UeiPropertiesCache;

public abstract class AbstractUeiDevicePlatformImporter
implements DevicePlatformImporter,
UEIConstants {
    protected Properties ueiProperties;

    public abstract boolean hasDebugServer();

    public abstract boolean isPredeployRequired();

    public abstract String getLaunchCommand();

    public Properties getUeiProperties() {
        return this.ueiProperties;
    }

    public abstract String getVendor();

    public abstract String getRuntimePlatformDefinitionName(String var1);

    public void getDevicePlatforms(File rootDirectory, Vector foundDps, int level) {
        File[] files;
        this.findPlatforms(rootDirectory, foundDps);
        if (--level != 0 && (files = rootDirectory.listFiles()) != null) {
            File[] fileArray = files;
            int n = 0;
            int n2 = fileArray.length;
            while (n < n2) {
                File file = fileArray[n];
                if (file.isDirectory()) {
                    this.getDevicePlatforms(file, foundDps, level);
                }
                ++n;
            }
        }
    }

    public DevicePlatform[] getDevicePlatforms(File rootDirectory, int level) {
        Vector foundDps = new Vector();
        this.getDevicePlatforms(rootDirectory, foundDps, level);
        DevicePlatform[] dps = new DevicePlatform[foundDps.size()];
        return foundDps.toArray(dps);
    }

    public DevicePlatform[] getDevicePlatforms(File rootDirectory) {
        return this.getDevicePlatforms(rootDirectory, 4);
    }

    protected Properties parseUEIPropertiesString(String output) {
        return null;
    }

    protected void findPlatforms(File directory, Vector dps) {
        if (!new File(String.valueOf(directory.getPath()) + "/bin").exists()) {
            return;
        }
        File emulatorExecutable = UeiExecutable.getEmulatorExecutable(directory);
        try {
            this.ueiProperties = UeiPropertiesCache.instance.getUEIProperties(emulatorExecutable);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return;
        }
        if (this.ueiProperties.isEmpty()) {
            return;
        }
        if (this.ueiProperties.size() == 1) {
            return;
        }
        DevicePlatform dp = DevicesFactory.eINSTANCE.createDevicePlatform();
        this.createPlatformDetails(dp);
        this.createDevices(dp);
        Configuration conf = this.createDirConfiguration(directory.getAbsolutePath());
        dp.setConfiguration(conf);
        dps.add(dp);
    }

    public Configuration createDirConfiguration(String rootDirectory) {
        Configuration conf = DevicesFactory.eINSTANCE.createConfiguration();
        ConfigurationItem item = DevicesFactory.eINSTANCE.createConfigurationItem();
        item.setName("directory");
        item.setLabel("Directory");
        item.setDescription("Emulator installation directory");
        item.setValue(rootDirectory);
        conf.getItems().add((Object)item);
        return conf;
    }

    public void createPlatformDetails(DevicePlatform dp) {
        dp.setName(this.ueiProperties.getProperty("eclipse.mtj.toolkit.name"));
        dp.setVendor(this.getVendor());
        dp.setVersion("1.0");
        dp.setType(PlatformType.EXECUTABLE_EMULATOR_LITERAL);
    }

    public void createDevices(DevicePlatform dp) {
        EList deviceList = dp.getDevices();
        List deviceNames = this.getMultipleValues(this.ueiProperties.getProperty("device.list", ""), ",");
        Device device = null;
        int i = 0;
        while (i < deviceNames.size()) {
            device = DevicesFactory.eINSTANCE.createDevice();
            String deviceName = (String)deviceNames.get(i);
            device.setName(deviceName);
            this.createDeviceDetails(device);
            this.createSecurityDomains(device);
            RuntimePlatformDefinition rpd = this.createRuntimePlatformDefinition(deviceName);
            device.getRuntimePlatformDefinitions().add((Object)rpd);
            dp.getRuntimePlatformDefinitions().add((Object)rpd);
            device.setDeviceDescription(this.createDeviceDescription(deviceName));
            deviceList.add((Object)device);
            ++i;
        }
    }

    public abstract DeviceDescription createDeviceDescription(String var1);

    public abstract void createDeviceDetails(Device var1);

    protected void createSecurityDomains(Device device) {
        String securityDomains = this.ueiProperties.getProperty(String.valueOf(device.getName()) + ".security.domains");
        if (securityDomains != null) {
            EList securityDomainList = device.getProtectionDomains();
            List domains = this.getMultipleValues(securityDomains, ",");
            ProtectionDomain pd = null;
            int j = 0;
            while (j < domains.size()) {
                pd = DevicesFactory.eINSTANCE.createProtectionDomain();
                pd.setName((String)domains.get(j));
                securityDomainList.add((Object)pd);
                ++j;
            }
        }
    }

    public RuntimePlatformDefinition createRuntimePlatformDefinition(String deviceName) {
        RuntimePlatformDefinition rpd = RuntimesFactory.eINSTANCE.createRuntimePlatformDefinition();
        rpd.setName(this.getRuntimePlatformDefinitionName(deviceName));
        this.createDeviceConfigurations(rpd, deviceName);
        this.createServiceApis(rpd, deviceName);
        this.createDeviceProfiles(rpd, deviceName);
        return rpd;
    }

    protected String getDeviceDescriptionIdentifier(String deviceName) {
        return String.valueOf(this.getVendor()) + " " + deviceName;
    }

    protected void createDeviceProfiles(RuntimePlatformDefinition rpd, String deviceName) {
        EList deviceProfiles = rpd.getDeviceProfiles();
        String apiFiles = this.ueiProperties.getProperty(String.valueOf(deviceName) + ".apis", this.ueiProperties.getProperty(String.valueOf(deviceName) + ".bootclasspath", ""));
        List l = this.getLibFiles(apiFiles);
        IServiceApiImporter[] importers = AbstractServiceApiImporter.SERVICE_API_IMPORTERS;
        File apiFile = null;
        DeviceProfile[] importedApis = null;
        int i = 0;
        while (i < l.size()) {
            apiFile = (File)l.get(i);
            importedApis = null;
            int j = 0;
            while (importedApis == null && j < importers.length) {
                importedApis = importers[j].getProfileApis(apiFile);
                ++j;
            }
            j = 0;
            while (j < importedApis.length) {
                deviceProfiles.add((Object)importedApis[j]);
                ++j;
            }
            ++i;
        }
    }

    protected void createDeviceConfigurations(RuntimePlatformDefinition rpd, String deviceName) {
        EList dconfigs = rpd.getDeviceConfigurations();
        String apiFiles = this.ueiProperties.getProperty(String.valueOf(deviceName) + ".apis", this.ueiProperties.getProperty(String.valueOf(deviceName) + ".bootclasspath", ""));
        List l = this.getLibFiles(apiFiles);
        IServiceApiImporter[] importers = AbstractServiceApiImporter.SERVICE_API_IMPORTERS;
        File apiFile = null;
        DeviceConfiguration[] importedApis = null;
        int i = 0;
        while (i < l.size()) {
            apiFile = (File)l.get(i);
            importedApis = null;
            int j = 0;
            while (importedApis == null && j < importers.length) {
                importedApis = importers[j].getConfigurationApis(apiFile);
                ++j;
            }
            j = 0;
            while (j < importedApis.length) {
                dconfigs.add((Object)importedApis[j]);
                ++j;
            }
            ++i;
        }
    }

    protected void createServiceApis(RuntimePlatformDefinition rpd, String deviceName) {
        String apis = this.ueiProperties.getProperty(String.valueOf(deviceName) + ".apis", this.ueiProperties.getProperty(String.valueOf(deviceName) + ".bootclasspath", ""));
        this.createServiceApisForList(rpd, null, apis);
    }

    protected void setServiceApisForProfile(RuntimePlatformDefinition rpd, DeviceProfile deviceProfile, String deviceName) {
        this.ueiProperties.getProperty(String.valueOf(deviceName) + ".apis", this.ueiProperties.getProperty(String.valueOf(deviceName) + ".bootclasspath", ""));
        rpd.getServiceApis();
        deviceProfile.getServiceApis();
    }

    protected void createServiceApisForList(RuntimePlatformDefinition rpd, DeviceProfile deviceProfile, String apiFileNames) {
        EList sapis = null;
        sapis = deviceProfile != null ? deviceProfile.getServiceApis() : rpd.getServiceApis();
        List l = this.getMultipleValues(apiFileNames, ",");
        IServiceApiImporter[] importers = AbstractServiceApiImporter.SERVICE_API_IMPORTERS;
        ServiceApi[] importedApis = null;
        File sapiFile = null;
        Vector<String> v = new Vector<String>();
        int i = 0;
        while (i < l.size()) {
            sapiFile = new File((String)l.get(i));
            importedApis = null;
            int j = 0;
            while (importedApis == null && j < importers.length) {
                importedApis = importers[j].getServiceApis(sapiFile);
                ++j;
            }
            j = 0;
            while (j < importedApis.length) {
                String tmpName = String.valueOf(importedApis[j].getName()) + importedApis[j].getVersion();
                if (!v.contains(tmpName)) {
                    sapis.add((Object)importedApis[j]);
                    v.add(tmpName);
                }
                ++j;
            }
            ++i;
        }
    }

    protected List getMultipleValues(String s, String delim) {
        Vector<String> l = new Vector<String>();
        StringTokenizer st = new StringTokenizer(s, delim);
        while (st.hasMoreTokens()) {
            l.add(st.nextToken().trim());
        }
        return l;
    }

    protected List getLibFiles(String classpath) {
        Vector<File> l = new Vector<File>();
        StringTokenizer st = new StringTokenizer(classpath, ",");
        File file = null;
        while (st.hasMoreTokens()) {
            file = new File(st.nextToken().trim());
            l.add(file);
        }
        return l;
    }

    protected String[] getNameAndVersion(String nameAndVersion) {
        String name = nameAndVersion.substring(0, nameAndVersion.indexOf("-"));
        String version = nameAndVersion.substring(nameAndVersion.indexOf("-") + 1);
        String[] s = new String[]{name, version};
        return s;
    }

    protected String getServiceApiName(File file) {
        String fileName = file.getName();
        int end = fileName.lastIndexOf(".");
        return fileName.substring(0, end);
    }
}

