/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class DirUtil {
    public static ArrayList getSubDirectoriesInDirectory(String path) throws IOException {
        ArrayList<String> dirList = new ArrayList<String>();
        File directory = new File(path);
        if (!directory.isDirectory()) {
            return dirList;
        }
        String[] dirsAndFiles = directory.list();
        File testFile = null;
        int i = 0;
        int length = dirsAndFiles.length;
        while (i < length) {
            testFile = new File(path, dirsAndFiles[i]);
            if (testFile.isDirectory()) {
                dirList.add(dirsAndFiles[i]);
            }
            ++i;
        }
        return dirList;
    }

    public static boolean fileExists(StringBuffer path) {
        return DirUtil.fileExists(path.toString());
    }

    public static boolean fileExists(String path) {
        try {
            File file = new File(path);
            return file.isFile();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static ArrayList getAllFilesInDirectory(String path, boolean recursive, boolean fullPath, String re) throws IOException {
        return DirUtil.getAllFilesInDirectory(path, recursive, fullPath, new SimpleRegExp(re));
    }

    private static ArrayList getAllFilesInDirectory(String path, boolean recursive, boolean fullPath, SimpleRegExp re) throws IOException {
        ArrayList<String> outta = new ArrayList<String>();
        File directory = new File(path);
        if (!directory.isDirectory()) {
            return outta;
        }
        String[] dirsAndFiles = directory.list();
        File testFile = null;
        int i = 0;
        int length = dirsAndFiles.length;
        while (i < length) {
            testFile = new File(path, dirsAndFiles[i]);
            if (testFile.isFile()) {
                if (re.matches(dirsAndFiles[i])) {
                    if (fullPath) {
                        outta.add(String.valueOf(path) + '/' + dirsAndFiles[i]);
                    } else {
                        outta.add(dirsAndFiles[i]);
                    }
                }
            } else if (recursive) {
                outta.addAll(DirUtil.getAllFilesInDirectory(new StringBuffer(64).append(path).append('/').append(dirsAndFiles[i]).toString(), recursive, fullPath, re));
            }
            ++i;
        }
        return outta;
    }

    public static String getFileExtension(String file) {
        if (file.indexOf(".") != -1) {
            return file.substring(file.lastIndexOf(".") + 1);
        }
        return "";
    }

    private static class SimpleRegExp {
        private String mask;
        private int asteriskPosition;
        private int dotPosition;
        private boolean matchWord;
        private boolean allMatches;
        String beginsWith = null;
        String endsWith = null;

        public SimpleRegExp(String mask) {
            this.mask = mask;
            this.calculatePositions();
        }

        public void setMask(String x) {
            this.mask = x;
            this.calculatePositions();
        }

        public String getMask() {
            return this.mask;
        }

        public boolean matches(String str) {
            if (this.allMatches) {
                return true;
            }
            if (this.matchWord) {
                return this.mask.equals(str);
            }
            boolean retVal = false;
            if (this.beginsWith != null) {
                retVal = str.startsWith(this.beginsWith);
                if (!retVal) {
                    return retVal;
                }
                if (this.endsWith != null) {
                    return str.endsWith(this.endsWith);
                }
                return true;
            }
            if (this.endsWith != null) {
                return str.endsWith(this.endsWith);
            }
            return true;
        }

        private void calculatePositions() {
            if (this.mask == null || this.mask.length() == 0) {
                throw new IllegalArgumentException("SimpleRegExp::calculatePositions mask == null || mask.length() == 0");
            }
            if (this.mask.equals("*.*")) {
                this.allMatches = true;
                return;
            }
            this.dotPosition = this.mask.lastIndexOf(46);
            this.asteriskPosition = this.mask.indexOf(42);
            if (this.asteriskPosition == -1) {
                this.matchWord = true;
                return;
            }
            if (this.mask.endsWith("*.*")) {
                this.beginsWith = this.mask.substring(0, this.asteriskPosition);
                this.endsWith = null;
            } else if (this.asteriskPosition < this.dotPosition) {
                this.beginsWith = this.mask.substring(0, this.asteriskPosition);
                this.endsWith = this.mask.substring(this.dotPosition);
            } else {
                this.beginsWith = this.mask.substring(0, this.dotPosition);
                this.endsWith = this.mask.substring(this.asteriskPosition);
            }
        }
    }
}

