/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.sp.ui.eclipse.preferences;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.api.extension.SigningProvider;
import org.eclipse.mtj.core.ui.util.GridUtil;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.sp.ui.eclipse.preferences.Messages;
import org.eclipse.mtj.extension.sp.ui.eclipse.preferences.SigningProviderEditor;
import org.eclipse.mtj.extension.sp.ui.utils.SpUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class SigningPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private MtjExtension[] signingList;
    private Button editButton;
    private TableItem lastEnabled = null;
    private Table SigningToolPathTable;

    public SigningPreferencePage() {
        this.setDescription(String.valueOf(Messages.SigningPreferencePage_0) + Messages.SigningPreferencePage_1 + Messages.SigningPreferencePage_2);
        this.noDefaultAndApplyButton();
        try {
            this.signingList = (SigningProvider[])SpUtils.getSigningProvidersList();
        }
        catch (MtjException mtjException) {
            this.signingList = null;
        }
    }

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        if (this.signingList == null) {
            this.setErrorMessage(Messages.SigningPreferencePage_10);
        } else if (this.signingList.length <= 0) {
            this.setErrorMessage(Messages.SigningPreferencePage_3);
        }
        this.setDescription(Messages.SigningPreferencePage_4);
        Composite mainPageComposite = new Composite(parent, 2048);
        GridLayout c1gridLayout = new GridLayout();
        c1gridLayout.numColumns = 2;
        mainPageComposite.setLayout((Layout)c1gridLayout);
        GridData dataMain = GridUtil.createFill();
        mainPageComposite.setLayoutData((Object)dataMain);
        Composite tableComposite = new Composite(mainPageComposite, 0);
        FillLayout fillLayout = new FillLayout();
        tableComposite.setLayout((Layout)fillLayout);
        GridData gdTableComp = new GridData(1808);
        tableComposite.setLayoutData((Object)gdTableComp);
        this.SigningToolPathTable = new Table(tableComposite, 68388);
        this.SigningToolPathTable.setHeaderVisible(true);
        this.SigningToolPathTable.setLinesVisible(true);
        this.SigningToolPathTable.setFont(parent.getFont());
        SpUtils.createTableColumn(Messages.SigningPreferencePage_9, this.SigningToolPathTable, 0, 150);
        SpUtils.createTableColumn(Messages.SigningPreferencePage_5, this.SigningToolPathTable, 1, 40);
        SpUtils.createTableColumn(Messages.SigningPreferencePage_6, this.SigningToolPathTable, 2, 40);
        SpUtils.createTableColumn(Messages.SigningPreferencePage_7, this.SigningToolPathTable, 3, 200);
        if (this.signingList != null && this.signingList.length > 0) {
            int i = 0;
            while (i < this.signingList.length) {
                TableItem item = new TableItem(this.SigningToolPathTable, 0);
                item.setText(0, this.signingList[i].getDescription());
                item.setText(1, this.signingList[i].getVendor());
                item.setText(2, this.signingList[i].getVersion());
                try {
                    item.setText(3, ((SigningProvider)this.signingList[i]).getToolLocation((IProgressMonitor)new NullProgressMonitor()));
                }
                catch (MtjException e1) {
                    item.setText(3, "");
                    e1.printStackTrace();
                }
                if (((SigningProvider)this.signingList[i]).isActive()) {
                    if (this.lastEnabled != null) {
                        if (this.lastEnabled.equals(item)) {
                            item.setChecked(true);
                        } else {
                            item.setChecked(false);
                        }
                    } else {
                        item.setChecked(true);
                        this.lastEnabled = item;
                    }
                } else {
                    item.setChecked(false);
                }
                ++i;
            }
        }
        this.SigningToolPathTable.pack();
        this.SigningToolPathTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                SigningPreferencePage.this.editButton.setEnabled(true);
                if (event.detail == 32) {
                    if (SigningPreferencePage.this.lastEnabled == null) {
                        ((TableItem)event.item).setChecked(true);
                        SigningPreferencePage.this.lastEnabled = (TableItem)event.item;
                    } else if (!SigningPreferencePage.this.lastEnabled.equals((TableItem)event.item)) {
                        SigningPreferencePage.this.lastEnabled.setChecked(false);
                        ((TableItem)event.item).setChecked(true);
                        SigningPreferencePage.this.lastEnabled = (TableItem)event.item;
                    }
                }
            }
        });
        Composite rightColumnButtons = new Composite(mainPageComposite, 0);
        GridData gd = new GridData();
        gd.grabExcessVerticalSpace = true;
        gd.horizontalIndent = 10;
        gd.verticalAlignment = 4;
        rightColumnButtons.setLayoutData((Object)gd);
        gd.horizontalSpan = 1;
        GridLayout c1gridLayoutButtons = new GridLayout();
        c1gridLayoutButtons.numColumns = 1;
        rightColumnButtons.setLayout((Layout)c1gridLayoutButtons);
        this.editButton = new Button(rightColumnButtons, 8);
        this.editButton.setText(Messages.SigningPreferencePage_8);
        this.editButton.setEnabled(false);
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TableItem ti = SigningPreferencePage.this.SigningToolPathTable.getSelection()[0];
                SigningProviderEditor signingProviderEditor = new SigningProviderEditor(SigningPreferencePage.this.getShell(), ti.getText(1), ti.getText(2), ti.getText(3), ti.getText(0));
                signingProviderEditor.open();
                if (signingProviderEditor.getReturnCode() == 0) {
                    ti.setText(1, signingProviderEditor.getName());
                    ti.setText(2, signingProviderEditor.getVersion());
                    ti.setText(3, signingProviderEditor.getPath());
                }
            }
        });
        return mainPageComposite;
    }

    public boolean performOk() {
        boolean okToStore = false;
        int i = 0;
        while (i < this.signingList.length) {
            try {
                ((SigningProvider)this.signingList[i]).storeToolLocation(this.SigningToolPathTable.getItem(i).getText(3), null);
                ((SigningProvider)this.signingList[i]).setActive(this.SigningToolPathTable.getItem(i).getChecked());
            }
            catch (MtjException e) {
                e.printStackTrace();
            }
            ++i;
        }
        okToStore = SpUtils.storeSigningProviders(this.signingList);
        if (okToStore) {
            return super.performOk();
        }
        return okToStore;
    }
}

