/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dm.preferences;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.api.runtimes.ServiceApi;
import org.eclipse.mtj.core.ui.util.DialogController;
import org.eclipse.mtj.extension.dm.Messages;
import org.eclipse.mtj.extension.dm.ui.preferences.DeviceInfoComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class DeviceInfoController
implements DialogController {
    private Device selectedDevice;
    private DeviceInfoComposite composite;
    private Tree apiTree;

    public DeviceInfoController(Device selectedDevice, DeviceInfoComposite composite) {
        this.composite = composite;
        this.selectedDevice = selectedDevice;
        this.apiTree = composite.getApiTree();
        this.setData();
    }

    private void setData() {
        this.composite.getDeviceNameLabel().setText(this.selectedDevice.getName());
        this.composite.getDeviceDescriptionLabel().setText(this.selectedDevice.getDescription());
        EList l = this.selectedDevice.getRuntimePlatformDefinitions();
        RuntimePlatformDefinition rpd = (RuntimePlatformDefinition)l.get(0);
        this.createProfile(rpd);
        this.createConfiguration(rpd);
        this.createServiceApi(rpd);
    }

    private static void removeSubItems(EList rpApiList) {
        if (DeviceInfoController.checkIfContainsApi(rpApiList, "JSR177")) {
            DeviceInfoController.removeApi(rpApiList, "JSR177/APDU");
            DeviceInfoController.removeApi(rpApiList, "JSR177/CRYPTO");
            DeviceInfoController.removeApi(rpApiList, "JSR177/JCRMI");
            DeviceInfoController.removeApi(rpApiList, "JSR177/PKI");
        }
        if (DeviceInfoController.checkIfContainsApi(rpApiList, "JSR82")) {
            DeviceInfoController.removeApi(rpApiList, "JSR82/BT");
            DeviceInfoController.removeApi(rpApiList, "JSR82/OBEX");
        }
        if (DeviceInfoController.checkIfContainsApi(rpApiList, "JSR75")) {
            DeviceInfoController.removeApi(rpApiList, "JSR75/FC");
            DeviceInfoController.removeApi(rpApiList, "JSR75/PIM");
        }
    }

    private static void removeApi(EList list, String apiName) {
        for (Object o : list) {
            ServiceApi api = (ServiceApi)o;
            if (!api.getName().equals(apiName)) continue;
            list.remove((Object)api);
            break;
        }
    }

    private static boolean checkIfContainsApi(EList list, String apiName) {
        for (Object o : list) {
            ServiceApi api = (ServiceApi)o;
            if (!api.getName().equals(apiName)) continue;
            return true;
        }
        return false;
    }

    private void createServiceApi(RuntimePlatformDefinition rpd) {
        this.apiTree.setHeaderVisible(true);
        this.apiTree.setLinesVisible(true);
        BasicEList rpApiList = new BasicEList((Collection)rpd.getServiceApis());
        DeviceInfoController.removeSubItems((EList)rpApiList);
        TreeColumn nameColumn = new TreeColumn(this.apiTree, 16384);
        TreeColumn versionColumn = new TreeColumn(this.apiTree, 0x1000000);
        TreeColumn descriptionColumn = new TreeColumn(this.apiTree, 16384);
        nameColumn.setText(Messages.DeviceInfoController_Name);
        nameColumn.setWidth(110);
        versionColumn.setText(Messages.DeviceInfoController_Version);
        versionColumn.setWidth(50);
        descriptionColumn.setText(Messages.DeviceInfoController_Description);
        descriptionColumn.setWidth(150);
        for (ServiceApi api : rpApiList) {
            TreeItem item = new TreeItem(this.apiTree, 0);
            item.setData((Object)api);
            item.setText(new String[]{api.getName(), api.getVersion(), api.getDescription()});
        }
        this.apiTree.setSize(100, 100);
    }

    public static Button createRadioButton(Group parent, String label) {
        Button button = new Button((Composite)parent, 32);
        button.setFont(parent.getFont());
        if (label != null) {
            button.setText(label);
        }
        return button;
    }

    private boolean containsProfile(String profileName, String profileVersion, Iterator iterator) {
        while (iterator.hasNext()) {
            DeviceProfile dp = (DeviceProfile)iterator.next();
            if (!dp.getName().equals(profileName) || !dp.getVersion().equals(profileVersion)) continue;
            return true;
        }
        return false;
    }

    private boolean containsConfiguration(String configurationName, String configurationVersion, Iterator iterator) {
        while (iterator.hasNext()) {
            DeviceConfiguration dc = (DeviceConfiguration)iterator.next();
            if (!dc.getName().equals(configurationName) || !dc.getVersion().equals(configurationVersion)) continue;
            return true;
        }
        return false;
    }

    private void createProfile(RuntimePlatformDefinition rpd) {
        EList l = rpd.getDeviceProfiles();
        Group group = this.composite.getProfileGroup();
        this.createProfileIfNeeded("IMP", "1.0", l, group);
        this.createProfileIfNeeded("IMP-NG", "1.0", l, group);
        this.createProfileIfNeeded("MIDP", "1.0", l, group);
        this.createProfileIfNeeded("MIDP", "2.0", l, group);
        int i = 0;
        while (i < l.size()) {
            DeviceProfile dp = (DeviceProfile)l.get(i);
            String dps = String.valueOf(dp.getName()) + " " + dp.getVersion();
            Button button = DeviceInfoController.createRadioButton(group, dps);
            DeviceInfoController.addCheckButtonSelectionListener(button);
            ++i;
        }
    }

    private static void addCheckButtonSelectionListener(Button button) {
        button.setSelection(true);
        button.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ((Button)e.getSource()).setSelection(true);
            }
        });
    }

    private void createConfiguration(RuntimePlatformDefinition rpd) {
        EList l = rpd.getDeviceConfigurations();
        Group group = this.composite.getConfigGroup();
        this.createConfigurationIfNeeded("CLDC", "1.0", l, group);
        this.createConfigurationIfNeeded("CLDC", "1.1", l, group);
        this.createConfigurationIfNeeded("CDC", "1.0", l, group);
        this.createConfigurationIfNeeded("CDC", "1.1", l, group);
        int i = 0;
        while (i < l.size()) {
            DeviceConfiguration dc = (DeviceConfiguration)l.get(i);
            String dcs = String.valueOf(dc.getName()) + " " + dc.getVersion();
            Button button = DeviceInfoController.createRadioButton(group, dcs);
            DeviceInfoController.addCheckButtonSelectionListener(button);
            ++i;
        }
    }

    private void createProfileIfNeeded(String api, String version, EList l, Group group) {
        if (!this.containsProfile(api, version, l.iterator())) {
            Button button = DeviceInfoController.createRadioButton(group, String.valueOf(api) + " " + version);
            button.setEnabled(false);
        }
    }

    private void createConfigurationIfNeeded(String api, String version, EList l, Group group) {
        if (!this.containsConfiguration(api, version, l.iterator())) {
            Button button = DeviceInfoController.createRadioButton(group, String.valueOf(api) + " " + version);
            button.setEnabled(false);
        }
    }

    public void handleOK() {
    }
}

