/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.rpm.preferences;

import java.util.logging.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.api.runtimes.RuntimePlatform;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.core.ui.util.DialogController;
import org.eclipse.mtj.extension.dm.ui.preferences.AddDevicePlatformDialog2;
import org.eclipse.mtj.extension.rpm.Messages;
import org.eclipse.mtj.extension.rpm.model.MtjServiceHandler;
import org.eclipse.mtj.extension.rpm.ui.preferences.ModifyRuntimeComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class ModifyRuntimeController
implements DialogController,
ICheckStateListener,
SelectionListener {
    private static final Logger log = Logger.getLogger(ModifyRuntimeController.class.getName());
    private MtjServiceHandler mtjServiceHandler;
    private RuntimePlatform selectedRuntime;
    private DevicePlatform[] devicePlatforms;
    private RuntimePlatform[] runtimes;
    private DevicePlatform selectedDevicePlatform;
    private ModifyRuntimeComposite composite;
    private CheckboxTableViewer sdkTableViewer;
    private Text runtimeNameText;
    private Text runtimeDescriptionText;
    private Button importButton;
    private boolean write = false;

    public ModifyRuntimeController(ModifyRuntimeComposite composite, RuntimePlatform[] runtimes, MtjServiceHandler mtjServiceHandler) {
        this(composite, runtimes, mtjServiceHandler, null, false);
    }

    public ModifyRuntimeController(ModifyRuntimeComposite composite, RuntimePlatform[] runtimes, MtjServiceHandler mtjServiceHandler, boolean write) {
        this(composite, runtimes, mtjServiceHandler, null, write);
    }

    public ModifyRuntimeController(ModifyRuntimeComposite composite, RuntimePlatform[] runtimes, MtjServiceHandler mtjServiceHandler, RuntimePlatform selectedRuntime, boolean write) {
        this.mtjServiceHandler = mtjServiceHandler;
        this.selectedRuntime = selectedRuntime;
        this.runtimes = runtimes;
        this.composite = composite;
        this.sdkTableViewer = composite.getSdkTableViewer();
        this.runtimeNameText = composite.getNameText();
        this.runtimeDescriptionText = composite.getDescriptionText();
        this.importButton = composite.getImportButton();
        this.sdkTableViewer.addCheckStateListener((ICheckStateListener)this);
        this.importButton.addSelectionListener((SelectionListener)this);
        this.write = write;
        this.setData();
        this.createSdkList();
        Object[] o = this.sdkTableViewer.getCheckedElements();
        if (selectedRuntime == null) {
            Object[] objectArray = o;
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                Object dp = objectArray[n];
                this.runtimeNameText.setText(ModifyRuntimeController.createRuntimeName((DevicePlatform)dp, runtimes));
                this.runtimeDescriptionText.setText(((DevicePlatform)dp).getName());
                ++n;
            }
        }
    }

    private void setData() {
        this.devicePlatforms = this.mtjServiceHandler.getDevicePlatforms();
        if (this.selectedRuntime != null) {
            this.runtimeNameText.setText(this.selectedRuntime.getName());
            this.runtimeDescriptionText.setText(this.selectedRuntime.getDescription());
        }
    }

    private static boolean containsName(String name, RuntimePlatform[] runtimes) {
        RuntimePlatform[] runtimePlatformArray = runtimes;
        int n = 0;
        int n2 = runtimePlatformArray.length;
        while (n < n2) {
            RuntimePlatform rp = runtimePlatformArray[n];
            if (rp.getName().equals(name)) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.widget == this.importButton) {
            AddDevicePlatformDialog2 dialog = new AddDevicePlatformDialog2(this.composite.getShell(), Messages.ModifyRuntimeController_AddMobileDevicePlatform);
            dialog.setTitleBarLabel(Messages.ModifyRuntimeController_DevicePlatformTitle);
            dialog.setBlockOnOpen(true);
            if (dialog.open() == 0) {
                this.devicePlatforms = this.mtjServiceHandler.getDevicePlatforms();
                this.sdkTableViewer.setInput((Object)this.devicePlatforms);
                if (this.devicePlatforms != null && this.devicePlatforms.length > 0) {
                    this.sdkTableViewer.setChecked((Object)this.devicePlatforms[0], true);
                }
                this.sdkTableViewer.refresh();
            }
        }
    }

    public void handleOK() {
        if (this.selectedRuntime != null) {
            this.selectedRuntime.setName(this.runtimeNameText.getText());
            this.selectedRuntime.setDescription(this.runtimeDescriptionText.getText());
            Object[] o = this.sdkTableViewer.getCheckedElements();
            if (o != null && o.length > 0) {
                DevicePlatform dp = (DevicePlatform)o[0];
                String dpString = ((TargetDevice)this.selectedRuntime.getTargetDevices().get(0)).getDevicePlatformName();
                if (!dpString.equals(dp.getName())) {
                    Device d = (Device)dp.getDevices().get(0);
                    RuntimePlatformDefinition rpd = (RuntimePlatformDefinition)d.getRuntimePlatformDefinitions().get(0);
                    TargetDevice td = MtjServiceHandler.createTargetDevice(dp, rpd, d);
                    this.selectedRuntime.getTargetDevices().clear();
                    this.selectedRuntime.getTargetDevices().add((Object)td);
                }
            }
        } else {
            Object[] o = this.sdkTableViewer.getCheckedElements();
            if (o.length > 0 && o[0] instanceof DevicePlatform) {
                DevicePlatform d = (DevicePlatform)o[0];
                EList l = d.getDevices();
                Device device = (Device)l.get(0);
                EList rtl = device.getRuntimePlatformDefinitions();
                RuntimePlatformDefinition rpd = (RuntimePlatformDefinition)rtl.get(0);
                RuntimePlatform[] prevRuntimes = this.mtjServiceHandler.getRuntimePlatforms();
                this.mtjServiceHandler.setSelectedDP(d);
                this.mtjServiceHandler.setSelectedRPD(rpd);
                this.mtjServiceHandler.addRuntime(this.runtimeNameText.getText(), this.runtimeDescriptionText.getText());
                if (this.write) {
                    RuntimePlatform rp = this.mtjServiceHandler.getAddedRuntime();
                    if (prevRuntimes == null) {
                        prevRuntimes = new RuntimePlatform[]{};
                    }
                    RuntimePlatform[] newRuntimes = new RuntimePlatform[prevRuntimes.length + 1];
                    int i = 0;
                    while (i < prevRuntimes.length) {
                        newRuntimes[i] = prevRuntimes[i];
                        ++i;
                    }
                    newRuntimes[prevRuntimes.length] = rp;
                    MtjServiceHandler.storeRuntimes(newRuntimes);
                }
            }
        }
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        Object o = event.getElement();
        if (o instanceof DevicePlatform) {
            if (o == this.selectedDevicePlatform && o != null) {
                this.sdkTableViewer.setChecked(o, true);
            } else {
                DevicePlatform dp = (DevicePlatform)o;
                this.sdkTableViewer.setAllChecked(false);
                this.sdkTableViewer.setChecked((Object)dp, true);
                this.selectedDevicePlatform = dp;
                this.runtimeNameText.setText(ModifyRuntimeController.createRuntimeName(dp, this.runtimes));
                this.runtimeDescriptionText.setText(dp.getName());
            }
        }
    }

    private static String createRuntimeName(DevicePlatform dp, RuntimePlatform[] runtimes) {
        String name;
        int counter = 0;
        String runtimeName = name = ModifyRuntimeController.createRuntimeName(dp);
        while (ModifyRuntimeController.containsName(runtimeName, runtimes)) {
            runtimeName = String.valueOf(name) + ++counter;
        }
        return runtimeName;
    }

    private static String createRuntimeName(DevicePlatform dp) {
        String name = dp.getName();
        if (name.contains("Sony Ericsson SDK 2.2.3")) {
            return "SonyEricsson_2.2.3_Runtime";
        }
        if (name.contains("Sony Ericsson J2ME SDK 1.2")) {
            return "SonyEricsson_1.2_Runtime";
        }
        if (name.contains("Sun Java(TM) Wireless Toolkit 2.5")) {
            return "WTK_2.5_Runtime";
        }
        if (name.contains("Sun Java Wireless Toolkit  2.3")) {
            return "WTK_2.3_Runtime";
        }
        if (name.contains("Sun") || name.contains("SUN") || name.contains("sun")) {
            return "WTK_Runtime";
        }
        if (name.contains("Nokia Prototype SDK 4.0")) {
            return "Nokia_Prototype_4.0_Runtime";
        }
        if (name.contains("S60") || name.contains("s60")) {
            return "S60_Runtime";
        }
        if (name.contains("S40") || name.contains("s40")) {
            return "S40_Runtime";
        }
        if (name.contains("Nokia") || name.contains("NOKIA") || name.contains("nokia")) {
            return "Nokia_Runtime";
        }
        return "Runtime";
    }

    private void createSdkList() {
        ModifyRuntimeController.createTableColumn(this.sdkTableViewer.getTable(), 0, 20, "");
        ModifyRuntimeController.createTableColumn(this.sdkTableViewer.getTable(), 1, 170, Messages.ModifyRuntimeController_Name);
        ModifyRuntimeController.createTableColumn(this.sdkTableViewer.getTable(), 2, 40, Messages.ModifyRuntimeController_Version);
        ModifyRuntimeController.createTableColumn(this.sdkTableViewer.getTable(), 3, 80, Messages.ModifyRuntimeController_Vendor);
        private class Tlp
        extends LabelProvider
        implements ITableLabelProvider {
            Tlp() {
            }

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (element instanceof DevicePlatform) {
                    DevicePlatform dp = (DevicePlatform)element;
                    if (columnIndex == 0) {
                        return "";
                    }
                    if (columnIndex == 1) {
                        return dp.getName();
                    }
                    if (columnIndex == 2) {
                        return dp.getVersion();
                    }
                    if (columnIndex == 3) {
                        return dp.getVendor();
                    }
                }
                return null;
            }
        }
        this.sdkTableViewer.setLabelProvider((IBaseLabelProvider)new Tlp());
        private class Provider
        implements IStructuredContentProvider {
            Provider() {
            }

            public Object[] getElements(Object o) {
                if (o instanceof DevicePlatform[]) {
                    return (DevicePlatform[])o;
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }
        this.sdkTableViewer.setContentProvider((IContentProvider)new Provider());
        this.sdkTableViewer.setInput((Object)this.devicePlatforms);
        if (this.selectedRuntime != null) {
            this.setSelectedDevicePlatform();
        } else {
            this.selectFirst();
        }
    }

    private void selectFirst() {
        DevicePlatform dp = (DevicePlatform)this.sdkTableViewer.getElementAt(0);
        if (dp != null) {
            this.sdkTableViewer.setChecked((Object)dp, true);
        }
    }

    private void setSelectedDevicePlatform() {
        TargetDevice td = (TargetDevice)this.selectedRuntime.getTargetDevices().get(0);
        String dp = td.getDevicePlatformName();
        int i = 0;
        while (i < this.devicePlatforms.length) {
            if (this.devicePlatforms[i].getName().equals(dp)) {
                this.sdkTableViewer.setChecked((Object)this.devicePlatforms[i], true);
            }
            ++i;
        }
    }

    private static void createTableColumn(Table table, int colIndex, int weight, String header) {
        TableColumn tableColumn = new TableColumn(table, 0, colIndex);
        tableColumn.setResizable(true);
        tableColumn.setText(header);
        tableColumn.setWidth(weight);
    }
}

