/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dm.ui.util;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.enumerations.PlatformType;
import org.eclipse.mtj.api.extension.DeviceManagement;
import org.eclipse.mtj.api.extension.DevicePlatformProvider;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.api.project.TargetDevice;
import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.ImplementationRef;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.api.runtimes.ServiceApi;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.toolkit.ToolkitSupport;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.dm.ui.preferences.DevicePlatformListContentProvider;
import org.eclipse.mtj.extension.dm.ui.preferences.DevicePlatformListLabelProvider;
import org.eclipse.mtj.extension.dm.ui.preferences.DevicePlatformListSorter;
import org.eclipse.mtj.extension.dm.ui.test.TestDeviceConfigurationImpl;
import org.eclipse.mtj.extension.dm.ui.test.TestDeviceImpl;
import org.eclipse.mtj.extension.dm.ui.test.TestDevicePlatformImpl;
import org.eclipse.mtj.extension.dm.ui.test.TestDeviceProfileImpl;
import org.eclipse.mtj.extension.dm.ui.test.TestRuntimePlatformDefinitionImpl;
import org.eclipse.mtj.extension.dm.ui.test.TestServiceApiImpl;
import org.eclipse.mtj.extension.dm.ui.util.ClassLibraryContentProvider;
import org.eclipse.mtj.extension.dm.ui.util.ClassLibraryLabelProvider;
import org.eclipse.mtj.extension.dm.ui.util.DeviceConfigurationContentProvider;
import org.eclipse.mtj.extension.dm.ui.util.DeviceConfigurationLabelProvider;
import org.eclipse.mtj.extension.dm.ui.util.DeviceConfigurationSorter;
import org.eclipse.mtj.extension.dm.ui.util.DeviceListContentProvider;
import org.eclipse.mtj.extension.dm.ui.util.DeviceListLabelProvider;
import org.eclipse.mtj.extension.dm.ui.util.DeviceListSorter;
import org.eclipse.mtj.extension.dm.ui.util.DevicePlatformImportContentProvider;
import org.eclipse.mtj.extension.dm.ui.util.TargetDeviceContentProvider;
import org.eclipse.mtj.extension.dm.ui.util.TargetDeviceLabelProvider;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class PreferenceUtils {
    protected String[] variableTableColumnHeaders = new String[]{"Default", "Name", "Version", "Description", "Vendor"};
    protected ColumnLayoutData[] variableTableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(35), new ColumnWeightData(50), new ColumnWeightData(40), new ColumnWeightData(70), new ColumnWeightData(50)};
    protected String[] variableDeviceTableColumnHeaders = new String[]{"Import", "Device Name", "Version", "Description", "Vendor"};
    protected ColumnLayoutData[] variableDeviceTableColumnLayouts = new ColumnLayoutData[]{new ColumnWeightData(25), new ColumnWeightData(70), new ColumnWeightData(40), new ColumnWeightData(150), new ColumnWeightData(50)};

    public static Button createPushButton(Composite parent, String label) {
        Button button = new Button(parent, 8);
        button.setFont(parent.getFont());
        if (label != null) {
            button.setText(label);
        }
        return button;
    }

    public static Button createRadioButton(Group parent, String label) {
        Button button = new Button((Composite)parent, 16);
        button.setFont(parent.getFont());
        if (label != null) {
            button.setText(label);
        }
        return button;
    }

    public static Button createCheckButton(Composite parent, String label) {
        Button button = new Button(parent, 32);
        button.setFont(parent.getFont());
        if (label != null) {
            button.setText(label);
        }
        return button;
    }

    public Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 0);
        label.setText(text);
        label.setLayoutData((Object)new GridData(32));
        return label;
    }

    public Label createHorizontalSeparator(Composite parent) {
        Label separator = new Label(parent, 258);
        GridData gridData = new GridData(4, 1, true, false);
        separator.setLayoutData((Object)gridData);
        return separator;
    }

    public Text createText(Composite parent, boolean editable) {
        Text text = new Text(parent, 2052);
        text.setLayoutData((Object)new GridData(768));
        text.setEditable(editable);
        return text;
    }

    public StyledText createStyledText(Composite parent, int height) {
        StyledText text = new StyledText(parent, 74);
        GridData gridData = new GridData(4, 1, true, true);
        gridData.heightHint = height;
        gridData.widthHint = 100;
        text.setLayoutData((Object)gridData);
        text.setBackground(parent.getBackground());
        text.setForeground(parent.getForeground());
        text.setEnabled(false);
        return text;
    }

    public static Object createDevicePlatformList() {
        HashSet<TestDevicePlatformImpl> dpList = new HashSet<TestDevicePlatformImpl>();
        TestDevicePlatformImpl dp = new TestDevicePlatformImpl();
        dp.setType(PlatformType.JAVA_BASED_EMULATOR_LITERAL);
        dp.setName("DevicePlatform1");
        dp.setVersion("1.0");
        dp.setVendor("Vendor X");
        dp.setPreferencesDialogAvailable(false);
        dp.setUtilitesDialogAvailable(false);
        dp.setDebugEnabled(false);
        dp.setDevices(PreferenceUtils.createTestDevices(4, "DeviceX", "1.1", "Vendor X"));
        dp.setRuntimePlatformDefinitions(PreferenceUtils.createRpds(2, dp.getDevices()));
        dpList.add(dp);
        TestDevicePlatformImpl dp2 = new TestDevicePlatformImpl();
        dp2.setType(PlatformType.JAVA_BASED_EMULATOR_LITERAL);
        dp2.setName("DevicePlatform2");
        dp2.setVersion("1.0");
        dp2.setVendor("Vendor Y");
        dp2.setPreferencesDialogAvailable(true);
        dp2.setUtilitesDialogAvailable(false);
        dp2.setDebugEnabled(true);
        dp2.setDevices(PreferenceUtils.createTestDevices(3, "DeviceY", "1.2", "Vendor Y"));
        dp2.setRuntimePlatformDefinitions(PreferenceUtils.createRpds(2, dp2.getDevices()));
        dpList.add(dp2);
        TestDevicePlatformImpl dp3 = new TestDevicePlatformImpl();
        dp3.setType(PlatformType.JAVA_BASED_EMULATOR_LITERAL);
        dp3.setName("DevicePlatform3");
        dp3.setVersion("1.0");
        dp3.setVendor("Vendor Z");
        dp3.setPreferencesDialogAvailable(false);
        dp3.setUtilitesDialogAvailable(true);
        dp3.setDebugEnabled(true);
        dp3.setDevices(PreferenceUtils.createTestDevices(2, "DeviceZ", "1.0", "Vendor Z"));
        dp3.setRuntimePlatformDefinitions(PreferenceUtils.createRpds(2, dp3.getDevices()));
        dpList.add(dp3);
        return dpList;
    }

    private static Device[] createTestDevices(int amount, String name, String version, String vendor) {
        Device[] devices = new TestDeviceImpl[amount];
        int i = 0;
        while (i < amount) {
            devices[i] = new TestDeviceImpl();
            devices[i].setName(String.valueOf(name) + "_" + i);
            devices[i].setVersion(version);
            devices[i].setVendor(vendor);
            devices[i].setDescription("Test device");
            ++i;
        }
        return devices;
    }

    private static RuntimePlatformDefinition[] createRpds(int amount, EList devices) {
        RuntimePlatformDefinition[] rpds = new RuntimePlatformDefinition[amount];
        int i = 0;
        while (i < amount) {
            rpds[i] = new TestRuntimePlatformDefinitionImpl();
            rpds[i].setName("RPD_" + i);
            ((TestRuntimePlatformDefinitionImpl)rpds[i]).setDevices(devices);
            ((TestRuntimePlatformDefinitionImpl)rpds[i]).setProfiles(PreferenceUtils.createTestProfiles());
            ((TestRuntimePlatformDefinitionImpl)rpds[i]).setConfigurations(PreferenceUtils.createTestConfigurations());
            ((TestRuntimePlatformDefinitionImpl)rpds[i]).setServices(PreferenceUtils.createTestServices());
            ++i;
        }
        return rpds;
    }

    public static EList createTestRpds() {
        Object[] o = ((Set)PreferenceUtils.createDevicePlatformList()).toArray();
        EList rpdList = null;
        DevicePlatform dp = null;
        int i = 0;
        while (i < o.length) {
            dp = (DevicePlatform)o[i];
            EList rpds = dp.getRuntimePlatformDefinitions();
            if (rpdList == null) {
                rpdList = rpds;
            }
            ++i;
        }
        return rpdList;
    }

    public static EList createTestProfiles() {
        TestDeviceProfileImpl profile = new TestDeviceProfileImpl();
        EList eList = profile.getEmptyProfileList();
        int i = 0;
        while (i < 2) {
            profile = new TestDeviceProfileImpl();
            profile.setName("MIDP");
            profile.setVersion("1." + i);
            eList.add((Object)profile);
            ++i;
        }
        return eList;
    }

    private static EList createTestConfigurations() {
        TestDeviceConfigurationImpl config = new TestDeviceConfigurationImpl();
        EList eList = config.getEmptyEList();
        int i = 0;
        while (i < 2) {
            config = new TestDeviceConfigurationImpl();
            config.setName("CLDC");
            config.setVersion("1." + i);
            eList.add((Object)config);
            ++i;
        }
        return eList;
    }

    private static EList createTestServices() {
        TestServiceApiImpl service = new TestServiceApiImpl();
        EList eList = service.getEmptyEList();
        int i = 0;
        while (i < 7) {
            service = new TestServiceApiImpl();
            service.setName("SAPI");
            service.setVersion("1." + i);
            eList.add((Object)service);
            ++i;
        }
        return eList;
    }

    public TreeViewer createClassLibraryTree(Composite parent) {
        TreeViewer treeViewer = new TreeViewer(parent, 0);
        treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        treeViewer.setLabelProvider((IBaseLabelProvider)new ClassLibraryLabelProvider());
        treeViewer.setContentProvider((IContentProvider)new ClassLibraryContentProvider(treeViewer));
        return treeViewer;
    }

    public TreeViewer createDeviceTree(Composite parent) {
        TreeViewer treeViewer = new TreeViewer(parent, 0);
        treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.addListeners(treeViewer);
        treeViewer.setLabelProvider((IBaseLabelProvider)new DevicePlatformListLabelProvider());
        treeViewer.setContentProvider((IContentProvider)new DevicePlatformListContentProvider((Viewer)treeViewer));
        treeViewer.setSorter((ViewerSorter)new DevicePlatformListSorter());
        return treeViewer;
    }

    public CheckboxTreeViewer createDevicePlatformCheckTree(Composite parent) {
        CheckboxTreeViewer treeViewer = new CheckboxTreeViewer(parent);
        treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        treeViewer.setLabelProvider((IBaseLabelProvider)new DevicePlatformListLabelProvider());
        treeViewer.setContentProvider((IContentProvider)new DevicePlatformImportContentProvider((Viewer)treeViewer));
        treeViewer.setSorter((ViewerSorter)new DevicePlatformListSorter());
        return treeViewer;
    }

    public TreeViewer createTargetDeviceTree(Composite parent) {
        TreeViewer treeViewer = new TreeViewer(parent, 0);
        treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        treeViewer.setLabelProvider((IBaseLabelProvider)new TargetDeviceLabelProvider(this));
        treeViewer.setContentProvider((IContentProvider)new TargetDeviceContentProvider((Viewer)treeViewer));
        return treeViewer;
    }

    protected void addListeners(final TreeViewer treeViewer2) {
        treeViewer2.addPostSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        ((Tree)treeViewer2.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent event) {
                Object singleSelection;
                ISelection selection = treeViewer2.getSelection();
                if (selection.isEmpty()) {
                    return;
                }
                boolean expanded = treeViewer2.getExpandedState(singleSelection = PreferenceUtils.this.getSingleSelection(selection));
                treeViewer2.setExpandedState(singleSelection, !expanded);
            }
        });
    }

    public Object getSingleSelection(ISelection selection) {
        if (!selection.isEmpty()) {
            IStructuredSelection structured = (IStructuredSelection)selection;
            Object element = structured.getFirstElement();
            if (element instanceof Device) {
                return (Device)element;
            }
            if (element instanceof TargetDevice) {
                return (TargetDevice)element;
            }
            if (element instanceof RuntimePlatformDefinition) {
                return (RuntimePlatformDefinition)element;
            }
            if (element instanceof ServiceApi) {
                return (ServiceApi)element;
            }
            if (element instanceof DeviceProfile) {
                return (DeviceProfile)element;
            }
            if (element instanceof DeviceConfiguration) {
                return (DeviceConfiguration)element;
            }
        }
        return null;
    }

    public TreeViewer createConfigTable(Composite parent) {
        TreeViewer treeViewer = new TreeViewer(parent, 0);
        treeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.addListeners(treeViewer);
        treeViewer.setLabelProvider((IBaseLabelProvider)new DeviceConfigurationLabelProvider());
        treeViewer.setContentProvider((IContentProvider)new DeviceConfigurationContentProvider());
        treeViewer.setSorter((ViewerSorter)new DeviceConfigurationSorter());
        return treeViewer;
    }

    public DevicePlatform getSingleDevicePlatformSelection(ISelection selection) {
        IStructuredSelection structured;
        Object element;
        if (!selection.isEmpty() && (element = (structured = (IStructuredSelection)selection).getFirstElement()) instanceof DevicePlatform) {
            return (DevicePlatform)element;
        }
        return null;
    }

    public Device getSingleDeviceSelection(ISelection selection) {
        IStructuredSelection structured;
        Object element;
        if (!selection.isEmpty() && (element = (structured = (IStructuredSelection)selection).getFirstElement()) instanceof Device) {
            return (Device)element;
        }
        return null;
    }

    public RuntimePlatformDefinition getSingleRpdSelection(ISelection selection) {
        IStructuredSelection structured;
        Object element;
        if (!selection.isEmpty() && (element = (structured = (IStructuredSelection)selection).getFirstElement()) instanceof RuntimePlatformDefinition) {
            return (RuntimePlatformDefinition)element;
        }
        return null;
    }

    public TargetDevice getSingleTargetDeviceSelection(ISelection selection) {
        IStructuredSelection structured;
        Object element;
        if (!selection.isEmpty() && (element = (structured = (IStructuredSelection)selection).getFirstElement()) instanceof TargetDevice) {
            return (TargetDevice)element;
        }
        return null;
    }

    public Composite createDefaultComposite(Composite parent, int columns, boolean equalWidth) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(columns, equalWidth);
        composite.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        composite.setLayoutData((Object)data);
        return composite;
    }

    public Group createDefaultGroup(Composite parent, int columns, boolean equalWidth) {
        Group group = new Group(parent, 0);
        GridLayout layout = new GridLayout(columns, equalWidth);
        group.setLayout((Layout)layout);
        GridData data = new GridData(4, 4, true, false);
        group.setLayoutData((Object)data);
        return group;
    }

    public Composite createButtonComposite(Composite parent) {
        Composite buttonComposite = new Composite(parent, 0);
        GridLayout grid = new GridLayout();
        GridData gdata = new GridData(131072, 128, false, false);
        buttonComposite.setLayout((Layout)grid);
        buttonComposite.setLayoutData((Object)gdata);
        buttonComposite.setFont(parent.getFont());
        return buttonComposite;
    }

    public static String getServiceApiListing(RuntimePlatformDefinition rpd) {
        EList eList = rpd.getServiceApis();
        StringBuffer sb = new StringBuffer();
        ServiceApi sApi = null;
        int i = 0;
        while (i < eList.size()) {
            sApi = (ServiceApi)eList.get(i);
            sb.append(sApi.getName());
            sb.append("-");
            sb.append(sApi.getVersion());
            sb.append(", ");
            ++i;
        }
        sb.delete(sb.length() - 2, sb.length() - 1);
        return sb.toString();
    }

    public static String getCleanedServiceApiListing(EList serviceApis, EList profileApis) {
        ServiceApi[] sApis = PreferenceUtils.getCleanedServiceApis(serviceApis, profileApis);
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < sApis.length) {
            sb.append(sApis[i].getName());
            sb.append("-");
            sb.append(sApis[i].getVersion());
            if (i < sApis.length - 1) {
                sb.append(", ");
            }
            ++i;
        }
        return sb.toString();
    }

    public CheckboxTableViewer createDeviceDefaultTable(Composite parent, int amount) {
        CheckboxTableViewer deviceTableViewer = this.createDeviceTable(parent, amount);
        TableLayout tableLayout2 = (TableLayout)deviceTableViewer.getTable().getLayout();
        int i = 0;
        while (i < this.variableTableColumnHeaders.length) {
            tableLayout2.addColumnData(this.variableTableColumnLayouts[i]);
            TableColumn tableColumn = new TableColumn(deviceTableViewer.getTable(), 0, i);
            tableColumn.setResizable(this.variableTableColumnLayouts[i].resizable);
            tableColumn.setText(this.variableTableColumnHeaders[i]);
            ++i;
        }
        return deviceTableViewer;
    }

    public CheckboxTableViewer createDeviceImportTable(Composite parent, int amount) {
        CheckboxTableViewer deviceTableViewer = this.createDeviceTable(parent, amount);
        TableLayout tableLayout2 = (TableLayout)deviceTableViewer.getTable().getLayout();
        int i = 0;
        while (i < this.variableDeviceTableColumnHeaders.length) {
            tableLayout2.addColumnData(this.variableDeviceTableColumnLayouts[i]);
            TableColumn tableColumn = new TableColumn(deviceTableViewer.getTable(), 0, i);
            tableColumn.setResizable(this.variableDeviceTableColumnLayouts[i].resizable);
            tableColumn.setText(this.variableDeviceTableColumnHeaders[i]);
            ++i;
        }
        return deviceTableViewer;
    }

    private CheckboxTableViewer createDeviceTable(Composite parent, int amount) {
        Composite tableComposite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 1;
        GridData gridData = new GridData(4, 4, true, true);
        gridData.heightHint = amount * 20;
        gridData.widthHint = 400;
        tableComposite.setLayout((Layout)layout);
        tableComposite.setLayoutData((Object)gridData);
        Table deviceTable = new Table(tableComposite, 68388);
        TableLayout tableLayout2 = new TableLayout();
        deviceTable.setLayout((Layout)tableLayout2);
        deviceTable.setHeaderVisible(true);
        deviceTable.setLinesVisible(true);
        deviceTable.setFont(parent.getFont());
        gridData = new GridData(1808);
        CheckboxTableViewer deviceTableViewer = new CheckboxTableViewer(deviceTable);
        deviceTableViewer.getControl().setLayoutData((Object)gridData);
        deviceTableViewer.setContentProvider((IContentProvider)new DeviceListContentProvider());
        deviceTableViewer.setLabelProvider((IBaseLabelProvider)new DeviceListLabelProvider());
        deviceTableViewer.setSorter((ViewerSorter)new DeviceListSorter());
        return deviceTableViewer;
    }

    public static Object getDevicePlatforms() throws MtjException {
        HashSet<DevicePlatform> dpList = new HashSet<DevicePlatform>();
        DeviceManagement dm = (DeviceManagement)MtjServices.getInstance().getImplementations(ExtensionType.DEVICE_MANAGEMENT_LITERAL, null, null, true)[0];
        DevicePlatform[] dps = dm.getDevicePlatforms();
        int i = 0;
        while (i < dps.length) {
            dpList.add(dps[i]);
            ++i;
        }
        return dpList;
    }

    public static String getObjectName(Object obj) {
        String name = null;
        StringBuffer sb = null;
        if (obj instanceof DevicePlatform) {
            name = ((DevicePlatform)obj).getName();
        } else if (obj instanceof RuntimePlatformDefinition) {
            name = ((RuntimePlatformDefinition)obj).getName();
        } else if (obj instanceof Device) {
            name = ((Device)obj).getName();
        } else if (obj instanceof TargetDevice) {
            name = ((TargetDevice)obj).getDeviceName();
        } else if (obj instanceof DeviceProfile) {
            DeviceProfile tmp = (DeviceProfile)obj;
            sb = new StringBuffer(tmp.getName());
            sb.append("-");
            sb.append(tmp.getVersion());
            name = sb.toString();
        } else if (obj instanceof DeviceConfiguration) {
            DeviceConfiguration tmp = (DeviceConfiguration)obj;
            sb = new StringBuffer(tmp.getName());
            sb.append("-");
            sb.append(tmp.getVersion());
            name = sb.toString();
        } else if (obj instanceof ServiceApi) {
            ServiceApi tmp = (ServiceApi)obj;
            sb = new StringBuffer(tmp.getName());
            sb.append("-");
            sb.append(tmp.getVersion());
            name = sb.toString();
        } else if (obj instanceof ImplementationRef) {
            ImplementationRef ref = (ImplementationRef)obj;
            sb = new StringBuffer(ref.getFileRef());
            name = sb.toString();
        } else if (obj instanceof DevicePlatformProvider) {
            DevicePlatformProvider dpp = (DevicePlatformProvider)obj;
            sb = new StringBuffer(dpp.getVendor());
            sb.append(" (v.");
            sb.append(dpp.getVersion());
            sb.append(")");
            name = sb.toString();
        } else {
            name = obj == null ? "" : obj.toString();
        }
        return name;
    }

    public static String getObjectStyledName(Object obj) {
        StringBuffer sb = new StringBuffer();
        if (obj instanceof DevicePlatform) {
            sb.append("Device Platform: ");
            sb.append(((DevicePlatform)obj).getName());
        } else if (obj instanceof RuntimePlatformDefinition) {
            sb.append("Runtime Platform: ");
            sb.append(((RuntimePlatformDefinition)obj).getName());
        } else if (obj instanceof Device) {
            sb.append("Device: ");
            sb.append(((Device)obj).getName());
        } else if (obj instanceof TargetDevice) {
            sb.append("Device: ");
            sb.append(((TargetDevice)obj).getDeviceName());
        } else if (obj instanceof DeviceProfile) {
            sb.append("Profile: ");
            DeviceProfile tmp = (DeviceProfile)obj;
            sb.append(tmp.getName());
            sb.append("-");
            sb.append(tmp.getVersion());
        } else if (obj instanceof DeviceConfiguration) {
            sb.append("Configuration: ");
            DeviceConfiguration tmp = (DeviceConfiguration)obj;
            sb.append(tmp.getName());
            sb.append("-");
            sb.append(tmp.getVersion());
        } else if (obj instanceof ServiceApi) {
            sb.append("Service Api: ");
            ServiceApi tmp = (ServiceApi)obj;
            sb.append(tmp.getName());
            sb.append("-");
            sb.append(tmp.getVersion());
        } else if (obj instanceof ImplementationRef) {
            ImplementationRef ref = (ImplementationRef)obj;
            sb.append(ref.getFileRef());
        } else if (obj != null) {
            sb.append(obj);
        }
        return sb.toString();
    }

    public static ServiceApi[] getCleanedServiceApis(EList serviceApis, EList profileApis) {
        Vector<ServiceApi> l = new Vector<ServiceApi>();
        ServiceApi tmpApi = null;
        int i = 0;
        while (i < serviceApis.size()) {
            tmpApi = (ServiceApi)serviceApis.get(i);
            if (!profileApis.contains((Object)tmpApi)) {
                l.add(tmpApi);
            }
            ++i;
        }
        ServiceApi[] sapis = new ServiceApi[l.size()];
        return l.toArray(sapis);
    }

    public static String getPlatformTypeByName(String dpName) {
        String typeName = "";
        DeviceManagement dm = (DeviceManagement)MtjServices.getInstance().getImplementations(ExtensionType.DEVICE_MANAGEMENT_LITERAL, null, null)[0];
        try {
            DevicePlatform myDp = dm.getDevicePlatformByName(dpName);
            typeName = PreferenceUtils.getPlatformTypeName(myDp);
        }
        catch (MtjException e) {
            e.printStackTrace();
        }
        return typeName;
    }

    public static String getPlatformTypeName(DevicePlatform dp) {
        if (dp != null) {
            StringTokenizer st = new StringTokenizer(dp.getType().getName(), "_");
            StringBuffer sb = new StringBuffer();
            String s = null;
            while (st.hasMoreTokens()) {
                s = st.nextToken();
                sb.append(s.charAt(0));
                sb.append(s.substring(1).toLowerCase());
                sb.append(" ");
            }
            return sb.toString().trim();
        }
        return new String();
    }

    public DevicePlatformProvider[] getToolkitSupporters() {
        MtjExtension[] list = MtjServices.getInstance().getImplementations(ExtensionType.DEVICE_PLATFORM_PROVIDER_LITERAL, null, null);
        Vector<DevicePlatformProvider> v = new Vector<DevicePlatformProvider>();
        DevicePlatformProvider dpp = null;
        int i = 0;
        while (i < list.length) {
            dpp = (DevicePlatformProvider)list[i];
            if (dpp instanceof ToolkitSupport) {
                v.add(dpp);
            }
            ++i;
        }
        DevicePlatformProvider[] dppList = new DevicePlatformProvider[v.size()];
        return v.toArray(dppList);
    }

    public DevicePlatformProvider[] getDevicePlatformProviders() {
        MtjExtension[] list = MtjServices.getInstance().getImplementations(ExtensionType.DEVICE_PLATFORM_PROVIDER_LITERAL, null, null);
        DevicePlatformProvider[] dppList = new DevicePlatformProvider[list.length];
        int i = 0;
        while (i < list.length) {
            dppList[i] = (DevicePlatformProvider)list[i];
            ++i;
        }
        return dppList;
    }

    public DevicePlatform[] createDevicePlatformFromDirectory(ToolkitSupport toolkit, String rootLocation) {
        File rootDir = new File(rootLocation);
        return toolkit.getDevicePlatformImporter().getDevicePlatforms(rootDir);
    }
}

