/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.dpp.uei;

import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DeviceDescription;
import org.eclipse.mtj.api.devices.DevicesFactory;
import org.eclipse.mtj.core.toolkit.DevicePlatformImporter;
import org.eclipse.mtj.executable.uei.AbstractUeiDevicePlatformImporter;
import org.eclipse.mtj.extension.dpp.uei.Messages;

public class GenericUeiDevicePlatformImporter
extends AbstractUeiDevicePlatformImporter
implements DevicePlatformImporter {
    public boolean hasDebugServer() {
        return true;
    }

    public boolean isPredeployRequired() {
        return true;
    }

    public String getLaunchCommand() {
        return "%executable% [%debugPort%|-Xdebug -Xrunjdwp:transport=dt_socket,suspend=y,server=y,address=%debugPort%] -classpath \"%classpath%\" -Xdevice:%device% [%jadfile%|\"-Xdescriptor:%jadfile%\"] [%verbose%|-Xverbose:%verbose%] [%heapsize%|-Xheapsize:%heapsize%] [%securityDomain%|-Xdomain:%securityDomain%] %userSpecifiedArguments%  [%otaurl%|-Xjam:transient=%otaurl%]";
    }

    public String getVendor() {
        return Messages.GenericUeiDevicePlatformImporter_GenericVendor;
    }

    public String getRuntimePlatformDefinitionName(String deviceName) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getVendor());
        sb.append(" ");
        sb.append(deviceName);
        sb.append(Messages.GenericUeiDevicePlatformImporter_RuntimePlatform);
        return sb.toString();
    }

    public DeviceDescription createDeviceDescription(String deviceName) {
        DeviceDescription dd = DevicesFactory.eINSTANCE.createDeviceDescription();
        dd.setIdentifier(this.getDeviceDescriptionIdentifier(deviceName));
        return dd;
    }

    protected String getDeviceDescriptionIdentifier(String deviceName) {
        return String.valueOf(this.getVendor()) + " " + deviceName;
    }

    public void createDeviceDetails(Device device) {
        device.setVersion(Messages.GenericUeiDevicePlatformImporter_DeviceDetailsVersion);
        device.setVendor(this.getVendor());
        device.setDescription(Messages.GenericUeiDevicePlatformImporter_DeviceDetailsDescription);
    }
}

