/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.mtj.core.MtjUIErrorResources;

public class MtjCoreErrors {
    public static final String MESSAGE_PREFIX = "MTJCoreError.";
    public static final int ERROR_BASE_CORE = 1000;
    public static final int ERROR_BASE_PACKAGING = 2000;
    public static final int ERROR_BASE_BUILD = 3000;
    public static final int ERROR_BASE_LAUNCH = 4000;
    public static final int ERROR_BASE_PROJECT = 5000;
    public static final int ERROR_BASE_DEVICE_PLATFORM = 6000;
    public static final int ERROR_BASE_SIGNING = 7000;
    public static final int ERROR_BASE_PREVERIFICATION = 10000;
    public static final int ERROR_BASE_SECURITY = 20000;
    public static final int EMF_DATA_MODEL_ERROR = 1001;
    public static final int PACKAGING_PROVIDER_NOT_FOUND_ERROR = 2001;
    public static final int PACKAGING_ERROR = 2002;
    public static final int BUILD_PROVIDER_NOT_FOUND_ERROR = 3001;
    public static final int VM_CONNECT_TIMEOUT_ERROR = 4001;
    public static final int TARGET_DEVICE_ACCESS_ERROR = 4002;
    public static final int TARGET_PLATFORM_ACCESS_ERROR = 4003;
    public static final int MIDP_JAD_CREATION_ERROR = 4004;
    public static final int PROJECT_DEPLOYMENT_ACCESS_ERROR = 5001;
    public static final int PROJECT_INSTANTIATION_ERROR = 5002;
    public static final int PROJECT_EXTENSION_DATA_ERROR = 5003;
    public static final int DEVICE_PLATFORM_PROVIDER_NOT_DEFINED_ERROR = 6001;
    public static final int DEVICE_PLATFORM_ROOT_ERROR = 6002;
    public static final int SIGNING_BAD_KEYSTORE_OR_PASSWORD = 7001;
    public static final int SIGNING_KEYSTORE_TYPE_NOT_AVAILABLE = 7002;
    public static final int SIGNING_PROVIDER_NOT_CONFIGURED = 7003;
    public static final int SIGNING_MISSING_KEYSTORE_INTEGRITY_ALGORITHM = 7004;
    public static final int SIGNING_COULDNT_LOAD_CERTIFICATE = 7005;
    public static final int SIGNING_KEY_NOT_FOUND = 7006;
    public static final int SIGNING_INVALID_KEY_PASSWORD = 7007;
    public static final int SIGNING_BAD_KEY_TYPE = 7008;
    public static final int SIGNING_INVALID_CERTIFICATE_CHAIN = 7009;
    public static final int SIGNING_MISSING_CERTIFICATES = 7010;
    public static final int SIGNING_INVALID_KEY = 7011;
    public static final int SIGNING_NO_SUCH_ALGORITHM = 7012;
    public static final int SIGNING_SIGNATURE_EXCEPTION = 7013;
    public static final int SIGNING_CERTIFICATE_ENCODING = 7014;
    public static final int SIGNING_DEPLOYMENT_NOT_SUPPORTED = 7015;
    public static final int SIGNING_KEYSOTRE_NOT_FOUND = 7016;
    public static final int SECURITY_BAD_KEYSTORE_OR_PASSWORD = 20001;
    public static final int SECURITY_BAD_KEY_TYPE = 20002;
    public static final int SECURITY_MANAGER_NOT_CONFIGURED = 20003;
    public static final int SECURITY_ALIAS_DUPLICATE = 20004;
    public static final int SECURITY_MALFORMED_PASSWORD = 20005;
    public static final int PREVERIFICATION_ERROR = 10001;
    public static final int PREVERIFICATION_PROVIDER_NOT_FOUND_ERROR = 10002;
    public static final int ERRORS_FOUND_IN_PREVERIFICATION = 10003;
    public static final int ERROR_WHILE_ADDING_PREVERIFICATION_ERRORS = 10004;
    public static final int CORE_WARNING_BASE = 20000;
    public static final int CORE_INTERNAL_BASE = 90000;
    public static final int SIGNING_INTERNAL_MISSING_KEYCHAINSET = 90001;
    public static final int SIGNING_INTERNAL_UNABLE_TO_BUILD_KEYRING_URL = 90002;

    public static final String getErrorMessage(int nCode) {
        String strTemplate = MtjUIErrorResources.getString(MESSAGE_PREFIX + nCode);
        if (strTemplate == null) {
            strTemplate = nCode < 90000 ? MtjUIErrorResources.getString("MTJCoreError.Default") : MtjUIErrorResources.getString("MTJCoreError.InternalTemplate");
        }
        String strMessage = MessageFormat.format(strTemplate, new Integer(nCode));
        return strMessage;
    }

    public static void throwCoreExceptionError(int code) throws CoreException {
        Status status = new Status(4, "org.eclipse.mtj.core", code, MtjCoreErrors.getErrorMessage(code), null);
        throw new CoreException((IStatus)status);
    }

    public static void throwCoreExceptionError(int code, Throwable e) throws CoreException {
        Status status = new Status(4, "org.eclipse.mtj.core", code, MtjCoreErrors.getErrorMessage(code), e);
        throw new CoreException((IStatus)status);
    }
}

