/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.mtj.core.Messages;

public class EclipseUtil {
    public static IFile getIFileForFilename(String fname) {
        String filename = fname;
        Path path = new Path(filename);
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        if (f.exists()) {
            return f;
        }
        String canonicalPath = "";
        try {
            File file = new File(fname.startsWith("file:/") ? fname.substring("file:/".length()) : fname);
            canonicalPath = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(canonicalPath));
    }

    public static IFolder getIFolderForPath(String fname) {
        String filename = fname;
        Path path = new Path(filename);
        IFolder f = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)path);
        if (f != null && f.exists()) {
            return f;
        }
        return null;
    }

    public static void addBuilderToProject(String builderId, IProject project) throws CoreException {
        if (!project.isOpen()) {
            return;
        }
        IProjectDescription projectDescription = project.getDescription();
        ICommand[] oldCommands = projectDescription.getBuildSpec();
        int i = 0;
        while (i < oldCommands.length) {
            if (oldCommands[i].getBuilderName().equals(builderId)) {
                return;
            }
            ++i;
        }
        ICommand newCommand = projectDescription.newCommand();
        newCommand.setBuilderName(builderId);
        ArrayList<ICommand> newCommands = new ArrayList<ICommand>();
        newCommands.addAll((Collection)Arrays.asList(oldCommands));
        newCommands.add(newCommand);
        projectDescription.setBuildSpec(newCommands.toArray(new ICommand[newCommands.size()]));
        project.setDescription(projectDescription, null);
    }

    public static void removeBuilderFromProject(String builderId, IProject project) throws CoreException {
        if (!project.isOpen()) {
            return;
        }
        IProjectDescription projectDescription = project.getDescription();
        int idx = -1;
        ICommand[] oldCommands = projectDescription.getBuildSpec();
        int i = 0;
        while (i < oldCommands.length) {
            if (oldCommands[i].getBuilderName().equals(builderId)) {
                idx = i;
                break;
            }
            ++i;
        }
        if (idx == -1) {
            return;
        }
        ArrayList newCommands = new ArrayList();
        newCommands.addAll(Arrays.asList(oldCommands));
        newCommands.remove(idx);
        projectDescription.setBuildSpec(newCommands.toArray(new ICommand[newCommands.size()]));
        project.setDescription(projectDescription, null);
    }

    public static boolean hasProjectBuilder(String builderId, IProject project) throws CoreException {
        if (!project.isOpen()) {
            return false;
        }
        IProjectDescription projectDescription = project.getDescription();
        ICommand[] oldCommands = projectDescription.getBuildSpec();
        int i = 0;
        while (i < oldCommands.length) {
            if (oldCommands[i].getBuilderName().equals(builderId)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static void toggleProjectNature(String natureId, IProject project) throws CoreException {
        if (!project.isOpen()) {
            return;
        }
        IProjectDescription projectDescription = project.getDescription();
        ArrayList<String> natureIds = new ArrayList<String>();
        natureIds.addAll((Collection)Arrays.asList(projectDescription.getNatureIds()));
        int i = natureIds.indexOf(natureId);
        if (i == -1) {
            natureIds.add(natureId);
        } else {
            natureIds.remove(i);
        }
        projectDescription.setNatureIds(natureIds.toArray(new String[0]));
        project.setDescription(projectDescription, 64, null);
    }

    public static void addProjectNature(String natureId, IProject project) throws CoreException {
        if (!project.isOpen()) {
            return;
        }
        IProjectDescription projectDescription = project.getDescription();
        ArrayList<String> natureIds = new ArrayList<String>();
        natureIds.addAll((Collection)Arrays.asList(projectDescription.getNatureIds()));
        int i = natureIds.indexOf(natureId);
        if (i == -1) {
            natureIds.add(natureId);
            projectDescription.setNatureIds(natureIds.toArray(new String[0]));
            project.setDescription(projectDescription, null);
        }
    }

    public static void removeProjectNature(String natureId, IProject project) throws CoreException {
        if (!project.isOpen()) {
            return;
        }
        IProjectDescription projectDescription = project.getDescription();
        ArrayList natureIds = new ArrayList();
        natureIds.addAll(Arrays.asList(projectDescription.getNatureIds()));
        int i = natureIds.indexOf(natureId);
        if (i != -1) {
            natureIds.remove(i);
            projectDescription.setNatureIds(natureIds.toArray(new String[0]));
            project.setDescription(projectDescription, null);
        }
    }

    public static IProject[] getProjectsForNature(String natureId) throws CoreException {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        ArrayList<IProject> projectsOfNature = new ArrayList<IProject>();
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            if (project.isOpen()) {
                IProjectDescription projectDescription = project.getDescription();
                ArrayList natureIds = new ArrayList();
                natureIds.addAll(Arrays.asList(projectDescription.getNatureIds()));
                int j = natureIds.indexOf(natureId);
                if (j != -1) {
                    projectsOfNature.add(project);
                }
            }
            ++i;
        }
        return projectsOfNature.toArray(new IProject[projectsOfNature.size()]);
    }

    public static boolean isProjectOfNature(String projectId, String natureId) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectId);
        if (project.isOpen()) {
            IProjectDescription projectDescription = project.getDescription();
            ArrayList natureIds = new ArrayList();
            natureIds.addAll(Arrays.asList(projectDescription.getNatureIds()));
            return natureIds.indexOf(natureId) != -1;
        }
        return false;
    }

    public static boolean isProjectOpen(String projectId) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectId);
        return project.isOpen();
    }

    public static IProject getProject(String projectId) throws CoreException {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectId);
    }

    public static IProject createSimpleProject(String projectName, String projectPath) throws CoreException {
        return EclipseUtil.createProject(projectName, projectPath, null, null);
    }

    public static IProject createProject(String projectName, String projectPath, String[] natures, ICommand[] builders) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IProjectDescription projectDescription = ResourcesPlugin.getWorkspace().newProjectDescription(projectName);
        if (projectPath != null) {
            projectDescription.setLocation((IPath)new Path(projectPath));
        }
        if (natures == null) {
            projectDescription.setNatureIds(new String[0]);
        } else {
            projectDescription.setNatureIds(natures);
        }
        if (builders == null) {
            projectDescription.setBuildSpec(new ICommand[0]);
        } else {
            projectDescription.setBuildSpec(builders);
        }
        project.create(projectDescription, (IProgressMonitor)new NullProgressMonitor());
        return project;
    }

    public static void deleteProjectCompletely(String projectName) throws CoreException {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
    }

    public static IMarker makeTaskMarker(IFile file, String type, int priority, String message, int line, int col) {
        IMarker marker = null;
        try {
            marker = file.createMarker("org.eclipse.core.resources.taskmarker");
            marker.setAttribute("done", false);
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("priority", (Object)new Integer(priority));
            marker.setAttribute("severity", 2);
            if (line != -1) {
                marker.setAttribute("lineNumber", (Object)new Integer(line));
            }
            if (col != -1) {
                marker.setAttribute("location", (Object)("column " + col));
            }
        }
        catch (Exception exception) {}
        return marker;
    }

    public static String[] getJavaProjectSourceDirectories(String projectName) throws CoreException, JavaModelException {
        ArrayList<String> paths = new ArrayList<String>();
        IProject project = EclipseUtil.getProject(projectName);
        if (project.isOpen() && JavaProject.hasJavaNature((IProject)project)) {
            IJavaProject javaProject = JavaCore.create((IProject)EclipseUtil.getProject(projectName));
            IClasspathEntry[] classpathEntries = null;
            classpathEntries = javaProject.getResolvedClasspath(true);
            int i = 0;
            while (i < classpathEntries.length) {
                IClasspathEntry entry = classpathEntries[i];
                if (entry.getContentKind() == 1) {
                    String relativePath = entry.getPath().toString();
                    String absolutePath = null;
                    if (relativePath.charAt(0) != '/') {
                        absolutePath = relativePath;
                    } else {
                        int j = relativePath.substring(1).indexOf(47);
                        if (j != -1) {
                            absolutePath = relativePath.substring(j + 1);
                        }
                    }
                    String javadir = null;
                    javadir = absolutePath != null ? ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFile(absolutePath).getLocation().toString() : ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getLocation().toString();
                    paths.add(javadir);
                }
                ++i;
            }
        }
        return paths.toArray(new String[0]);
    }

    public static String readFile(String filename) throws Exception {
        IFile iFile = EclipseUtil.getIFileForFilename(filename);
        if (iFile != null) {
            try {
                iFile.refreshLocal(1, null);
            }
            catch (Throwable throwable) {}
            try {
                InputStream is = iFile.getContents();
                int s = is.available();
                byte[] b = new byte[s];
                is.read(b);
                is.close();
                return new String(b);
            }
            catch (Throwable throwable) {}
        }
        try {
            return EclipseUtil.readFileContent(filename);
        }
        catch (Throwable ex2) {
            throw new Exception(Messages.EclipseUtil_ErrorReadingFileContents, ex2);
        }
    }

    public static void deleteFile(String filename) throws CoreException {
        IFile iFile = EclipseUtil.getIFileForFilename(filename);
        if (iFile != null) {
            iFile.delete(true, true, null);
        } else {
            String froot = filename.startsWith("file:/") ? filename.substring("file:/".length()) : filename;
            File file = new File(froot);
            file.delete();
        }
    }

    public static void writeFile(String filename, String filecontent) throws Exception {
        EclipseUtil.writeFile(filename, filecontent, null, -1);
    }

    public static void writeFile(String filename, String filecontent, String parentFolder, int depth) throws Exception {
        IFile iFile = EclipseUtil.getIFileForFilename(filename);
        if (iFile != null) {
            try {
                String fname = filename.replace('\\', '/');
                if (fname.indexOf("/") != -1) {
                    fname = fname.substring(0, fname.lastIndexOf("/"));
                }
                File f = new File(fname);
                f.mkdirs();
                if (parentFolder != null) {
                    IFile parent = EclipseUtil.getIFileForFilename(parentFolder);
                    parent.refreshLocal(depth, null);
                } else {
                    iFile.refreshLocal(1, null);
                }
            }
            catch (CoreException ex1) {
                throw new Exception(Messages.EclipseUtil_ErrorRefreshingFile, ex1);
            }
            try {
                BufferedInputStream input;
                try {
                    input = new BufferedInputStream(new ByteArrayInputStream(filecontent.getBytes()));
                    iFile.setContents((InputStream)input, 2, null);
                }
                catch (Exception exception) {
                    input = new BufferedInputStream(new ByteArrayInputStream(filecontent.getBytes()));
                    iFile.create((InputStream)input, 2, null);
                }
            }
            catch (Exception ex) {
                throw new Exception(Messages.EclipseUtil_ErrorSaviningFileContents, ex);
            }
        } else {
            String fileroot = filename.startsWith("file:/") ? filename.substring("file:/".length()) : filename;
            FileOutputStream fos = new FileOutputStream(new File(fileroot));
            fos.write(filecontent.getBytes());
            fos.close();
        }
    }

    public static String[] getLinkedResources(IProject project) {
        ArrayList<String> paths = new ArrayList<String>();
        String path = String.valueOf(project.getLocation().toString()) + "/.project";
        File file = new File(path);
        if (file.exists()) {
            try {
                String content = EclipseUtil.readFile(file.toString());
                String[] s = EclipseUtil.parseContentBetweenTokens(content, "<location>", "</location>");
                while (s[1].length() > 0) {
                    paths.add(s[1]);
                    s = EclipseUtil.parseContentBetweenTokens(s[2], "<location>", "</location>");
                }
            }
            catch (Exception exception) {}
        }
        return paths.toArray(new String[0]);
    }

    public static String findFileRecursively(IResource resource, String filename) throws CoreException {
        block6: {
            block7: {
                block5: {
                    if (!(resource instanceof IFile)) break block5;
                    String filepath = ((IFile)resource).getLocation().toString();
                    int fpos = filepath.lastIndexOf(filename);
                    if (fpos != -1 && fpos + filename.length() == filepath.length()) {
                        return filepath;
                    }
                    break block6;
                }
                if (!(resource instanceof IProject)) break block7;
                IResource[] resources = ((IProject)resource).members();
                int i = 0;
                while (i < resources.length) {
                    IResource resource2 = resources[i];
                    String ret = EclipseUtil.findFileRecursively(resource2, filename);
                    if (ret != null) {
                        return ret;
                    }
                    ++i;
                }
                break block6;
            }
            if (!(resource instanceof IFolder)) break block6;
            IResource[] resources = ((IFolder)resource).members();
            int i = 0;
            while (i < resources.length) {
                IResource resource3 = resources[i];
                String ret = EclipseUtil.findFileRecursively(resource3, filename);
                if (ret != null) {
                    return ret;
                }
                ++i;
            }
        }
        return null;
    }

    public static ArrayList findDirectories(IProject project, String dirNameEnd) throws CoreException {
        ArrayList dirNameList = new ArrayList();
        IProject baseProject = project;
        EclipseUtil.findDirectoriesRecursively(baseProject, (IResource)baseProject, dirNameEnd, dirNameList);
        return dirNameList;
    }

    private static void findDirectoriesRecursively(IProject project, IResource resource, String dirNameEnd, ArrayList dirNameList) throws CoreException {
        block6: {
            block5: {
                if (!(resource instanceof IProject)) break block5;
                IResource[] resources = ((IProject)resource).members();
                int i = 0;
                while (i < resources.length) {
                    IResource resource2 = resources[i];
                    EclipseUtil.findDirectoriesRecursively(project, resource2, dirNameEnd, dirNameList);
                    ++i;
                }
                break block6;
            }
            if (!(resource instanceof IFolder)) break block6;
            String path = project.getFile(resource.getProjectRelativePath().toString()).getLocation().toString();
            int fpos = path.lastIndexOf(dirNameEnd);
            if (fpos != -1 && fpos + dirNameEnd.length() == path.length()) {
                try {
                    path = new File(path).getCanonicalPath();
                }
                catch (IOException iOException) {}
                path = path != null ? path.replace('\\', '/') : path;
                dirNameList.add(path);
            }
            IResource[] resources = ((IFolder)resource).members();
            int i = 0;
            while (i < resources.length) {
                IResource resource3 = resources[i];
                EclipseUtil.findDirectoriesRecursively(project, resource3, dirNameEnd, dirNameList);
                ++i;
            }
        }
    }

    private static String[] parseContentBetweenTokens(String content, String startTag, String endTag) {
        ArrayList<String> c = new ArrayList<String>();
        if (content.indexOf(startTag) != -1) {
            String a = content.substring(0, content.indexOf(startTag));
            String s = content.substring(content.indexOf(startTag) + startTag.length());
            if (s.indexOf(endTag) != -1) {
                String l = s.substring(s.indexOf(endTag) + endTag.length());
                s = s.substring(0, s.indexOf(endTag));
                c.add(a);
                c.add(s);
                c.add(l);
            } else {
                c.add(a);
                c.add(s);
                c.add("");
            }
        } else {
            c.add(content);
            c.add("");
            c.add("");
        }
        return c.toArray(new String[0]);
    }

    private static String readFileContent(String froot) throws Exception {
        String fileroot = froot.startsWith("file:/") ? froot.substring("file:/".length()) : froot;
        File f = new File(fileroot);
        FileInputStream bais = new FileInputStream(f);
        int len = bais.available();
        byte[] b = new byte[len];
        bais.read(b);
        bais.close();
        return new String(b);
    }

    public static void setResourcesAsDerived(IContainer container) throws CoreException {
        if (container.exists()) {
            container.setDerived(true);
            IResource[] resources = container.members();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (resource instanceof IContainer) {
                    EclipseUtil.setResourcesAsDerived((IContainer)resource);
                } else {
                    resource.setDerived(true);
                }
                ++i;
            }
        }
    }
}

