/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.bm;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.mtj.api.enumerations.BuildType;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.BuildManagement;
import org.eclipse.mtj.api.extension.BuildProvider;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.api.extension.impl.MtjExtensionImpl;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.model.preverifier.IClassErrorInformation;
import org.eclipse.mtj.api.model.preverifier.IFieldErrorInformation;
import org.eclipse.mtj.api.model.preverifier.IMethodErrorInformation;
import org.eclipse.mtj.api.model.preverifier.PreverificationError;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.exception.PreverificationException;
import org.eclipse.mtj.extension.bm.Messages;

public class BuildManagementImpl
extends MtjExtensionImpl
implements BuildManagement {
    public BuildManagementImpl() {
        this.setId("org.eclipse.mtj.extension.bm");
        this.setDescription(Messages.BuildManagementImpl_PluginDescription);
        this.setVendor(Messages.BuildManagementImpl_PluginVendor);
        this.setVersion(Messages.BuildManagementImpl_PluginVersion);
        this.setType(ExtensionType.BUILD_MANAGEMENT_LITERAL);
    }

    public void build(IMtjProject project, String projectNatureId, BuildType buildType, RuntimePlatformDefinition targetPlatform, IProgressMonitor monitor) throws MtjException {
        BuildProvider provider = this.getBuildProvider(buildType);
        if (provider == null) {
            throw new MtjException(MtjCoreErrors.getErrorMessage((int)3001));
        }
        try {
            provider.build(project, projectNatureId, buildType, targetPlatform, monitor);
        }
        catch (PreverificationException ex) {
            PreverificationError[] errors = ex.getPreverificationError();
            try {
                this.handlePreverificationErrors(project.getJavaProject(), errors);
            }
            catch (Exception e) {
                throw new MtjException(MtjCoreErrors.getErrorMessage((int)10004), (Throwable)e);
            }
            throw ex;
        }
        catch (MtjException ex) {
            throw ex;
        }
    }

    private void handlePreverificationErrors(IJavaProject javaProject, PreverificationError[] errors) throws JavaModelException, CoreException {
        int i = 0;
        while (i < errors.length) {
            PreverificationError error = errors[i];
            this.createErrorMarkerFor(javaProject, error);
            ++i;
        }
    }

    private BuildProvider getBuildProvider(BuildType buildType) throws MtjException {
        MtjExtension[] extensions = MtjServices.getInstance().getImplementations(ExtensionType.BUILD_PROVIDER_LITERAL, null, null, true);
        int i = 0;
        while (i < extensions.length) {
            BuildProvider prov = (BuildProvider)extensions[i];
            BuildType[] types = prov.getSupportedTypes();
            int j = 0;
            while (j < types.length) {
                if (buildType.getValue() == types[j].getValue()) {
                    return prov;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private void createErrorMarkerFor(IJavaProject javaProject, PreverificationError error) throws JavaModelException, CoreException {
        IResource resource;
        IMarker marker = null;
        IClassErrorInformation classInfo = error.getLocation().getClassInformation();
        String typeName = classInfo == null ? "" : classInfo.getName().replace('/', '.');
        String message = error.getErrorText();
        IType type = javaProject.findType(typeName);
        if (type != null && (resource = type.getResource()) != null) {
            marker = resource.createMarker("org.eclipse.jdt.core.problem");
            marker.setAttribute("message", (Object)message);
            marker.setAttribute("severity", 2);
            int lineNumber = error.getLocation().getLineNumber();
            if (lineNumber != -1) {
                marker.setAttribute("lineNumber", lineNumber);
            }
            this.setMarkerRangeAttributes(marker, error, type);
        }
        if (marker == null) {
            this.createProjectLevelPreverifyMarker(javaProject, typeName, message);
        }
    }

    private void setMarkerRangeAttributes(IMarker marker, PreverificationError error, IType type) throws CoreException {
        int start = 1;
        int end = 1;
        IMethodErrorInformation methodInfo = error.getLocation().getMethodInformation();
        IFieldErrorInformation fieldInfo = error.getLocation().getFieldInformation();
        switch (error.getLocation().getLocationType().getTypeCode()) {
            case 0: {
                ISourceRange sourceRange = type.getNameRange();
                start = sourceRange.getOffset();
                end = start + sourceRange.getLength();
                break;
            }
            case 1: {
                IField field = type.getField(fieldInfo.getName());
                if (field == null || !field.exists()) break;
                ISourceRange sourceRange = field.getNameRange();
                start = sourceRange.getOffset();
                end = start + sourceRange.getLength();
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                IMethod method = methodInfo.getTypeMethod(type);
                if (method == null || !method.exists()) break;
                ISourceRange sourceRange = method.getNameRange();
                start = sourceRange.getOffset();
                end = start + sourceRange.getLength();
            }
        }
        marker.setAttribute("charStart", start);
        marker.setAttribute("charEnd", end);
    }

    private void createProjectLevelPreverifyMarker(IJavaProject javaProject, String typeName, String message) throws CoreException {
        StringBuffer sb = new StringBuffer(Messages.BuildManagementImpl_Type);
        sb.append(typeName).append(" ").append(message);
        IProject project = javaProject.getProject();
        IMarker marker = project.createMarker("org.eclipse.jdt.core.problem");
        marker.setAttribute("message", (Object)sb.toString());
        marker.setAttribute("severity", 2);
    }
}

