/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.ui.errors;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.mtj.core.ui.Messages;
import org.eclipse.mtj.core.ui.MtjCoreUiPlugin;
import org.eclipse.mtj.core.ui.errors.MtjUIErrorResources;
import org.eclipse.swt.widgets.Shell;

public class MtjUIErrors {
    public static final String MESSAGE_PREFIX = "EclipseMEUIError.";
    public static final int UI_ERROR_BASE = 110000;
    public static final int UI_ERROR_EXCEPTION = 110001;
    public static final int UI_WARNING_BASE = 120000;
    public static final int UI_INTERNAL_BASE = 190000;

    public static final String getErrorMessage(int nCode) {
        String strTemplate = MtjUIErrorResources.getString(MESSAGE_PREFIX + nCode);
        if (strTemplate == null) {
            strTemplate = nCode < 190000 ? MtjUIErrorResources.getString("EclipseMEUIError.Default") : MtjUIErrorResources.getString("EclipseMEUIError.InternalTemplate");
        }
        String strMessage = MessageFormat.format(strTemplate, new Integer(nCode));
        return strMessage;
    }

    public static void throwCoreExceptionError(int code) throws CoreException {
        Status status = new Status(4, "mtj.core", code, MtjUIErrors.getErrorMessage(code), null);
        throw new CoreException((IStatus)status);
    }

    public static void throwCoreExceptionError(int code, Throwable e) throws CoreException {
        Status status = new Status(4, "mtj.core", code, MtjUIErrors.getErrorMessage(code), e);
        throw new CoreException((IStatus)status);
    }

    public static void displayError(Shell s, String dialogTitleKey, String messageKey, Exception e) {
        if (dialogTitleKey == null) {
            dialogTitleKey = "EclipseMEUIError.Default";
        }
        if (messageKey == null) {
            messageKey = "EclipseMEUIError.Default";
        }
        (new String[1])[0] = e.getMessage();
        String message = e.getMessage();
        if (message == null) {
            message = Messages.MtjUIErrors_NoMessage;
        }
        Status status = new Status(4, "mtj.core", 110001, message, (Throwable)e);
        MtjCoreUiPlugin.getDefault().getLog().log((IStatus)status);
        ErrorDialog.openError((Shell)s, (String)dialogTitleKey, (String)messageKey, (IStatus)status);
    }
}

