/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.ui.preferences;

import java.io.IOException;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPersistentPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.mtj.core.ui.Messages;

public class PluginPreferenceStore
implements IPersistentPreferenceStore {
    private Preferences prefs = null;
    private Plugin owner;
    private ListenerList listeners = new ListenerList();
    private boolean listenerAdded = false;
    private boolean quietMode = false;

    public PluginPreferenceStore() {
    }

    public PluginPreferenceStore(Plugin ownerPlugin, Preferences pluginPreferences) {
        this.owner = ownerPlugin;
        this.prefs = pluginPreferences;
    }

    void initialize() {
        if (this.prefs != null) {
            return;
        }
        if (!this.listenerAdded) {
            this.prefs.addPropertyChangeListener(new Preferences.IPropertyChangeListener(){

                public void propertyChange(Preferences.PropertyChangeEvent event) {
                    if (!PluginPreferenceStore.this.quietMode) {
                        PluginPreferenceStore.this.firePropertyChangeEvent(event.getProperty(), event.getOldValue(), event.getNewValue());
                    }
                }
            });
            this.listenerAdded = true;
        }
    }

    public void save() throws IOException {
        this.owner.savePluginPreferences();
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    public void firePropertyChangeEvent(String name, Object oldValue, Object newValue) {
        if (this.listeners.isEmpty()) {
            return;
        }
        Object[] list = this.listeners.getListeners();
        final PropertyChangeEvent event = new PropertyChangeEvent((Object)this, name, oldValue, newValue);
        int i = 0;
        while (i < list.length) {
            final IPropertyChangeListener listener = (IPropertyChangeListener)list[i];
            Platform.run((ISafeRunnable)new SafeRunnable(Messages.PluginPreferenceStore_PreferenceChangeError){

                public void run() {
                    listener.propertyChange(event);
                }
            });
            ++i;
        }
    }

    public boolean contains(String name) {
        return this.getPrefs().contains(name);
    }

    public boolean getBoolean(String name) {
        return this.getPrefs().contains(name);
    }

    public boolean getDefaultBoolean(String name) {
        return this.getPrefs().getDefaultBoolean(name);
    }

    public double getDefaultDouble(String name) {
        return this.getPrefs().getDefaultDouble(name);
    }

    public float getDefaultFloat(String name) {
        return this.getPrefs().getDefaultFloat(name);
    }

    public int getDefaultInt(String name) {
        return this.getPrefs().getDefaultInt(name);
    }

    public long getDefaultLong(String name) {
        return this.getPrefs().getDefaultLong(name);
    }

    public String getDefaultString(String name) {
        return this.getPrefs().getDefaultString(name);
    }

    public double getDouble(String name) {
        return this.getPrefs().getDouble(name);
    }

    public float getFloat(String name) {
        return this.getPrefs().getFloat(name);
    }

    public int getInt(String name) {
        return this.getPrefs().getInt(name);
    }

    public long getLong(String name) {
        return this.getPrefs().getLong(name);
    }

    public String getString(String name) {
        return this.getPrefs().getString(name);
    }

    public boolean isDefault(String name) {
        return this.getPrefs().isDefault(name);
    }

    public boolean needsSaving() {
        return this.getPrefs().needsSaving();
    }

    public void putValue(String name, String value) {
        try {
            this.quietMode = true;
            this.getPrefs().setValue(name, value);
        }
        finally {
            this.quietMode = false;
        }
    }

    public void setDefault(String name, double value) {
    }

    public void setDefault(String name, float value) {
        this.getPrefs().setDefault(name, value);
    }

    public void setDefault(String name, int value) {
        this.getPrefs().setDefault(name, value);
    }

    public void setDefault(String name, long value) {
        this.getPrefs().setDefault(name, value);
    }

    public void setDefault(String name, String defaultObject) {
        this.getPrefs().setDefault(name, defaultObject);
    }

    public void setDefault(String name, boolean value) {
        this.getPrefs().setDefault(name, value);
    }

    public void setToDefault(String name) {
        this.getPrefs().setToDefault(name);
    }

    public void setValue(String name, double value) {
        this.getPrefs().setDefault(name, value);
    }

    public void setValue(String name, float value) {
        this.getPrefs().setDefault(name, value);
    }

    public void setValue(String name, int value) {
        this.getPrefs().setDefault(name, value);
    }

    public void setValue(String name, long value) {
        this.getPrefs().setDefault(name, value);
    }

    public void setValue(String name, String value) {
        this.getPrefs().setDefault(name, value);
    }

    public void setValue(String name, boolean value) {
        this.getPrefs().setDefault(name, value);
    }

    private Preferences getPrefs() {
        if (this.prefs == null) {
            this.initialize();
        }
        return this.prefs;
    }
}

