/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.ui.preferences.control;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.StatusInfo;
import org.eclipse.jdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.ui.Messages;
import org.eclipse.mtj.core.ui.MtjCoreUiPlugin;
import org.eclipse.mtj.core.ui.preferences.control.TableViewerSorter;
import org.eclipse.mtj.core.ui.preferences.model.ExtensionContentProvider;
import org.eclipse.mtj.core.ui.preferences.model.ExtensionImplNode;
import org.eclipse.mtj.core.ui.preferences.model.ExtensionLabelProvider;
import org.eclipse.mtj.core.ui.preferences.view.MTJManagerViewUI;
import org.eclipse.mtj.core.ui.preferences.view.ProjectScopeDialog;
import org.eclipse.mtj.core.ui.util.GridUtil;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class ManagerPrefPage
extends PreferencePage
implements MouseListener,
SelectionListener {
    public static final String PREF_ID = "org.eclipse.mtj.core.ui.preferences.control.MtjProjectPreferencePage";
    public static final String PROP_ID = "org.eclipse.mtj.extension.rpm.ui.preferences.ProjectRuntimeMgmtPreferencePage";
    public static final String PLUGIN_ID = "org.eclipse.mtj.extension.devide";
    public static final String MTJ_NATURE_ID = "org.eclipse.mtj.extension.devide.nature";
    private MTJManagerViewUI mtjManagerViewUI;
    protected static String srvFrwFilter = "MANAGEMENT";
    private static final String[] COLUMNS = new String[]{"STRING", "STRING", "STRING"};
    private int row_index = 0;
    private ArrayList listeners = new ArrayList(2);
    private IProject fProject;
    private IJavaProject[] selectedProjects = null;
    public static final String DATA_NO_LINK = "PropertyAndPreferencePage.nolink";
    private Composite _composite = null;

    public ManagerPrefPage(IPreferenceStore preferenceStore) {
    }

    public ManagerPrefPage(String title) {
        super(title);
    }

    public ManagerPrefPage(String title, ImageDescriptor image) {
        super(title, image);
    }

    public Control createContents(Composite parent) {
        this._composite = new Composite(parent, 0);
        Link lnkProjectSettings = new Link(this._composite, 0);
        GridData gd = new GridData(128);
        lnkProjectSettings.setLayoutData((Object)gd);
        lnkProjectSettings.setText(Messages.ManagerPrefPage_ConfigureMtjProjectSettings);
        lnkProjectSettings.setToolTipText(Messages.ManagerPrefPage_ConfigureMtjProjectSpecificSettingsToolTip);
        lnkProjectSettings.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ManagerPrefPage.this.doLinkActivated((Link)e.widget);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                ManagerPrefPage.this.doLinkActivated((Link)e.widget);
            }
        });
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 5;
        layout.numColumns = 1;
        this._composite.setLayout((Layout)layout);
        GridData data = GridUtil.createFill();
        this._composite.setLayoutData((Object)data);
        this.mtjManagerViewUI = new MTJManagerViewUI(COLUMNS);
        this.mtjManagerViewUI.createControl(this._composite);
        this.createControl(this._composite);
        this.initializeDefaults();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this._composite, String.valueOf(MtjCoreUiPlugin.getPluginId()) + ".mtjcore0002");
        return this._composite;
    }

    public void createControl(Composite parent) {
        this.mtjManagerViewUI.getTableViewer().setContentProvider((IContentProvider)new ExtensionContentProvider());
        this.mtjManagerViewUI.getTableViewer().setLabelProvider((IBaseLabelProvider)new ExtensionLabelProvider());
        this.mtjManagerViewUI.get_tableList().addSelectionListener((SelectionListener)this);
        this.mtjManagerViewUI.get_tableList().addMouseListener((MouseListener)this);
        this.mtjManagerViewUI.get_tableList().addSelectionListener((SelectionListener)this);
        TableViewerSorter.setTableSorter(this.mtjManagerViewUI.getTableViewer(), 0, true);
        this.mtjManagerViewUI.getTableViewer().getTable().addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem _item = (TableItem)event.item;
                ExtensionImplNode _cd = (ExtensionImplNode)_item.getData();
                MtjExtension _m = null;
                ManagerPrefPage.this.row_index = ManagerPrefPage.this.mtjManagerViewUI.getTableViewer().getTable().getSelectionIndex();
                if (_item.getChecked()) {
                    if (_cd.getImpl() instanceof MtjExtension) {
                        _m = (MtjExtension)_cd.getImpl();
                        _m.setActive(true);
                        _cd.setActive(Boolean.TRUE.toString());
                    }
                } else if (_cd.getImpl() instanceof MtjExtension) {
                    _m = (MtjExtension)_cd.getImpl();
                    _m.setActive(false);
                    _cd.setActive(Boolean.FALSE.toString());
                }
                try {
                    MtjServices.getInstance().getCorrespondingAdminGuiProvider(_m);
                }
                catch (MtjException ex) {
                    MtjCoreUiPlugin.getDefault();
                    MtjCoreUiPlugin.displayError(ManagerPrefPage.this.getShell(), 1, 1, Messages.ManagerPrefPage_Error, "AdminGuiProvider.create", ex);
                    ex.printStackTrace();
                }
                ManagerPrefPage.this.mtjManagerViewUI.getTableViewer().getTable().redraw();
            }
        });
        this.mtjManagerViewUI.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ((IStructuredSelection)ManagerPrefPage.this.mtjManagerViewUI.getTableViewer().getSelection()).getFirstElement();
                ManagerPrefPage.this.mtjManagerViewUI.getTableViewer().getTable().getItemCount();
            }
        });
        this.mtjManagerViewUI.getTableViewer().setInput((Object)parent);
        this.mtjManagerViewUI.getTableViewer().refresh();
    }

    final void doLinkActivated(Link link) {
        HashMap<String, Boolean> data = new HashMap<String, Boolean>();
        data.put(DATA_NO_LINK, Boolean.TRUE);
        IJavaProject[] projects = null;
        if (this.isProjectPreferencePage()) {
            this.openWorkspacePreferences(data);
        } else {
            HashSet<IJavaProject> projectsWithSpecifics = new HashSet<IJavaProject>();
            try {
                projects = JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()).getJavaProjects();
                int i = 0;
                while (i < projects.length) {
                    IJavaProject curr = projects[i];
                    if (this.hasProjectSpecificOptions(curr.getProject())) {
                        projectsWithSpecifics.add(curr);
                    }
                    ++i;
                }
            }
            catch (JavaModelException javaModelException) {
            }
            catch (CoreException ex) {
                MtjCorePlugin.getDefault();
                MtjCoreUiPlugin.displayError(MtjCorePlugin.getActiveShell(), 1, 1, Messages.ManagerPrefPage_Error, Messages.ManagerPrefPage_ErrorOccurred, ex);
            }
            try {
                MtjCorePlugin.getDefault();
                ProjectScopeDialog _dialog = new ProjectScopeDialog(MtjCorePlugin.getActiveShell(), Messages.ManagerPrefPage_SelectMTJProjects, projectsWithSpecifics, projects);
                if (_dialog.open() == 0) {
                    IJavaProject[] _selectedProjects = _dialog.getSelectionResult();
                    this.setSelectedProjects(null);
                    this.setSelectedProjects(_selectedProjects);
                    int i = 0;
                    while (i < _selectedProjects.length) {
                        IJavaProject cfr_ignored_0 = _selectedProjects[i];
                        ++i;
                    }
                }
            }
            catch (Exception ex) {
                MtjCorePlugin.getDefault();
                MtjCoreUiPlugin.displayError(MtjCorePlugin.getActiveShell(), 1, 1, Messages.ManagerPrefPage_Error, Messages.ManagerPrefPage_ErrorOccurred, ex);
            }
        }
    }

    protected boolean isProjectPreferencePage() {
        return this.fProject != null;
    }

    protected final void openWorkspacePreferences(Object data) {
        String id = this.getPreferencePageID();
        PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)id, (String[])new String[]{id}, (Object)data).open();
    }

    protected final void openProjectProperties(IProject project, Object data) {
        String id = this.getPropertyPageID();
        if (id != null) {
            PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)project, (String)id, (String[])new String[]{id}, (Object)data).open();
        }
    }

    private String getPreferencePageID() {
        return PREF_ID;
    }

    protected String getPropertyPageID() {
        return PROP_ID;
    }

    protected boolean hasProjectSpecificOptions(IProject project) throws CoreException {
        IProjectDescription description = project.getDescription();
        String[] natures = description.getNatureIds();
        int i = 0;
        while (i < natures.length) {
            if (ManagerPrefPage.getNatureID().equals(natures[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasMtjNature(IProject project) throws CoreException {
        return project.hasNature(MTJ_NATURE_ID);
    }

    public static String getNatureID() {
        return MTJ_NATURE_ID;
    }

    public void init(IWorkbench workbench) {
    }

    private void initializeDefaults() {
        this.initializeValues(true);
    }

    private void initializeValues(boolean _startUpDone) {
        if (_startUpDone) {
            this.mtjManagerViewUI.getTableViewer().addFilter(new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    ExtensionImplNode _cd = (ExtensionImplNode)element;
                    return _cd.getName().toUpperCase().endsWith(srvFrwFilter);
                }
            });
        }
        if (this.mtjManagerViewUI.getTableViewer().getTable().getItemCount() > 0) {
            this.mtjManagerViewUI.getTableViewer().getTable().select(0);
        }
        int idx = 0;
        while (idx < this.mtjManagerViewUI.getTableViewer().getTable().getItemCount()) {
            try {
                TableItem _item = this.mtjManagerViewUI.getTableViewer().getTable().getItem(idx);
                ExtensionImplNode _cd = (ExtensionImplNode)_item.getData();
                MtjExtension _m = null;
                if (_cd.getImpl() instanceof MtjExtension) {
                    _m = (MtjExtension)_cd.getImpl();
                    _item.setChecked(_m.isActive());
                }
            }
            catch (Exception ex) {
                MtjCorePlugin.getDefault();
                MtjCoreUiPlugin.displayError(MtjCorePlugin.getActiveShell(), 1, 1, Messages.ManagerPrefPage_Error, Messages.ManagerPrefPage_ErrorOccurred, ex);
            }
            ++idx;
        }
    }

    public void performDefaults() {
        this.initializeDefaults();
    }

    public void applyData(Object data) {
        StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)new StatusInfo(0, "applyData()"));
        super.applyData(data);
    }

    public boolean okToLeave() {
        StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)new StatusInfo(0, "okToLeave()"));
        return super.okToLeave();
    }

    public void performApply() {
        StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)new StatusInfo(0, "performApply()"));
        this.storeValues();
        super.performApply();
    }

    public boolean performCancel() {
        StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)new StatusInfo(0, "performCancel()"));
        return super.performCancel();
    }

    public void performHelp() {
        StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)new StatusInfo(0, "performHelp()"));
        super.performHelp();
    }

    public boolean performOk() {
        StatusUtil.applyToStatusLine((DialogPage)this, (IStatus)new StatusInfo(0, "performOk()"));
        this.storeValues();
        return super.performOk();
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
    }

    public void mouseUp(MouseEvent e) {
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    private IJavaProject[] getSelectedProjects() {
        if (this.selectedProjects.length > 0) {
            return this.selectedProjects;
        }
        return null;
    }

    protected void setSelectedProjects(IJavaProject[] _prj) {
        this.selectedProjects = _prj;
    }

    public void storeValues() {
        boolean _hasProjectScope = false;
        if (this.selectedProjects != null && this.selectedProjects.length > 0) {
            _hasProjectScope = true;
        }
        TableItem[] items = this.mtjManagerViewUI.getTableViewer().getTable().getItems();
        int i = 0;
        while (i < items.length) {
            ExtensionImplNode _cd = (ExtensionImplNode)items[i].getData();
            if (_cd.getImpl() != null && _cd.getImpl() instanceof MtjExtension) {
                MtjExtension mtjE = (MtjExtension)_cd.getImpl();
                try {
                    if (_hasProjectScope) {
                        int ix = 0;
                        while (ix < this.selectedProjects.length) {
                            IProject _prj = this.selectedProjects[ix].getProject();
                            MtjServices.getInstance().setActive(mtjE.getId(), mtjE.getType(), _prj.getName(), items[i].getChecked());
                            ++ix;
                        }
                    } else {
                        MtjServices.getInstance().setActive(mtjE.getId(), mtjE.getType(), items[i].getChecked());
                    }
                }
                catch (MtjException mtjEx) {
                    MtjCorePlugin.getDefault();
                    MtjCoreUiPlugin.displayError(MtjCorePlugin.getActiveShell(), 1, 1, Messages.ManagerPrefPage_Error, Messages.ManagerPrefPage_ErrorOccurred, mtjEx);
                }
            }
            ++i;
        }
    }

    public void widgetSelected(SelectionEvent e) {
        this.notifyListeners(e);
        int idx = this.mtjManagerViewUI.get_tableList().getSelectionIndex();
        if (idx > 0) {
            this.row_index = idx;
            ExtensionImplNode cfr_ignored_0 = (ExtensionImplNode)this.mtjManagerViewUI.get_tableList().getItem(idx - 1).getData();
        }
        if (idx != -1) {
            this.row_index = idx;
            ExtensionImplNode cfr_ignored_1 = (ExtensionImplNode)this.mtjManagerViewUI.get_tableList().getItem(idx).getData();
        }
    }

    public void addListener(SelectionListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeListener(SelectionListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyListeners(SelectionEvent e) {
        int i = 0;
        while (i < this.listeners.size()) {
            ((SelectionListener)this.listeners.get(i)).widgetSelected(e);
            ++i;
        }
    }

    public int getSelectedRow_Index() {
        return this.row_index;
    }

    protected void moveDown(int idx, Table _list) {
        this.mtjManagerViewUI.getTableViewer().getTable().deselect(idx);
        this.mtjManagerViewUI.getTableViewer().getTable().select(idx + 1);
        this.row_index = idx + 1;
    }

    protected void moveUp(int idx, Table _list) {
        this.mtjManagerViewUI.getTableViewer().getTable().deselect(idx);
        this.mtjManagerViewUI.getTableViewer().getTable().select(idx - 1);
        this.row_index = idx - 1;
    }

    private class ExtensionCellModifier
    implements ICellModifier {
        private Viewer viewer;

        public ExtensionCellModifier(Viewer viewer) {
            this.viewer = viewer;
        }

        public boolean canModify(Object element, String property) {
            if (element instanceof ExtensionImplNode) {
                ExtensionImplNode cfr_ignored_0 = (ExtensionImplNode)element;
                if (property.equals(COLUMNS[0])) {
                    return true;
                }
                if (property.equals(COLUMNS[1])) {
                    return true;
                }
                if (property.equals(COLUMNS[2])) {
                    return true;
                }
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            if (element instanceof ExtensionImplNode) {
                ExtensionImplNode myTableElement = (ExtensionImplNode)element;
                if (property.equals(COLUMNS[0])) {
                    return myTableElement.getName();
                }
                if (property.equals(COLUMNS[1])) {
                    return myTableElement.getVendor();
                }
                if (property.equals(COLUMNS[2])) {
                    return myTableElement.getVersion();
                }
            }
            return null;
        }

        public void modify(Object element, String property, Object value) {
            Object myElement;
            if (element instanceof TableItem && (myElement = ((TableItem)element).getData()) instanceof ExtensionImplNode) {
                ExtensionImplNode myTableElement = (ExtensionImplNode)myElement;
                if (property.equals(COLUMNS[0])) {
                    myTableElement.setName((String)value);
                }
                this.viewer.refresh();
            }
        }

        private Integer getValueIndex(String value) {
            return new Integer(0);
        }

        private String getValue(Integer index) {
            return null;
        }
    }
}

