/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.core.ui.preferences.view;

import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.mtj.api.extension.AdminGuiProvider;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.ui.Messages;
import org.eclipse.mtj.core.ui.MtjCoreUiPlugin;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ExtensionInfoDialog
extends StatusDialog {
    private MtjExtension adminExtension;
    private boolean hasAdminGui = false;

    public ExtensionInfoDialog(Shell shell, String title, MtjExtension node) {
        super(shell);
        this.adminExtension = node;
        this.setTitle(title);
    }

    public boolean hasAdminGui() {
        return this.hasAdminGui;
    }

    public void createContent(Composite _composite) {
        try {
            this.createDialogArea(_composite);
        }
        catch (Exception e) {
            MtjCoreUiPlugin.getDefault();
            MtjCoreUiPlugin.displayError(this.getShell(), 1, 1, Messages.ExtensionInfoDialog_Error, "AdminGuiProvider.create", e);
            e.printStackTrace();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite container = null;
        AdminGuiProvider adminGuiProvider = null;
        try {
            adminGuiProvider = MtjServices.getInstance().getCorrespondingAdminGuiProvider(this.adminExtension);
            if (adminGuiProvider != null) {
                this.hasAdminGui = true;
                container = adminGuiProvider.create(composite, 0);
                if (container == null) {
                    container = new Composite(composite, 0);
                }
                return container;
            }
            this.hasAdminGui = false;
            return null;
        }
        catch (MtjException ex) {
            MtjCoreUiPlugin.getDefault();
            MtjCoreUiPlugin.displayError(this.getShell(), 1, 1, Messages.ExtensionInfoDialog_Error, "AdminGuiProvider.create", ex);
            ex.printStackTrace();
            return null;
        }
    }

    protected Control createButtonBar(Composite parent) {
        Control control = super.createButtonBar(parent);
        return control;
    }
}

