/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.preverify.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mtj.api.model.preverifier.IClassErrorInformation;
import org.eclipse.mtj.api.model.preverifier.IFieldErrorInformation;
import org.eclipse.mtj.api.model.preverifier.IMethodErrorInformation;
import org.eclipse.mtj.api.model.preverifier.PreverificationError;
import org.eclipse.mtj.api.model.preverifier.PreverificationErrorLocation;
import org.eclipse.mtj.api.model.preverifier.PreverificationErrorLocationType;
import org.eclipse.mtj.api.model.preverifier.PreverificationErrorType;
import org.eclipse.mtj.extension.preverify.Messages;
import org.eclipse.mtj.extension.preverify.internal.MethodRewriter;
import org.eclipse.mtj.extension.preverify.internal.PreverificationClassNode;
import org.eclipse.mtj.extension.preverify.internal.result.ClassNodeErrorInformation;
import org.eclipse.mtj.extension.preverify.internal.result.FieldErrorInformation;
import org.eclipse.mtj.extension.preverify.internal.result.MethodNodeErrorInformation;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;

public class PreverifierMethodNode
extends MethodNode {
    private PreverificationClassNode classNode;
    private int lineNumber;
    private List jsrInstructionIndices;
    private Map labelIndices;

    public PreverifierMethodNode(PreverificationClassNode classNode, int access, String name, String desc, String signature, String[] exceptions) {
        super(access, name, desc, signature, exceptions);
        this.classNode = classNode;
        this.lineNumber = -1;
        this.jsrInstructionIndices = new ArrayList();
        this.labelIndices = new HashMap();
    }

    List getJsrInstructionIndices() {
        return this.jsrInstructionIndices;
    }

    Map getLabelIndices() {
        return this.labelIndices;
    }

    public void visitEnd() {
        boolean hasNoCode;
        boolean bl = hasNoCode = (this.access & 0x100) != 0 || (this.access & 0x400) != 0;
        if (hasNoCode) {
            this.classNode.methods.add(this);
        } else {
            MethodRewriter handler = new MethodRewriter(this.classNode, this);
            try {
                MethodNode updatedMethod = handler.getUpdatedMethod();
                this.classNode.methods.add(updatedMethod);
            }
            catch (AnalyzerException e) {
                throw new RuntimeException(String.valueOf(Messages.PreverifierMethodNode_Method) + this.name + ": " + e.getMessage(), e);
            }
        }
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (this.isDisallowedInstruction(opcode)) {
            ClassNodeErrorInformation classInfo = new ClassNodeErrorInformation(this.classNode);
            MethodNodeErrorInformation methodInfo = new MethodNodeErrorInformation(classInfo, this);
            FieldErrorInformation fieldInfo = new FieldErrorInformation(name, desc);
            PreverificationErrorLocation location = new PreverificationErrorLocation(PreverificationErrorLocationType.METHOD_FIELD, (IClassErrorInformation)classInfo, (IMethodErrorInformation)methodInfo, (IFieldErrorInformation)fieldInfo, this.lineNumber);
            PreverificationError error = new PreverificationError(PreverificationErrorType.FLOATING_POINT, location, null);
            this.addError(error);
        }
        super.visitFieldInsn(opcode, owner, name, desc);
    }

    public void visitIincInsn(int var, int increment) {
        super.visitIincInsn(var, increment);
    }

    public void visitInsn(int opcode) {
        if (this.isDisallowedInstruction(opcode)) {
            ClassNodeErrorInformation classInfo = new ClassNodeErrorInformation(this.classNode);
            MethodNodeErrorInformation methodInfo = new MethodNodeErrorInformation(classInfo, this);
            PreverificationErrorLocation location = new PreverificationErrorLocation(PreverificationErrorLocationType.METHOD_INSTRUCTION, (IClassErrorInformation)classInfo, (IMethodErrorInformation)methodInfo, null, this.lineNumber);
            PreverificationError error = new PreverificationError(PreverificationErrorType.FLOATING_POINT, location, null);
            this.addError(error);
        }
        super.visitInsn(opcode);
    }

    public void visitIntInsn(int opcode, int operand) {
        if (opcode == 188 && (operand == 7 || operand == 6)) {
            ClassNodeErrorInformation classInfo = new ClassNodeErrorInformation(this.classNode);
            MethodNodeErrorInformation methodInfo = new MethodNodeErrorInformation(classInfo, this);
            PreverificationErrorLocation location = new PreverificationErrorLocation(PreverificationErrorLocationType.METHOD_INSTRUCTION, (IClassErrorInformation)classInfo, (IMethodErrorInformation)methodInfo, null, this.lineNumber);
            PreverificationError error = new PreverificationError(PreverificationErrorType.FLOATING_POINT, location, null);
            this.addError(error);
        }
        super.visitIntInsn(opcode, operand);
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (this.isDisallowedType(desc)) {
            ClassNodeErrorInformation classInfo = new ClassNodeErrorInformation(this.classNode);
            MethodNodeErrorInformation methodInfo = new MethodNodeErrorInformation(classInfo, this);
            FieldErrorInformation fieldInfo = new FieldErrorInformation(name, desc);
            PreverificationErrorLocation location = new PreverificationErrorLocation(PreverificationErrorLocationType.METHOD_FIELD, (IClassErrorInformation)classInfo, (IMethodErrorInformation)methodInfo, (IFieldErrorInformation)fieldInfo, this.lineNumber);
            PreverificationError error = new PreverificationError(PreverificationErrorType.FLOATING_POINT, location, null);
            this.addError(error);
        }
        super.visitLocalVariable(name, desc, signature, start, end, index);
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        if (this.isDisallowedType(desc)) {
            ClassNodeErrorInformation classInfo = new ClassNodeErrorInformation(this.classNode);
            MethodNodeErrorInformation methodInfo = new MethodNodeErrorInformation(classInfo, this);
            PreverificationErrorLocation location = new PreverificationErrorLocation(PreverificationErrorLocationType.METHOD_INSTRUCTION, (IClassErrorInformation)classInfo, (IMethodErrorInformation)methodInfo, null, this.lineNumber);
            PreverificationError error = new PreverificationError(PreverificationErrorType.FLOATING_POINT, location, null);
            this.addError(error);
        }
        super.visitMultiANewArrayInsn(desc, dims);
    }

    public void visitVarInsn(int opcode, int var) {
        super.visitVarInsn(opcode, var);
    }

    public void visitJumpInsn(int opcode, Label label) {
        if (this.isDisallowedInstruction(opcode)) {
            ClassNodeErrorInformation classInfo = new ClassNodeErrorInformation(this.classNode);
            MethodNodeErrorInformation methodInfo = new MethodNodeErrorInformation(classInfo, this);
            PreverificationErrorLocation location = new PreverificationErrorLocation(PreverificationErrorLocationType.METHOD_INSTRUCTION, (IClassErrorInformation)classInfo, (IMethodErrorInformation)methodInfo, null, this.lineNumber);
            PreverificationError error = new PreverificationError(PreverificationErrorType.FLOATING_POINT, location, null);
            this.addError(error);
        } else if (opcode == 168) {
            this.jsrInstructionIndices.add(new Integer(this.instructions.size()));
        }
        super.visitJumpInsn(opcode, label);
    }

    public void visitLabel(Label label) {
        this.labelIndices.put(label, new Integer(this.instructions.size()));
        super.visitLabel(label);
    }

    public void visitLineNumber(int line, Label start) {
        this.lineNumber = line;
        super.visitLineNumber(line, start);
    }

    private void addError(PreverificationError error) {
        this.classNode.getErrorList().add(error);
    }

    private boolean isDisallowedInstruction(int opcode) {
        return !this.classNode.getPreverificationPolicy().isFloatingPointAllowed() && this.isFloatingPointOpcode(opcode);
    }

    private boolean isDisallowedType(String typeDescription) {
        Type type = Type.getType((String)typeDescription);
        PreverificationErrorType error = this.classNode.validateType(type);
        return error != PreverificationErrorType.NO_ERROR;
    }

    private boolean isFloatingPointOpcode(int opcode) {
        boolean isFloatingPointOpcode = false;
        switch (opcode) {
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 23: 
            case 24: 
            case 48: 
            case 49: 
            case 56: 
            case 57: 
            case 81: 
            case 82: 
            case 98: 
            case 99: 
            case 102: 
            case 103: 
            case 106: 
            case 107: 
            case 110: 
            case 111: 
            case 114: 
            case 115: 
            case 118: 
            case 119: 
            case 134: 
            case 135: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 142: 
            case 143: 
            case 144: 
            case 149: 
            case 150: 
            case 151: 
            case 152: 
            case 174: 
            case 175: {
                isFloatingPointOpcode = true;
            }
        }
        return isFloatingPointOpcode;
    }
}

