/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.preverify.internal;

import org.objectweb.asm.Type;
import org.objectweb.asm.tree.analysis.SimpleVerifier;

public class SimpleVerifierPlusClassloader
extends SimpleVerifier {
    private ClassLoader classLoader;

    public SimpleVerifierPlusClassloader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    protected Class getClass(Type t) {
        Class<?> clazz = null;
        if (this.classLoader == null) {
            clazz = super.getClass(t);
        } else {
            try {
                String className = this.getRootClassName(t);
                clazz = this.classLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                throw new RuntimeException(e.toString());
            }
        }
        return clazz;
    }

    protected String getRootClassName(Type type) {
        String rootClassName = null;
        switch (type.getSort()) {
            case 1: {
                rootClassName = "java.lang.Boolean";
                break;
            }
            case 2: {
                rootClassName = "java.lang.Character";
                break;
            }
            case 3: {
                rootClassName = "java.lang.Byte";
                break;
            }
            case 4: {
                rootClassName = "java.lang.Short";
                break;
            }
            case 5: {
                rootClassName = "java.lang.Integer";
                break;
            }
            case 6: {
                rootClassName = "java.lang.Float";
                break;
            }
            case 7: {
                rootClassName = "java.lang.Long";
                break;
            }
            case 8: {
                rootClassName = "java.lang.Double";
                break;
            }
            case 9: {
                rootClassName = this.getRootClassName(type.getElementType());
                break;
            }
            case 10: {
                rootClassName = type.getInternalName().replace('/', '.');
            }
        }
        return rootClassName;
    }
}

