/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.launching;

import java.io.File;
import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.VMRunnerConfiguration;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicePlatform;
import org.eclipse.mtj.api.enumerations.ExtensionType;
import org.eclipse.mtj.api.extension.DeviceManagement;
import org.eclipse.mtj.api.extension.DevicePlatformProvider;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.core.MtjCoreErrors;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.core.MtjServices;
import org.eclipse.mtj.core.launching.LaunchHelper;
import org.eclipse.mtj.exception.MtjException;
import org.eclipse.mtj.extension.devide.Messages;
import org.eclipse.mtj.extension.devide.action.ToggleProjectBuildAction;
import org.eclipse.mtj.extension.devide.nature.MtjNature;
import org.eclipse.mtj.extension.devide.project.MtjProject;
import org.eclipse.mtj.internal.utils.Utils;

public class EmulatorLaunchConfigDelegate
extends AbstractJavaLaunchConfigurationDelegate {
    private static final IStatus NO_MIDLET_STATUS = new Status(4, "org.eclipse.mtj.core.ui", 100, "", null);

    protected VMRunnerConfiguration getVMRunnerConfiguration(ILaunchConfiguration launchConfig, DevicePlatform platformDef, String mode) throws CoreException {
        File workingDir = this.verifyWorkingDirectory(launchConfig);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        VMRunnerConfiguration runConfig = new VMRunnerConfiguration(platformDef.getName(), new String[0]);
        runConfig.setVMArguments(new String[0]);
        runConfig.setWorkingDirectory(workingDirName);
        runConfig.setVMSpecificAttributesMap(new HashMap());
        return runConfig;
    }

    public void launch(ILaunchConfiguration launchConfig, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        DevicePlatform platformDef = null;
        try {
            new ToggleProjectBuildAction().run(launchConfig);
            platformDef = this.getPlatformDefinition(launchConfig);
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.mtj.core.ui", 4003, MtjCoreErrors.getErrorMessage((int)4003), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        if (platformDef == null) {
            MtjCorePlugin.throwCoreException((int)4, (int)-999, (String)Messages.EmulatorLaunchConfigDelegate_Platform_definition_unspecified);
        }
        Deployment deployment = this.getDeployment(launchConfig, this.isPredeployNecessary(launchConfig, platformDef));
        Object[] obj = new Object[]{launchConfig.getName()};
        monitor.beginTask(MessageFormat.format(Messages.EmulatorLaunchConfigDelegate_launching, obj), 3);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.subTask(Messages.EmulatorLaunchConfigDelegate_verifying_launch_attributes);
        VMRunnerConfiguration runConfig = this.getVMRunnerConfiguration(launchConfig, platformDef, mode);
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(1);
        monitor.subTask(Messages.EmulatorLaunchConfigDelegate_creating_source_locator);
        this.setDefaultSourceLocator(launch, launchConfig);
        monitor.worked(1);
        try {
            Device device = this.getDefaultDevice(launchConfig, platformDef);
            DevicePlatformProvider dpp = this.getDevicePlatformProvider(platformDef);
            dpp.launch(platformDef, device, deployment, runConfig, launchConfig, launch, mode, MtjNature.getNatureID(), monitor);
        }
        catch (Exception e) {
            Status status = new Status(4, "org.eclipse.mtj.core.ui", 150, "", (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        Utils.dumpCommandLine((ILaunch)launch);
        if (!monitor.isCanceled()) {
            monitor.done();
        }
    }

    private DevicePlatformProvider getDevicePlatformProvider(DevicePlatform devicePlatform) throws MtjException {
        return this.getDeviceManagement().getDevicePlatformProvider(devicePlatform);
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        boolean continueLaunch = super.preLaunchCheck(configuration, mode, monitor);
        if (continueLaunch) {
            continueLaunch = this.verifyEmulationSettings(configuration, monitor);
        }
        return continueLaunch;
    }

    private Deployment getDeployment(ILaunchConfiguration launchConfig, boolean isPredeployNecessary) throws CoreException {
        IMtjProject suite = this.getProjectSuite(launchConfig);
        if (suite != null) {
            if (isPredeployNecessary) {
                return suite.getDeployment(LaunchHelper.getTargetApplication((ILaunchConfiguration)launchConfig));
            }
            return suite.getDeployment();
        }
        return null;
    }

    private Deployment getDeployment(ILaunchConfiguration launchConfig) throws CoreException {
        IMtjProject suite = this.getProjectSuite(launchConfig);
        if (suite != null) {
            return suite.getDeployment();
        }
        return null;
    }

    private boolean doesEmulatorRequirePredeploy(ILaunchConfiguration launchConfig, DevicePlatform platformDef) throws CoreException {
        return platformDef.isPredeploymentRequired();
    }

    private IMtjProject getProjectSuite(ILaunchConfiguration launchConfig) throws CoreException {
        IJavaProject javaProject = this.getJavaProject(launchConfig);
        try {
            return MtjProject.getMtjProject(javaProject);
        }
        catch (MtjException e) {
            Status status = new Status(4, "org.eclipse.mtj.core.ui", 5002, MtjCoreErrors.getErrorMessage((int)5002), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private Device getDefaultDevice(ILaunchConfiguration launchConfig, DevicePlatform platformDef) throws CoreException, MtjException {
        boolean useProjectDef = launchConfig.getAttribute("org.eclipse.mtj.use_project_platform_def", true);
        if (useProjectDef) {
            IJavaProject javaProject = this.getJavaProject(launchConfig);
            IMtjProject mtjProject = MtjProject.getMtjProject(javaProject);
            return mtjProject.getDefaultDevice();
        }
        String deviceName = launchConfig.getAttribute("org.eclipse.mtj.emulated_device", "");
        EList list = platformDef.getDevices();
        for (Device device : list) {
            if (!device.getName().equals(deviceName)) continue;
            return device;
        }
        throw new MtjException(String.valueOf(Messages.EmulatorLaunchConfigDelegate_0) + deviceName);
    }

    private void getProjectExtension() {
    }

    private DevicePlatform getPlatformDefinition(ILaunchConfiguration launchConfig) throws CoreException, MtjException {
        DevicePlatform platformDef = null;
        boolean useProjectDef = launchConfig.getAttribute("org.eclipse.mtj.use_project_platform_def", true);
        if (useProjectDef) {
            IJavaProject javaProject = this.getJavaProject(launchConfig);
            IMtjProject mtjProject = MtjProject.getMtjProject(javaProject);
            platformDef = mtjProject.getPlatformDefinition();
        } else {
            String defName = launchConfig.getAttribute("org.eclipse.mtj.emulation_platform_def", "");
            DeviceManagement dm = this.getDeviceManagement();
            platformDef = dm.getDevicePlatformByName(defName);
            if (platformDef == null) {
                MtjCorePlugin.throwCoreException((int)4, (int)-99999, (String)Messages.EmulatorLaunchConfigDelegate_Launch_platform_definition_invalid);
            }
        }
        return platformDef;
    }

    private DeviceManagement getDeviceManagement() {
        DeviceManagement dm = (DeviceManagement)MtjServices.getInstance().getImplementations(ExtensionType.DEVICE_MANAGEMENT_LITERAL, null, null)[0];
        return dm;
    }

    private boolean verifyEmulationSettings(ILaunchConfiguration configuration, IProgressMonitor monitor) throws CoreException {
        boolean valid = true;
        return valid;
    }

    private boolean isPredeployNecessary(ILaunchConfiguration launchConfig, DevicePlatform platformDef) throws CoreException {
        return this.isDeploymentOutOfDate(launchConfig) && this.doesEmulatorRequirePredeploy(launchConfig, platformDef);
    }

    private boolean isDeploymentOutOfDate(ILaunchConfiguration launchConfig) throws CoreException {
        IMtjProject projectSuite = this.getProjectSuite(launchConfig);
        return !projectSuite.isDeployedJarUpToDate();
    }

    private boolean promptWhetherToContinue() throws CoreException {
        Boolean shouldContinue = (Boolean)MtjCorePlugin.statusPrompt((IStatus)NO_MIDLET_STATUS, (Object)((Object)this));
        return shouldContinue != null ? shouldContinue : false;
    }
}

