/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mtj.extension.devide.ui.wizard.midletsuite;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.mtj.extension.devide.ui.wizard.midletsuite.MidletSuitePackagingWizardPage;
import org.eclipse.mtj.jad.util.JadFileDescriptor;
import org.eclipse.mtj.jad.util.MIDletDescriptor;
import org.eclipse.mtj.jad.util.SynchronizeManifestFileToJad;

public class MidletSuitePackagingWizard
extends Wizard {
    private IStructuredSelection selected;
    IFile jadIFile;
    JadFileDescriptor jadFile;
    MIDletDescriptor manifestFile;
    IProject project;

    public MidletSuitePackagingWizard(IStructuredSelection selected) {
        this.selected = selected;
        Object ob = selected.getFirstElement();
        if (ob instanceof IProject) {
            this.project = (IProject)ob;
        }
        if (ob instanceof IFile) {
            IFile jadOrManifestFile = (IFile)ob;
            this.project = jadOrManifestFile.getProject();
        }
        this.jadIFile = this.project.getFile(String.valueOf(this.project.getName()) + ".jad");
        try {
            if (!this.jadIFile.exists()) {
                this.jadFile = JadFileDescriptor.getDescriptor((IProject)this.project);
            } else {
                this.jadFile = JadFileDescriptor.getDescriptor((IFile)this.jadIFile);
                this.jadFile.setupMIDlets();
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public IStructuredSelection getSelected() {
        return this.selected;
    }

    public void addPages() {
        MidletSuitePackagingWizardPage page = new MidletSuitePackagingWizardPage("page1", this.jadFile, this.project);
        this.addPage((IWizardPage)page);
    }

    public boolean performFinish() {
        try {
            NullProgressMonitor pm = new NullProgressMonitor();
            this.jadFile.serialize(this.jadIFile, (IProgressMonitor)pm);
            SynchronizeManifestFileToJad info = new SynchronizeManifestFileToJad(this.jadIFile);
            info.run((IProgressMonitor)pm);
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return true;
    }
}

