/*******************************************************************************
* Copyright (c) 2005,2006 Nokia Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html 
 *
 * Additional Contributors -
 *  	Kevin Horowitz (IBM Corp) - Update javadoc
*
*******************************************************************************/
package org.eclipse.mtj.api.extension;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.deployment.Deployment;
import org.eclipse.mtj.api.enumerations.BuildType;
import org.eclipse.mtj.api.model.IMtjProject;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.exception.MtjException;

/**
 * A Build Provider is responsible for building the project from source to deployment.
 * Build Provider instances can implement the build process differently. 
 */
public interface BuildProvider extends MtjExtension {

	/**
	 * Returns the build types that are supported by the Build Provider. 
	 * 
 	 * @return
	 */
	public BuildType[] getSupportedTypes() throws MtjException;

	/**
	 * Performs the project build.
	 * @param project
	 * @param type
	 * @param targetPlatform
	 * @param monitor
	 * @return
	 */
	public Deployment build(IMtjProject project, String projectNatureId, BuildType type,
			RuntimePlatformDefinition targetPlatform,
			IProgressMonitor monitor) throws MtjException;
}
