/*******************************************************************************
* Copyright (c) 2005,2006 Nokia Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
 * Additional Contributors -
 *  	Kevin Horowitz (IBM Corp) - Update javadoc
*******************************************************************************/
package org.eclipse.mtj.api.extension;

import org.eclipse.mtj.api.devices.DeviceDescription;
import org.eclipse.mtj.api.devices.DeviceGroup;
import org.eclipse.mtj.api.extension.MtjExtension;
import org.eclipse.mtj.exception.MtjException;

/**
 * Device Description Provider offers information about devices and groups them by similar capabilities.
 * Functionalities, that the Device Description Provider implements, are:
 * Device Description database,
 * matching Device Descriptions query based on a Device Group and
 * management of custom Device Groups.
 * <p>
 * Device Description shows basic capabilities of devices. Every Device Description instance represents 
 * one real device and is identified by vendor name and device model.
 * Capabilities could be device configuration, device profiles or services API that are supported by the device.
 * Capabilities could be also e.g. color depth, screen size, canvas size, camera resolution, supported data 
 * exchange protocol, heap size, max jar size, operating system, supported video format or supported sound format.
 * 
 * <br>
 */
public interface DeviceDescriptionProvider extends MtjExtension {

	/**
	 * Returns DeviceDescription object based on the vendor and model.
	 * 
	 * @param vendor
	 * @param model
	 * @return
	 */
	public DeviceDescription getDeviceDescription(String vendor, String model) throws MtjException;

	/**
	 * Returns DeviceDescription objects that match to the device group.
	 * <p>
	 * Device Groups are representing a group of devices that have similar capabilities.
	 * The groups capabilities are same that the Device Descriptions.
	 * Device Group has also name and description that help to realize the groups devices capabilities.
	 * 
	 * @param group
	 * @return
	 */
	public DeviceDescription[] getMatchingDeviceDescriptions(DeviceGroup group) throws MtjException;

	/**
	 * Returns all defined device groups.
	 * 
	 * @return
	 */
	public DeviceGroup[] getDeviceGroups() throws MtjException;
}
