/*******************************************************************************
* Copyright (c) 2005,2006 Nokia Corporation and others.
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
 * Additional Contributors -
 *  	Kevin Horowitz (IBM Corp) - Update javadoc
*******************************************************************************/
package org.eclipse.mtj.api.extension;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mtj.api.enumerations.ActionType;
import org.eclipse.mtj.api.preprocessing.Condition;
import org.eclipse.mtj.exception.MtjException;


/**
 * Preprocessing is used to solve device fragmentation problem in source code level.
 * PreprocessingProvider implements functionality that is used to modify source code to match target devices.
 */
public interface ProprocessingProvider extends BuildExtension {

	/**
	 * Switch the code blocks on, that follows the given processing conditions, 
	 * and switches off other ones.
	 * 
	 * @param sourceFolder
	 * @param targetFolder
	 * @param conditions
	 * @param monitor
	 */
	public void process(IFolder sourceFolder, IFolder targetFolder,
			Condition[] conditions, IProgressMonitor monitor) throws MtjException;

	/**
	 * Get code template for a given processing condition. 
	 * 
	 * @param actionType
	 * @param condition
	 * @return
	 */
	public String getCodeTemplate(ActionType actionType, Condition condition) throws MtjException;

}
