/******************************************************************************* 
 * Copyright (c) 2005 Nokia Corporation                                         
 * Copyright (c) 2004 Craig Setera 
 * All rights reserved. This program and the accompanying materials 
 * are made available under the terms of the Eclipse Public License v1.0 
 * which accompanies this distribution, and is available at 
 * http://www.eclipse.org/legal/epl-v10.html 
 * 
 * Contributors: 
 * Nokia -  Initial API and implementation 
 * Craig Setera - partial implementation 
 *******************************************************************************/ 

package org.eclipse.mtj.core.launching;

/**
 * Constant definitions for launching support.
 * <p>
 * <b>Note:</b> This class/interface is part of an interim API that is still
 * under development and expected to change before reaching stability. It is
 * being made available at this early stage to solicit feedback from pioneering
 * adopters on the understanding that any code that uses this API will almost
 * certainly be broken as the API evolves.
 */
public interface ILaunchConstants {
	/** The launch configuration type for the wireless emulator */
	public static final String LAUNCH_CONFIG_TYPE = "org.eclipse.mtj.platformLaunchConfigurationType"; //$NON-NLS-1$

	/** The emulated classpath for the emulated class */
	public static final String EXECUTABLE_CLASSPATH = "org.eclipse.mtj.executable_classpath"; //$NON-NLS-1$

	/** The verbosity options */
	public static final String VERBOSITY_OPTIONS = "org.eclipse.mtj.verbosity_options"; //$NON-NLS-1$

	/** Whether or not to use the project's platform definition for emulator */
	public static final String USE_PROJECT_PLATFORM_DEF = "org.eclipse.mtj.use_project_platform_def"; //$NON-NLS-1$

	/**
	 * The platform definition to use for emulation */
	public static final String EMULATION_PLATFORM_DEF = "org.eclipse.mtj.emulation_platform_def"; //$NON-NLS-1$

	/** The device to be emulated */
	public static final String EMULATED_DEVICE = "org.eclipse.mtj.emulated_device"; //$NON-NLS-1$
	public static final String EMULATED_DEVICE_NAME = "org.eclipse.mtj.emulated_device_name"; //$NON-NLS-1$

	/** The application descriptor to be executed */
	public static final String APP_DESCRIPTOR = "org.eclipse.mtj.app_descriptor"; //$NON-NLS-1$

	/** The fully-qualified class to be run in the emulator */
	public static final String EXECUTABLE_CLASS = "org.eclipse.mtj.executable_class"; //$NON-NLS-1$

	/** The heap size to be used by the emulator */
	public static final String HEAP_SIZE = "org.eclipse.mtj.heap_size"; //$NON-NLS-1$

	/** The security domain to execute the emulation under */
	public static final String SECURITY_DOMAIN = "org.eclipse.mtj.security_domain"; //$NON-NLS-1$

	/** The security domain setting that tells not to add the security domain */
	public static final String NO_SECURITY_DOMAIN = "None"; //$NON-NLS-1$

	/** Extra device launch parameters */
	public static final String LAUNCH_PARAMS = "org.eclipse.mtj.launch_params"; //$NON-NLS-1$
	
	/** Communication protocol that should be used when launching the deployment */
	public static final String LAUNCH_PROTOCOL = "org.eclipse.mtj.launch_protocol"; //$NON-NLS-1$
		
}
