/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.devices;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.mtj.api.enumerations.DeviceCommunicationProtocol;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Device</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.mtj.api.devices.Device#getProtectionDomains <em>Protection Domains</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.Device#getConfiguration <em>Configuration</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.Device#getCommunicationProtocol <em>Communication Protocol</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.Device#getDeviceDescription <em>Device Description</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.Device#getRuntimePlatformDefinitions <em>Runtime Platform Definitions</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.Device#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.Device#getVersion <em>Version</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.Device#getVendor <em>Vendor</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.Device#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.Device#getIdentifier <em>Identifier</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevice()
 * @model
 * @generated
 */
public interface Device extends EObject {
	/**
	 * Returns the value of the '<em><b>Protection Domains</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.mtj.api.devices.ProtectionDomain}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Protection Domains</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Protection Domains</em>' containment reference list.
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevice_ProtectionDomains()
	 * @model type="org.eclipse.mtj.api.devices.ProtectionDomain" containment="true" required="true"
	 * @generated
	 */
	EList getProtectionDomains();

	/**
	 * Returns the value of the '<em><b>Configuration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Configuration</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Configuration</em>' containment reference.
	 * @see #setConfiguration(Configuration)
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevice_Configuration()
	 * @model containment="true"
	 * @generated
	 */
	Configuration getConfiguration();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.devices.Device#getConfiguration <em>Configuration</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Configuration</em>' containment reference.
	 * @see #getConfiguration()
	 * @generated
	 */
	void setConfiguration(Configuration value);

	/**
	 * Returns the value of the '<em><b>Communication Protocol</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.mtj.api.enumerations.DeviceCommunicationProtocol}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Communication Protocol</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Communication Protocol</em>' attribute.
	 * @see org.eclipse.mtj.api.enumerations.DeviceCommunicationProtocol
	 * @see #setCommunicationProtocol(DeviceCommunicationProtocol)
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevice_CommunicationProtocol()
	 * @model required="true"
	 * @generated
	 */
	DeviceCommunicationProtocol getCommunicationProtocol();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.devices.Device#getCommunicationProtocol <em>Communication Protocol</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Communication Protocol</em>' attribute.
	 * @see org.eclipse.mtj.api.enumerations.DeviceCommunicationProtocol
	 * @see #getCommunicationProtocol()
	 * @generated
	 */
	void setCommunicationProtocol(DeviceCommunicationProtocol value);

	/**
	 * Returns the value of the '<em><b>Device Description</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Device Description</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Device Description</em>' containment reference.
	 * @see #setDeviceDescription(DeviceDescription)
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevice_DeviceDescription()
	 * @model containment="true"
	 * @generated
	 */
	DeviceDescription getDeviceDescription();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.devices.Device#getDeviceDescription <em>Device Description</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Device Description</em>' containment reference.
	 * @see #getDeviceDescription()
	 * @generated
	 */
	void setDeviceDescription(DeviceDescription value);

	/**
	 * Returns the value of the '<em><b>Runtime Platform Definitions</b></em>' reference list.
	 * The list contents are of type {@link org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition}.
	 * It is bidirectional and its opposite is '{@link org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition#getDevices <em>Devices</em>}'.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Runtime Platform Definitions</em>' reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Runtime Platform Definitions</em>' reference list.
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevice_RuntimePlatformDefinitions()
	 * @see org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition#getDevices
	 * @model type="org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition" opposite="devices" required="true"
	 * @generated
	 */
	EList getRuntimePlatformDefinitions();

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevice_Name()
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.devices.Device#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Version</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Version</em>' attribute.
	 * @see #setVersion(String)
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevice_Version()
	 * @model
	 * @generated
	 */
	String getVersion();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.devices.Device#getVersion <em>Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Version</em>' attribute.
	 * @see #getVersion()
	 * @generated
	 */
	void setVersion(String value);

	/**
	 * Returns the value of the '<em><b>Vendor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Vendor</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Vendor</em>' attribute.
	 * @see #setVendor(String)
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevice_Vendor()
	 * @model
	 * @generated
	 */
	String getVendor();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.devices.Device#getVendor <em>Vendor</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Vendor</em>' attribute.
	 * @see #getVendor()
	 * @generated
	 */
	void setVendor(String value);

	/**
	 * Returns the value of the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Description</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Description</em>' attribute.
	 * @see #setDescription(String)
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevice_Description()
	 * @model
	 * @generated
	 */
	String getDescription();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.devices.Device#getDescription <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Description</em>' attribute.
	 * @see #getDescription()
	 * @generated
	 */
	void setDescription(String value);

	/**
	 * Returns the value of the '<em><b>Identifier</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Identifier</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Identifier</em>' attribute.
	 * @see #setIdentifier(String)
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevice_Identifier()
	 * @model
	 * @generated
	 */
	String getIdentifier();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.devices.Device#getIdentifier <em>Identifier</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Identifier</em>' attribute.
	 * @see #getIdentifier()
	 * @generated
	 */
	void setIdentifier(String value);

} // Device
