/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.devices;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.mtj.api.enumerations.PlatformType;

import org.eclipse.mtj.api.extension.MtjExtension;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Device Platform</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.mtj.api.devices.DevicePlatform#getDevices <em>Devices</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.DevicePlatform#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.DevicePlatform#getConfiguration <em>Configuration</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.DevicePlatform#getRuntimePlatformDefinitions <em>Runtime Platform Definitions</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.DevicePlatform#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.DevicePlatform#getVendor <em>Vendor</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.DevicePlatform#getVersion <em>Version</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.DevicePlatform#isDebugEnabled <em>Debug Enabled</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.DevicePlatform#isPredeploymentRequired <em>Predeployment Required</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.DevicePlatform#isExecutableTargetRequired <em>Executable Target Required</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.DevicePlatform#isKeepAlivePortRequired <em>Keep Alive Port Required</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.DevicePlatform#isPreferencesDialogAvailable <em>Preferences Dialog Available</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.DevicePlatform#isUtilitesDialogAvailable <em>Utilites Dialog Available</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.DevicePlatform#getDevicePlatformProvider <em>Device Platform Provider</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevicePlatform()
 * @model
 * @generated
 */
public interface DevicePlatform extends EObject {
	/**
	 * Returns the value of the '<em><b>Devices</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.mtj.api.devices.Device}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Devices</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Devices</em>' containment reference list.
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevicePlatform_Devices()
	 * @model type="org.eclipse.mtj.api.devices.Device" containment="true" required="true"
	 * @generated
	 */
	EList getDevices();

	/**
	 * Returns the value of the '<em><b>Type</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.mtj.api.enumerations.PlatformType}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Type</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Type</em>' attribute.
	 * @see org.eclipse.mtj.api.enumerations.PlatformType
	 * @see #setType(PlatformType)
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevicePlatform_Type()
	 * @model required="true"
	 * @generated
	 */
	PlatformType getType();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.devices.DevicePlatform#getType <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type</em>' attribute.
	 * @see org.eclipse.mtj.api.enumerations.PlatformType
	 * @see #getType()
	 * @generated
	 */
	void setType(PlatformType value);

	/**
	 * Returns the value of the '<em><b>Configuration</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Configuration</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Configuration</em>' containment reference.
	 * @see #setConfiguration(Configuration)
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevicePlatform_Configuration()
	 * @model containment="true"
	 * @generated
	 */
	Configuration getConfiguration();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.devices.DevicePlatform#getConfiguration <em>Configuration</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Configuration</em>' containment reference.
	 * @see #getConfiguration()
	 * @generated
	 */
	void setConfiguration(Configuration value);

	/**
	 * Returns the value of the '<em><b>Runtime Platform Definitions</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Runtime Platform Definitions</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Runtime Platform Definitions</em>' containment reference list.
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevicePlatform_RuntimePlatformDefinitions()
	 * @model type="org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition" containment="true" required="true"
	 * @generated
	 */
	EList getRuntimePlatformDefinitions();

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevicePlatform_Name()
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.devices.DevicePlatform#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Vendor</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Vendor</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Vendor</em>' attribute.
	 * @see #setVendor(String)
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevicePlatform_Vendor()
	 * @model
	 * @generated
	 */
	String getVendor();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.devices.DevicePlatform#getVendor <em>Vendor</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Vendor</em>' attribute.
	 * @see #getVendor()
	 * @generated
	 */
	void setVendor(String value);

	/**
	 * Returns the value of the '<em><b>Version</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Version</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Version</em>' attribute.
	 * @see #setVersion(String)
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevicePlatform_Version()
	 * @model
	 * @generated
	 */
	String getVersion();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.devices.DevicePlatform#getVersion <em>Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Version</em>' attribute.
	 * @see #getVersion()
	 * @generated
	 */
	void setVersion(String value);

	/**
	 * Returns the value of the '<em><b>Debug Enabled</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Debug Enabled</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Debug Enabled</em>' attribute.
	 * @see #setDebugEnabled(boolean)
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevicePlatform_DebugEnabled()
	 * @model
	 * @generated
	 */
	boolean isDebugEnabled();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.devices.DevicePlatform#isDebugEnabled <em>Debug Enabled</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Debug Enabled</em>' attribute.
	 * @see #isDebugEnabled()
	 * @generated
	 */
	void setDebugEnabled(boolean value);

	/**
	 * Returns the value of the '<em><b>Predeployment Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Predeployment Required</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Predeployment Required</em>' attribute.
	 * @see #setPredeploymentRequired(boolean)
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevicePlatform_PredeploymentRequired()
	 * @model
	 * @generated
	 */
	boolean isPredeploymentRequired();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.devices.DevicePlatform#isPredeploymentRequired <em>Predeployment Required</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Predeployment Required</em>' attribute.
	 * @see #isPredeploymentRequired()
	 * @generated
	 */
	void setPredeploymentRequired(boolean value);

	/**
	 * Returns the value of the '<em><b>Executable Target Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Executable Target Required</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Executable Target Required</em>' attribute.
	 * @see #setExecutableTargetRequired(boolean)
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevicePlatform_ExecutableTargetRequired()
	 * @model
	 * @generated
	 */
	boolean isExecutableTargetRequired();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.devices.DevicePlatform#isExecutableTargetRequired <em>Executable Target Required</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Executable Target Required</em>' attribute.
	 * @see #isExecutableTargetRequired()
	 * @generated
	 */
	void setExecutableTargetRequired(boolean value);

	/**
	 * Returns the value of the '<em><b>Keep Alive Port Required</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Keep Alive Port Required</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Keep Alive Port Required</em>' attribute.
	 * @see #setKeepAlivePortRequired(boolean)
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevicePlatform_KeepAlivePortRequired()
	 * @model
	 * @generated
	 */
	boolean isKeepAlivePortRequired();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.devices.DevicePlatform#isKeepAlivePortRequired <em>Keep Alive Port Required</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Keep Alive Port Required</em>' attribute.
	 * @see #isKeepAlivePortRequired()
	 * @generated
	 */
	void setKeepAlivePortRequired(boolean value);

	/**
	 * Returns the value of the '<em><b>Preferences Dialog Available</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Preferences Dialog Available</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Preferences Dialog Available</em>' attribute.
	 * @see #setPreferencesDialogAvailable(boolean)
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevicePlatform_PreferencesDialogAvailable()
	 * @model
	 * @generated
	 */
	boolean isPreferencesDialogAvailable();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.devices.DevicePlatform#isPreferencesDialogAvailable <em>Preferences Dialog Available</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Preferences Dialog Available</em>' attribute.
	 * @see #isPreferencesDialogAvailable()
	 * @generated
	 */
	void setPreferencesDialogAvailable(boolean value);

	/**
	 * Returns the value of the '<em><b>Utilites Dialog Available</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Utilites Dialog Available</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Utilites Dialog Available</em>' attribute.
	 * @see #setUtilitesDialogAvailable(boolean)
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevicePlatform_UtilitesDialogAvailable()
	 * @model
	 * @generated
	 */
	boolean isUtilitesDialogAvailable();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.devices.DevicePlatform#isUtilitesDialogAvailable <em>Utilites Dialog Available</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Utilites Dialog Available</em>' attribute.
	 * @see #isUtilitesDialogAvailable()
	 * @generated
	 */
	void setUtilitesDialogAvailable(boolean value);

	/**
	 * Returns the value of the '<em><b>Device Platform Provider</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Device Platform Provider</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Device Platform Provider</em>' reference.
	 * @see #setDevicePlatformProvider(MtjExtension)
	 * @see org.eclipse.mtj.api.devices.DevicesPackage#getDevicePlatform_DevicePlatformProvider()
	 * @model required="true"
	 * @generated
	 */
	MtjExtension getDevicePlatformProvider();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.devices.DevicePlatform#getDevicePlatformProvider <em>Device Platform Provider</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Device Platform Provider</em>' reference.
	 * @see #getDevicePlatformProvider()
	 * @generated
	 */
	void setDevicePlatformProvider(MtjExtension value);

} // DevicePlatform
