/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.devices.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.mtj.api.devices.Configuration;
import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DeviceDescription;
import org.eclipse.mtj.api.devices.DevicesPackage;
import org.eclipse.mtj.api.devices.ProtectionDomain;

import org.eclipse.mtj.api.enumerations.DeviceCommunicationProtocol;

import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.api.runtimes.RuntimesPackage;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Device</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.mtj.api.devices.impl.DeviceImpl#getProtectionDomains <em>Protection Domains</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.impl.DeviceImpl#getConfiguration <em>Configuration</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.impl.DeviceImpl#getCommunicationProtocol <em>Communication Protocol</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.impl.DeviceImpl#getDeviceDescription <em>Device Description</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.impl.DeviceImpl#getRuntimePlatformDefinitions <em>Runtime Platform Definitions</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.impl.DeviceImpl#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.impl.DeviceImpl#getVersion <em>Version</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.impl.DeviceImpl#getVendor <em>Vendor</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.impl.DeviceImpl#getDescription <em>Description</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.devices.impl.DeviceImpl#getIdentifier <em>Identifier</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DeviceImpl extends EObjectImpl implements Device {
	/**
	 * The cached value of the '{@link #getProtectionDomains() <em>Protection Domains</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getProtectionDomains()
	 * @generated
	 * @ordered
	 */
	protected EList protectionDomains = null;

	/**
	 * The cached value of the '{@link #getConfiguration() <em>Configuration</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getConfiguration()
	 * @generated
	 * @ordered
	 */
	protected Configuration configuration = null;

	/**
	 * The default value of the '{@link #getCommunicationProtocol() <em>Communication Protocol</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCommunicationProtocol()
	 * @generated
	 * @ordered
	 */
	protected static final DeviceCommunicationProtocol COMMUNICATION_PROTOCOL_EDEFAULT = DeviceCommunicationProtocol.PROTOCOL_UEI_LITERAL;

	/**
	 * The cached value of the '{@link #getCommunicationProtocol() <em>Communication Protocol</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getCommunicationProtocol()
	 * @generated
	 * @ordered
	 */
	protected DeviceCommunicationProtocol communicationProtocol = COMMUNICATION_PROTOCOL_EDEFAULT;

	/**
	 * The cached value of the '{@link #getDeviceDescription() <em>Device Description</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeviceDescription()
	 * @generated
	 * @ordered
	 */
	protected DeviceDescription deviceDescription = null;

	/**
	 * The cached value of the '{@link #getRuntimePlatformDefinitions() <em>Runtime Platform Definitions</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getRuntimePlatformDefinitions()
	 * @generated
	 * @ordered
	 */
	protected EList runtimePlatformDefinitions = null;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * The default value of the '{@link #getVersion() <em>Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVersion()
	 * @generated
	 * @ordered
	 */
	protected static final String VERSION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVersion() <em>Version</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVersion()
	 * @generated
	 * @ordered
	 */
	protected String version = VERSION_EDEFAULT;

	/**
	 * The default value of the '{@link #getVendor() <em>Vendor</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVendor()
	 * @generated
	 * @ordered
	 */
	protected static final String VENDOR_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getVendor() <em>Vendor</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getVendor()
	 * @generated
	 * @ordered
	 */
	protected String vendor = VENDOR_EDEFAULT;

	/**
	 * The default value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected static final String DESCRIPTION_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getDescription() <em>Description</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDescription()
	 * @generated
	 * @ordered
	 */
	protected String description = DESCRIPTION_EDEFAULT;

	/**
	 * The default value of the '{@link #getIdentifier() <em>Identifier</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIdentifier()
	 * @generated
	 * @ordered
	 */
	protected static final String IDENTIFIER_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getIdentifier() <em>Identifier</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getIdentifier()
	 * @generated
	 * @ordered
	 */
	protected String identifier = IDENTIFIER_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected DeviceImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return DevicesPackage.eINSTANCE.getDevice();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getProtectionDomains() {
		if (protectionDomains == null) {
			protectionDomains = new EObjectContainmentEList(ProtectionDomain.class, this, DevicesPackage.DEVICE__PROTECTION_DOMAINS);
		}
		return protectionDomains;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Configuration getConfiguration() {
		return configuration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetConfiguration(Configuration newConfiguration, NotificationChain msgs) {
		Configuration oldConfiguration = configuration;
		configuration = newConfiguration;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DevicesPackage.DEVICE__CONFIGURATION, oldConfiguration, newConfiguration);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setConfiguration(Configuration newConfiguration) {
		if (newConfiguration != configuration) {
			NotificationChain msgs = null;
			if (configuration != null)
				msgs = ((InternalEObject)configuration).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DevicesPackage.DEVICE__CONFIGURATION, null, msgs);
			if (newConfiguration != null)
				msgs = ((InternalEObject)newConfiguration).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DevicesPackage.DEVICE__CONFIGURATION, null, msgs);
			msgs = basicSetConfiguration(newConfiguration, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DevicesPackage.DEVICE__CONFIGURATION, newConfiguration, newConfiguration));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeviceCommunicationProtocol getCommunicationProtocol() {
		return communicationProtocol;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setCommunicationProtocol(DeviceCommunicationProtocol newCommunicationProtocol) {
		DeviceCommunicationProtocol oldCommunicationProtocol = communicationProtocol;
		communicationProtocol = newCommunicationProtocol == null ? COMMUNICATION_PROTOCOL_EDEFAULT : newCommunicationProtocol;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DevicesPackage.DEVICE__COMMUNICATION_PROTOCOL, oldCommunicationProtocol, communicationProtocol));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeviceDescription getDeviceDescription() {
		return deviceDescription;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetDeviceDescription(DeviceDescription newDeviceDescription, NotificationChain msgs) {
		DeviceDescription oldDeviceDescription = deviceDescription;
		deviceDescription = newDeviceDescription;
		if (eNotificationRequired()) {
			ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DevicesPackage.DEVICE__DEVICE_DESCRIPTION, oldDeviceDescription, newDeviceDescription);
			if (msgs == null) msgs = notification; else msgs.add(notification);
		}
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDeviceDescription(DeviceDescription newDeviceDescription) {
		if (newDeviceDescription != deviceDescription) {
			NotificationChain msgs = null;
			if (deviceDescription != null)
				msgs = ((InternalEObject)deviceDescription).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DevicesPackage.DEVICE__DEVICE_DESCRIPTION, null, msgs);
			if (newDeviceDescription != null)
				msgs = ((InternalEObject)newDeviceDescription).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DevicesPackage.DEVICE__DEVICE_DESCRIPTION, null, msgs);
			msgs = basicSetDeviceDescription(newDeviceDescription, msgs);
			if (msgs != null) msgs.dispatch();
		}
		else if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DevicesPackage.DEVICE__DEVICE_DESCRIPTION, newDeviceDescription, newDeviceDescription));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getRuntimePlatformDefinitions() {
		if (runtimePlatformDefinitions == null) {
			runtimePlatformDefinitions = new EObjectWithInverseResolvingEList.ManyInverse(RuntimePlatformDefinition.class, this, DevicesPackage.DEVICE__RUNTIME_PLATFORM_DEFINITIONS, RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__DEVICES);
		}
		return runtimePlatformDefinitions;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DevicesPackage.DEVICE__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getVersion() {
		return version;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVersion(String newVersion) {
		String oldVersion = version;
		version = newVersion;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DevicesPackage.DEVICE__VERSION, oldVersion, version));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getVendor() {
		return vendor;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setVendor(String newVendor) {
		String oldVendor = vendor;
		vendor = newVendor;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DevicesPackage.DEVICE__VENDOR, oldVendor, vendor));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getDescription() {
		return description;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setDescription(String newDescription) {
		String oldDescription = description;
		description = newDescription;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DevicesPackage.DEVICE__DESCRIPTION, oldDescription, description));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getIdentifier() {
		return identifier;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setIdentifier(String newIdentifier) {
		String oldIdentifier = identifier;
		identifier = newIdentifier;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, DevicesPackage.DEVICE__IDENTIFIER, oldIdentifier, identifier));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case DevicesPackage.DEVICE__RUNTIME_PLATFORM_DEFINITIONS:
					return ((InternalEList)getRuntimePlatformDefinitions()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case DevicesPackage.DEVICE__PROTECTION_DOMAINS:
					return ((InternalEList)getProtectionDomains()).basicRemove(otherEnd, msgs);
				case DevicesPackage.DEVICE__CONFIGURATION:
					return basicSetConfiguration(null, msgs);
				case DevicesPackage.DEVICE__DEVICE_DESCRIPTION:
					return basicSetDeviceDescription(null, msgs);
				case DevicesPackage.DEVICE__RUNTIME_PLATFORM_DEFINITIONS:
					return ((InternalEList)getRuntimePlatformDefinitions()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DevicesPackage.DEVICE__PROTECTION_DOMAINS:
				return getProtectionDomains();
			case DevicesPackage.DEVICE__CONFIGURATION:
				return getConfiguration();
			case DevicesPackage.DEVICE__COMMUNICATION_PROTOCOL:
				return getCommunicationProtocol();
			case DevicesPackage.DEVICE__DEVICE_DESCRIPTION:
				return getDeviceDescription();
			case DevicesPackage.DEVICE__RUNTIME_PLATFORM_DEFINITIONS:
				return getRuntimePlatformDefinitions();
			case DevicesPackage.DEVICE__NAME:
				return getName();
			case DevicesPackage.DEVICE__VERSION:
				return getVersion();
			case DevicesPackage.DEVICE__VENDOR:
				return getVendor();
			case DevicesPackage.DEVICE__DESCRIPTION:
				return getDescription();
			case DevicesPackage.DEVICE__IDENTIFIER:
				return getIdentifier();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DevicesPackage.DEVICE__PROTECTION_DOMAINS:
				getProtectionDomains().clear();
				getProtectionDomains().addAll((Collection)newValue);
				return;
			case DevicesPackage.DEVICE__CONFIGURATION:
				setConfiguration((Configuration)newValue);
				return;
			case DevicesPackage.DEVICE__COMMUNICATION_PROTOCOL:
				setCommunicationProtocol((DeviceCommunicationProtocol)newValue);
				return;
			case DevicesPackage.DEVICE__DEVICE_DESCRIPTION:
				setDeviceDescription((DeviceDescription)newValue);
				return;
			case DevicesPackage.DEVICE__RUNTIME_PLATFORM_DEFINITIONS:
				getRuntimePlatformDefinitions().clear();
				getRuntimePlatformDefinitions().addAll((Collection)newValue);
				return;
			case DevicesPackage.DEVICE__NAME:
				setName((String)newValue);
				return;
			case DevicesPackage.DEVICE__VERSION:
				setVersion((String)newValue);
				return;
			case DevicesPackage.DEVICE__VENDOR:
				setVendor((String)newValue);
				return;
			case DevicesPackage.DEVICE__DESCRIPTION:
				setDescription((String)newValue);
				return;
			case DevicesPackage.DEVICE__IDENTIFIER:
				setIdentifier((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DevicesPackage.DEVICE__PROTECTION_DOMAINS:
				getProtectionDomains().clear();
				return;
			case DevicesPackage.DEVICE__CONFIGURATION:
				setConfiguration((Configuration)null);
				return;
			case DevicesPackage.DEVICE__COMMUNICATION_PROTOCOL:
				setCommunicationProtocol(COMMUNICATION_PROTOCOL_EDEFAULT);
				return;
			case DevicesPackage.DEVICE__DEVICE_DESCRIPTION:
				setDeviceDescription((DeviceDescription)null);
				return;
			case DevicesPackage.DEVICE__RUNTIME_PLATFORM_DEFINITIONS:
				getRuntimePlatformDefinitions().clear();
				return;
			case DevicesPackage.DEVICE__NAME:
				setName(NAME_EDEFAULT);
				return;
			case DevicesPackage.DEVICE__VERSION:
				setVersion(VERSION_EDEFAULT);
				return;
			case DevicesPackage.DEVICE__VENDOR:
				setVendor(VENDOR_EDEFAULT);
				return;
			case DevicesPackage.DEVICE__DESCRIPTION:
				setDescription(DESCRIPTION_EDEFAULT);
				return;
			case DevicesPackage.DEVICE__IDENTIFIER:
				setIdentifier(IDENTIFIER_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case DevicesPackage.DEVICE__PROTECTION_DOMAINS:
				return protectionDomains != null && !protectionDomains.isEmpty();
			case DevicesPackage.DEVICE__CONFIGURATION:
				return configuration != null;
			case DevicesPackage.DEVICE__COMMUNICATION_PROTOCOL:
				return communicationProtocol != COMMUNICATION_PROTOCOL_EDEFAULT;
			case DevicesPackage.DEVICE__DEVICE_DESCRIPTION:
				return deviceDescription != null;
			case DevicesPackage.DEVICE__RUNTIME_PLATFORM_DEFINITIONS:
				return runtimePlatformDefinitions != null && !runtimePlatformDefinitions.isEmpty();
			case DevicesPackage.DEVICE__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
			case DevicesPackage.DEVICE__VERSION:
				return VERSION_EDEFAULT == null ? version != null : !VERSION_EDEFAULT.equals(version);
			case DevicesPackage.DEVICE__VENDOR:
				return VENDOR_EDEFAULT == null ? vendor != null : !VENDOR_EDEFAULT.equals(vendor);
			case DevicesPackage.DEVICE__DESCRIPTION:
				return DESCRIPTION_EDEFAULT == null ? description != null : !DESCRIPTION_EDEFAULT.equals(description);
			case DevicesPackage.DEVICE__IDENTIFIER:
				return IDENTIFIER_EDEFAULT == null ? identifier != null : !IDENTIFIER_EDEFAULT.equals(identifier);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (communicationProtocol: ");
		result.append(communicationProtocol);
		result.append(", name: ");
		result.append(name);
		result.append(", version: ");
		result.append(version);
		result.append(", vendor: ");
		result.append(vendor);
		result.append(", description: ");
		result.append(description);
		result.append(", identifier: ");
		result.append(identifier);
		result.append(')');
		return result.toString();
	}

} //DeviceImpl
