/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.devices.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.mtj.api.devices.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class DevicesFactoryImpl extends EFactoryImpl implements DevicesFactory {
	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DevicesFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case DevicesPackage.DEVICE_PLATFORM: return createDevicePlatform();
			case DevicesPackage.DEVICE: return createDevice();
			case DevicesPackage.CONFIGURATION: return createConfiguration();
			case DevicesPackage.CONFIGURATION_ITEM: return createConfigurationItem();
			case DevicesPackage.CONFIGURATION_ERROR: return createConfigurationError();
			case DevicesPackage.PROTECTION_DOMAIN: return createProtectionDomain();
			case DevicesPackage.PERMISSION: return createPermission();
			case DevicesPackage.DEVICE_DESCRIPTION: return createDeviceDescription();
			case DevicesPackage.DEVICE_CAPABILITY: return createDeviceCapability();
			case DevicesPackage.DEVICE_FEATURE: return createDeviceFeature();
			case DevicesPackage.DEVICE_GROUP: return createDeviceGroup();
			case DevicesPackage.CONFIGURATION_VALUE: return createConfigurationValue();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DevicePlatform createDevicePlatform() {
		DevicePlatformImpl devicePlatform = new DevicePlatformImpl();
		return devicePlatform;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Device createDevice() {
		DeviceImpl device = new DeviceImpl();
		return device;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Configuration createConfiguration() {
		ConfigurationImpl configuration = new ConfigurationImpl();
		return configuration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConfigurationItem createConfigurationItem() {
		ConfigurationItemImpl configurationItem = new ConfigurationItemImpl();
		return configurationItem;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConfigurationError createConfigurationError() {
		ConfigurationErrorImpl configurationError = new ConfigurationErrorImpl();
		return configurationError;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ProtectionDomain createProtectionDomain() {
		ProtectionDomainImpl protectionDomain = new ProtectionDomainImpl();
		return protectionDomain;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Permission createPermission() {
		PermissionImpl permission = new PermissionImpl();
		return permission;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeviceDescription createDeviceDescription() {
		DeviceDescriptionImpl deviceDescription = new DeviceDescriptionImpl();
		return deviceDescription;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeviceCapability createDeviceCapability() {
		DeviceCapabilityImpl deviceCapability = new DeviceCapabilityImpl();
		return deviceCapability;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeviceFeature createDeviceFeature() {
		DeviceFeatureImpl deviceFeature = new DeviceFeatureImpl();
		return deviceFeature;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeviceGroup createDeviceGroup() {
		DeviceGroupImpl deviceGroup = new DeviceGroupImpl();
		return deviceGroup;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ConfigurationValue createConfigurationValue() {
		ConfigurationValueImpl configurationValue = new ConfigurationValueImpl();
		return configurationValue;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DevicesPackage getDevicesPackage() {
		return (DevicesPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	public static DevicesPackage getPackage() {
		return DevicesPackage.eINSTANCE;
	}

} //DevicesFactoryImpl
