/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.enumerations;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import org.eclipse.emf.common.util.AbstractEnumerator;

/**
 * <!-- begin-user-doc -->
 * A representation of the literals of the enumeration '<em><b>Device Communication Protocol</b></em>',
 * and utility methods for working with them.
 * <!-- end-user-doc -->
 * @see org.eclipse.mtj.api.enumerations.EnumerationsPackage#getDeviceCommunicationProtocol()
 * @model
 * @generated
 */
public final class DeviceCommunicationProtocol extends AbstractEnumerator {
	/**
	 * The '<em><b>PROTOCOL UEI</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PROTOCOL UEI</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PROTOCOL_UEI_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PROTOCOL_UEI = 0;

	/**
	 * The '<em><b>PROTOCOL XEI</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PROTOCOL XEI</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PROTOCOL_XEI_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PROTOCOL_XEI = 1;

	/**
	 * The '<em><b>PROTOCOL OTA</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PROTOCOL OTA</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PROTOCOL_OTA_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PROTOCOL_OTA = 2;

	/**
	 * The '<em><b>PROTOCOL OBEX</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PROTOCOL OBEX</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PROTOCOL_OBEX_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PROTOCOL_OBEX = 3;

	/**
	 * The '<em><b>PROTOCOL OTHER</b></em>' literal value.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of '<em><b>PROTOCOL OTHER</b></em>' literal object isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @see #PROTOCOL_OTHER_LITERAL
	 * @model
	 * @generated
	 * @ordered
	 */
	public static final int PROTOCOL_OTHER = 4;

	/**
	 * The '<em><b>PROTOCOL UEI</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROTOCOL_UEI
	 * @generated
	 * @ordered
	 */
	public static final DeviceCommunicationProtocol PROTOCOL_UEI_LITERAL = new DeviceCommunicationProtocol(PROTOCOL_UEI, "PROTOCOL_UEI");

	/**
	 * The '<em><b>PROTOCOL XEI</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROTOCOL_XEI
	 * @generated
	 * @ordered
	 */
	public static final DeviceCommunicationProtocol PROTOCOL_XEI_LITERAL = new DeviceCommunicationProtocol(PROTOCOL_XEI, "PROTOCOL_XEI");

	/**
	 * The '<em><b>PROTOCOL OTA</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROTOCOL_OTA
	 * @generated
	 * @ordered
	 */
	public static final DeviceCommunicationProtocol PROTOCOL_OTA_LITERAL = new DeviceCommunicationProtocol(PROTOCOL_OTA, "PROTOCOL_OTA");

	/**
	 * The '<em><b>PROTOCOL OBEX</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROTOCOL_OBEX
	 * @generated
	 * @ordered
	 */
	public static final DeviceCommunicationProtocol PROTOCOL_OBEX_LITERAL = new DeviceCommunicationProtocol(PROTOCOL_OBEX, "PROTOCOL_OBEX");

	/**
	 * The '<em><b>PROTOCOL OTHER</b></em>' literal object.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #PROTOCOL_OTHER
	 * @generated
	 * @ordered
	 */
	public static final DeviceCommunicationProtocol PROTOCOL_OTHER_LITERAL = new DeviceCommunicationProtocol(PROTOCOL_OTHER, "PROTOCOL_OTHER");

	/**
	 * An array of all the '<em><b>Device Communication Protocol</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private static final DeviceCommunicationProtocol[] VALUES_ARRAY =
		new DeviceCommunicationProtocol[] {
			PROTOCOL_UEI_LITERAL,
			PROTOCOL_XEI_LITERAL,
			PROTOCOL_OTA_LITERAL,
			PROTOCOL_OBEX_LITERAL,
			PROTOCOL_OTHER_LITERAL,
		};

	/**
	 * A public read-only list of all the '<em><b>Device Communication Protocol</b></em>' enumerators.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

	/**
	 * Returns the '<em><b>Device Communication Protocol</b></em>' literal with the specified name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static DeviceCommunicationProtocol get(String name) {
		for (int i = 0; i < VALUES_ARRAY.length; ++i) {
			DeviceCommunicationProtocol result = VALUES_ARRAY[i];
			if (result.toString().equals(name)) {
				return result;
			}
		}
		return null;
	}

	/**
	 * Returns the '<em><b>Device Communication Protocol</b></em>' literal with the specified value.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static DeviceCommunicationProtocol get(int value) {
		switch (value) {
			case PROTOCOL_UEI: return PROTOCOL_UEI_LITERAL;
			case PROTOCOL_XEI: return PROTOCOL_XEI_LITERAL;
			case PROTOCOL_OTA: return PROTOCOL_OTA_LITERAL;
			case PROTOCOL_OBEX: return PROTOCOL_OBEX_LITERAL;
			case PROTOCOL_OTHER: return PROTOCOL_OTHER_LITERAL;
		}
		return null;	
	}

	/**
	 * Only this class can construct instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	private DeviceCommunicationProtocol(int value, String name) {
		super(value, name);
	}

} //DeviceCommunicationProtocol
