/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.enumerations;

import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EPackage;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.mtj.api.enumerations.EnumerationsFactory
 * @model kind="package"
 * @generated
 */
public interface EnumerationsPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "enumerations";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http:///org/eclipse/mtj/api/enumerations.ecore";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "org.eclipse.mtj.api.enumerations";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	EnumerationsPackage eINSTANCE = org.eclipse.mtj.api.enumerations.impl.EnumerationsPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.enumerations.Capability <em>Capability</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.enumerations.Capability
	 * @see org.eclipse.mtj.api.enumerations.impl.EnumerationsPackageImpl#getCapability()
	 * @generated
	 */
	int CAPABILITY = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.enumerations.BuildType <em>Build Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.enumerations.BuildType
	 * @see org.eclipse.mtj.api.enumerations.impl.EnumerationsPackageImpl#getBuildType()
	 * @generated
	 */
	int BUILD_TYPE = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.enumerations.ExtensionType <em>Extension Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.enumerations.ExtensionType
	 * @see org.eclipse.mtj.api.enumerations.impl.EnumerationsPackageImpl#getExtensionType()
	 * @generated
	 */
	int EXTENSION_TYPE = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.enumerations.ActionType <em>Action Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.enumerations.ActionType
	 * @see org.eclipse.mtj.api.enumerations.impl.EnumerationsPackageImpl#getActionType()
	 * @generated
	 */
	int ACTION_TYPE = 3;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.enumerations.DeploymentType <em>Deployment Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.enumerations.DeploymentType
	 * @see org.eclipse.mtj.api.enumerations.impl.EnumerationsPackageImpl#getDeploymentType()
	 * @generated
	 */
	int DEPLOYMENT_TYPE = 4;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.enumerations.DeviceCommunicationProtocol <em>Device Communication Protocol</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.enumerations.DeviceCommunicationProtocol
	 * @see org.eclipse.mtj.api.enumerations.impl.EnumerationsPackageImpl#getDeviceCommunicationProtocol()
	 * @generated
	 */
	int DEVICE_COMMUNICATION_PROTOCOL = 5;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.enumerations.PlatformType <em>Platform Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.enumerations.PlatformType
	 * @see org.eclipse.mtj.api.enumerations.impl.EnumerationsPackageImpl#getPlatformType()
	 * @generated
	 */
	int PLATFORM_TYPE = 6;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.enumerations.Expression <em>Expression</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.enumerations.Expression
	 * @see org.eclipse.mtj.api.enumerations.impl.EnumerationsPackageImpl#getExpression()
	 * @generated
	 */
	int EXPRESSION = 7;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.enumerations.ProjectType <em>Project Type</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.enumerations.ProjectType
	 * @see org.eclipse.mtj.api.enumerations.impl.EnumerationsPackageImpl#getProjectType()
	 * @generated
	 */
	int PROJECT_TYPE = 8;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.enumerations.DeviceStatus <em>Device Status</em>}' enum.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.enumerations.DeviceStatus
	 * @see org.eclipse.mtj.api.enumerations.impl.EnumerationsPackageImpl#getDeviceStatus()
	 * @generated
	 */
	int DEVICE_STATUS = 9;


	/**
	 * Returns the meta object for enum '{@link org.eclipse.mtj.api.enumerations.Capability <em>Capability</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Capability</em>'.
	 * @see org.eclipse.mtj.api.enumerations.Capability
	 * @generated
	 */
	EEnum getCapability();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.mtj.api.enumerations.BuildType <em>Build Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Build Type</em>'.
	 * @see org.eclipse.mtj.api.enumerations.BuildType
	 * @generated
	 */
	EEnum getBuildType();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.mtj.api.enumerations.ExtensionType <em>Extension Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Extension Type</em>'.
	 * @see org.eclipse.mtj.api.enumerations.ExtensionType
	 * @generated
	 */
	EEnum getExtensionType();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.mtj.api.enumerations.ActionType <em>Action Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Action Type</em>'.
	 * @see org.eclipse.mtj.api.enumerations.ActionType
	 * @generated
	 */
	EEnum getActionType();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.mtj.api.enumerations.DeploymentType <em>Deployment Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Deployment Type</em>'.
	 * @see org.eclipse.mtj.api.enumerations.DeploymentType
	 * @generated
	 */
	EEnum getDeploymentType();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.mtj.api.enumerations.DeviceCommunicationProtocol <em>Device Communication Protocol</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Device Communication Protocol</em>'.
	 * @see org.eclipse.mtj.api.enumerations.DeviceCommunicationProtocol
	 * @generated
	 */
	EEnum getDeviceCommunicationProtocol();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.mtj.api.enumerations.PlatformType <em>Platform Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Platform Type</em>'.
	 * @see org.eclipse.mtj.api.enumerations.PlatformType
	 * @generated
	 */
	EEnum getPlatformType();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.mtj.api.enumerations.Expression <em>Expression</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Expression</em>'.
	 * @see org.eclipse.mtj.api.enumerations.Expression
	 * @generated
	 */
	EEnum getExpression();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.mtj.api.enumerations.ProjectType <em>Project Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Project Type</em>'.
	 * @see org.eclipse.mtj.api.enumerations.ProjectType
	 * @generated
	 */
	EEnum getProjectType();

	/**
	 * Returns the meta object for enum '{@link org.eclipse.mtj.api.enumerations.DeviceStatus <em>Device Status</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for enum '<em>Device Status</em>'.
	 * @see org.eclipse.mtj.api.enumerations.DeviceStatus
	 * @generated
	 */
	EEnum getDeviceStatus();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	EnumerationsFactory getEnumerationsFactory();

} //EnumerationsPackage
