/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.preprocessing;

import org.eclipse.mtj.api.enumerations.Capability;
import org.eclipse.mtj.api.enumerations.Expression;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Capability Condition</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.mtj.api.preprocessing.CapabilityCondition#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.preprocessing.CapabilityCondition#getExpression <em>Expression</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.preprocessing.CapabilityCondition#getValue <em>Value</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.mtj.api.preprocessing.PreprocessingPackage#getCapabilityCondition()
 * @model
 * @generated
 */
public interface CapabilityCondition extends Condition {
	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.mtj.api.enumerations.Capability}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see org.eclipse.mtj.api.enumerations.Capability
	 * @see #setName(Capability)
	 * @see org.eclipse.mtj.api.preprocessing.PreprocessingPackage#getCapabilityCondition_Name()
	 * @model
	 * @generated
	 */
	Capability getName();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.preprocessing.CapabilityCondition#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see org.eclipse.mtj.api.enumerations.Capability
	 * @see #getName()
	 * @generated
	 */
	void setName(Capability value);

	/**
	 * Returns the value of the '<em><b>Expression</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.mtj.api.enumerations.Expression}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Expression</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Expression</em>' attribute.
	 * @see org.eclipse.mtj.api.enumerations.Expression
	 * @see #setExpression(Expression)
	 * @see org.eclipse.mtj.api.preprocessing.PreprocessingPackage#getCapabilityCondition_Expression()
	 * @model
	 * @generated
	 */
	Expression getExpression();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.preprocessing.CapabilityCondition#getExpression <em>Expression</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Expression</em>' attribute.
	 * @see org.eclipse.mtj.api.enumerations.Expression
	 * @see #getExpression()
	 * @generated
	 */
	void setExpression(Expression value);

	/**
	 * Returns the value of the '<em><b>Value</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Value</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Value</em>' attribute.
	 * @see #setValue(String)
	 * @see org.eclipse.mtj.api.preprocessing.PreprocessingPackage#getCapabilityCondition_Value()
	 * @model
	 * @generated
	 */
	String getValue();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.preprocessing.CapabilityCondition#getValue <em>Value</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Value</em>' attribute.
	 * @see #getValue()
	 * @generated
	 */
	void setValue(String value);

} // CapabilityCondition
