/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.project;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Packaging Details</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.mtj.api.project.PackagingDetails#isIncrementVersionAutomatically <em>Increment Version Automatically</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.PackagingDetails#getExculedManifestEntries <em>Exculed Manifest Entries</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.mtj.api.project.ProjectPackage#getPackagingDetails()
 * @model
 * @generated
 */
public interface PackagingDetails extends EObject {
	/**
	 * Returns the value of the '<em><b>Increment Version Automatically</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Increment Version Automatically</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Increment Version Automatically</em>' attribute.
	 * @see #setIncrementVersionAutomatically(boolean)
	 * @see org.eclipse.mtj.api.project.ProjectPackage#getPackagingDetails_IncrementVersionAutomatically()
	 * @model
	 * @generated
	 */
	boolean isIncrementVersionAutomatically();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.project.PackagingDetails#isIncrementVersionAutomatically <em>Increment Version Automatically</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Increment Version Automatically</em>' attribute.
	 * @see #isIncrementVersionAutomatically()
	 * @generated
	 */
	void setIncrementVersionAutomatically(boolean value);

	/**
	 * Returns the value of the '<em><b>Exculed Manifest Entries</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.mtj.api.project.Parameter}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Exculed Manifest Entries</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Exculed Manifest Entries</em>' containment reference list.
	 * @see org.eclipse.mtj.api.project.ProjectPackage#getPackagingDetails_ExculedManifestEntries()
	 * @model type="org.eclipse.mtj.api.project.Parameter" containment="true"
	 * @generated
	 */
	EList getExculedManifestEntries();

} // PackagingDetails
