/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.project;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EObject;

import org.eclipse.mtj.api.enumerations.ProjectType;

/**
 * <!-- begin-user-doc -->
 * A representation of the model object '<em><b>Project</b></em>'.
 * <!-- end-user-doc -->
 *
 * <p>
 * The following features are supported:
 * <ul>
 *   <li>{@link org.eclipse.mtj.api.project.Project#getType <em>Type</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.Project#getTargetDevices <em>Target Devices</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.Project#getDefaultTargetDevice <em>Default Target Device</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.Project#getObfuscationDetail <em>Obfuscation Detail</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.Project#getName <em>Name</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.Project#getPackagingDetails <em>Packaging Details</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.project.Project#getDefaultDeploymentDevice <em>Default Deployment Device</em>}</li>
 * </ul>
 * </p>
 *
 * @see org.eclipse.mtj.api.project.ProjectPackage#getProject()
 * @model
 * @generated
 */
public interface Project extends EObject {
	/**
	 * Returns the value of the '<em><b>Type</b></em>' attribute.
	 * The literals are from the enumeration {@link org.eclipse.mtj.api.enumerations.ProjectType}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Type</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Type</em>' attribute.
	 * @see org.eclipse.mtj.api.enumerations.ProjectType
	 * @see #setType(ProjectType)
	 * @see org.eclipse.mtj.api.project.ProjectPackage#getProject_Type()
	 * @model required="true"
	 * @generated
	 */
	ProjectType getType();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.project.Project#getType <em>Type</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Type</em>' attribute.
	 * @see org.eclipse.mtj.api.enumerations.ProjectType
	 * @see #getType()
	 * @generated
	 */
	void setType(ProjectType value);

	/**
	 * Returns the value of the '<em><b>Target Devices</b></em>' containment reference list.
	 * The list contents are of type {@link org.eclipse.mtj.api.project.TargetDevice}.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Target Devices</em>' containment reference list isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Target Devices</em>' containment reference list.
	 * @see org.eclipse.mtj.api.project.ProjectPackage#getProject_TargetDevices()
	 * @model type="org.eclipse.mtj.api.project.TargetDevice" containment="true" required="true"
	 * @generated
	 */
	EList getTargetDevices();

	/**
	 * Returns the value of the '<em><b>Default Target Device</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Default Target Device</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Default Target Device</em>' containment reference.
	 * @see #setDefaultTargetDevice(TargetDevice)
	 * @see org.eclipse.mtj.api.project.ProjectPackage#getProject_DefaultTargetDevice()
	 * @model containment="true"
	 * @generated
	 */
	TargetDevice getDefaultTargetDevice();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.project.Project#getDefaultTargetDevice <em>Default Target Device</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Default Target Device</em>' containment reference.
	 * @see #getDefaultTargetDevice()
	 * @generated
	 */
	void setDefaultTargetDevice(TargetDevice value);

	/**
	 * Returns the value of the '<em><b>Obfuscation Detail</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Obfuscation Detail</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Obfuscation Detail</em>' containment reference.
	 * @see #setObfuscationDetail(ObfuscationDetail)
	 * @see org.eclipse.mtj.api.project.ProjectPackage#getProject_ObfuscationDetail()
	 * @model containment="true"
	 * @generated
	 */
	ObfuscationDetail getObfuscationDetail();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.project.Project#getObfuscationDetail <em>Obfuscation Detail</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Obfuscation Detail</em>' containment reference.
	 * @see #getObfuscationDetail()
	 * @generated
	 */
	void setObfuscationDetail(ObfuscationDetail value);

	/**
	 * Returns the value of the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Name</em>' attribute isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Name</em>' attribute.
	 * @see #setName(String)
	 * @see org.eclipse.mtj.api.project.ProjectPackage#getProject_Name()
	 * @model
	 * @generated
	 */
	String getName();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.project.Project#getName <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Name</em>' attribute.
	 * @see #getName()
	 * @generated
	 */
	void setName(String value);

	/**
	 * Returns the value of the '<em><b>Packaging Details</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Packaging Details</em>' containment reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Packaging Details</em>' containment reference.
	 * @see #setPackagingDetails(PackagingDetails)
	 * @see org.eclipse.mtj.api.project.ProjectPackage#getProject_PackagingDetails()
	 * @model containment="true"
	 * @generated
	 */
	PackagingDetails getPackagingDetails();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.project.Project#getPackagingDetails <em>Packaging Details</em>}' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Packaging Details</em>' containment reference.
	 * @see #getPackagingDetails()
	 * @generated
	 */
	void setPackagingDetails(PackagingDetails value);

	/**
	 * Returns the value of the '<em><b>Default Deployment Device</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <p>
	 * If the meaning of the '<em>Default Deployment Device</em>' reference isn't clear,
	 * there really should be more of a description here...
	 * </p>
	 * <!-- end-user-doc -->
	 * @return the value of the '<em>Default Deployment Device</em>' reference.
	 * @see #setDefaultDeploymentDevice(TargetDevice)
	 * @see org.eclipse.mtj.api.project.ProjectPackage#getProject_DefaultDeploymentDevice()
	 * @model
	 * @generated
	 */
	TargetDevice getDefaultDeploymentDevice();

	/**
	 * Sets the value of the '{@link org.eclipse.mtj.api.project.Project#getDefaultDeploymentDevice <em>Default Deployment Device</em>}' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @param value the new value of the '<em>Default Deployment Device</em>' reference.
	 * @see #getDefaultDeploymentDevice()
	 * @generated
	 */
	void setDefaultDeploymentDevice(TargetDevice value);

} // Project
