/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.project;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

/**
 * <!-- begin-user-doc -->
 * The <b>Package</b> for the model.
 * It contains accessors for the meta objects to represent
 * <ul>
 *   <li>each class,</li>
 *   <li>each feature of each class,</li>
 *   <li>each enum,</li>
 *   <li>and each data type</li>
 * </ul>
 * <!-- end-user-doc -->
 * @see org.eclipse.mtj.api.project.ProjectFactory
 * @model kind="package"
 * @generated
 */
public interface ProjectPackage extends EPackage {
	/**
	 * The package name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNAME = "project";

	/**
	 * The package namespace URI.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_URI = "http:///org/eclipse/mtj/api/project.ecore";

	/**
	 * The package namespace name.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	String eNS_PREFIX = "org.eclipse.mtj.api.project";

	/**
	 * The singleton instance of the package.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	ProjectPackage eINSTANCE = org.eclipse.mtj.api.project.impl.ProjectPackageImpl.init();

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.project.impl.ProjectImpl <em>Project</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.project.impl.ProjectImpl
	 * @see org.eclipse.mtj.api.project.impl.ProjectPackageImpl#getProject()
	 * @generated
	 */
	int PROJECT = 0;

	/**
	 * The feature id for the '<em><b>Type</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECT__TYPE = 0;

	/**
	 * The feature id for the '<em><b>Target Devices</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECT__TARGET_DEVICES = 1;

	/**
	 * The feature id for the '<em><b>Default Target Device</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECT__DEFAULT_TARGET_DEVICE = 2;

	/**
	 * The feature id for the '<em><b>Obfuscation Detail</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECT__OBFUSCATION_DETAIL = 3;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECT__NAME = 4;

	/**
	 * The feature id for the '<em><b>Packaging Details</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECT__PACKAGING_DETAILS = 5;

	/**
	 * The feature id for the '<em><b>Default Deployment Device</b></em>' reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECT__DEFAULT_DEPLOYMENT_DEVICE = 6;

	/**
	 * The number of structural features of the the '<em>Project</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PROJECT_FEATURE_COUNT = 7;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.project.impl.ObfuscationDetailImpl <em>Obfuscation Detail</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.project.impl.ObfuscationDetailImpl
	 * @see org.eclipse.mtj.api.project.impl.ProjectPackageImpl#getObfuscationDetail()
	 * @generated
	 */
	int OBFUSCATION_DETAIL = 1;

	/**
	 * The feature id for the '<em><b>Level</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBFUSCATION_DETAIL__LEVEL = 0;

	/**
	 * The feature id for the '<em><b>Additional Settings</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBFUSCATION_DETAIL__ADDITIONAL_SETTINGS = 1;

	/**
	 * The number of structural features of the the '<em>Obfuscation Detail</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int OBFUSCATION_DETAIL_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.project.impl.DebugConfigurationImpl <em>Debug Configuration</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.project.impl.DebugConfigurationImpl
	 * @see org.eclipse.mtj.api.project.impl.ProjectPackageImpl#getDebugConfiguration()
	 * @generated
	 */
	int DEBUG_CONFIGURATION = 2;

	/**
	 * The number of structural features of the the '<em>Debug Configuration</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int DEBUG_CONFIGURATION_FEATURE_COUNT = 0;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.project.impl.TargetDeviceImpl <em>Target Device</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.project.impl.TargetDeviceImpl
	 * @see org.eclipse.mtj.api.project.impl.ProjectPackageImpl#getTargetDevice()
	 * @generated
	 */
	int TARGET_DEVICE = 3;

	/**
	 * The feature id for the '<em><b>Signing Details</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_DEVICE__SIGNING_DETAILS = 0;

	/**
	 * The feature id for the '<em><b>Preprocessing Details</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_DEVICE__PREPROCESSING_DETAILS = 1;

	/**
	 * The feature id for the '<em><b>Runtime Platform</b></em>' containment reference.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_DEVICE__RUNTIME_PLATFORM = 2;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_DEVICE__NAME = 3;

	/**
	 * The feature id for the '<em><b>Description</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_DEVICE__DESCRIPTION = 4;

	/**
	 * The feature id for the '<em><b>Device Platform Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_DEVICE__DEVICE_PLATFORM_NAME = 5;

	/**
	 * The feature id for the '<em><b>Device Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_DEVICE__DEVICE_NAME = 6;

	/**
	 * The feature id for the '<em><b>Device Group Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_DEVICE__DEVICE_GROUP_NAME = 7;

	/**
	 * The number of structural features of the the '<em>Target Device</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int TARGET_DEVICE_FEATURE_COUNT = 8;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.project.impl.PreprocessingDetailImpl <em>Preprocessing Detail</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.project.impl.PreprocessingDetailImpl
	 * @see org.eclipse.mtj.api.project.impl.ProjectPackageImpl#getPreprocessingDetail()
	 * @generated
	 */
	int PREPROCESSING_DETAIL = 4;

	/**
	 * The feature id for the '<em><b>Condition</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREPROCESSING_DETAIL__CONDITION = 0;

	/**
	 * The number of structural features of the the '<em>Preprocessing Detail</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PREPROCESSING_DETAIL_FEATURE_COUNT = 1;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.project.impl.SigningDetailImpl <em>Signing Detail</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.project.impl.SigningDetailImpl
	 * @see org.eclipse.mtj.api.project.impl.ProjectPackageImpl#getSigningDetail()
	 * @generated
	 */
	int SIGNING_DETAIL = 5;

	/**
	 * The feature id for the '<em><b>Keystore</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNING_DETAIL__KEYSTORE = 0;

	/**
	 * The feature id for the '<em><b>Alias</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNING_DETAIL__ALIAS = 1;

	/**
	 * The number of structural features of the the '<em>Signing Detail</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int SIGNING_DETAIL_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.project.impl.PackagingDetailsImpl <em>Packaging Details</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.project.impl.PackagingDetailsImpl
	 * @see org.eclipse.mtj.api.project.impl.ProjectPackageImpl#getPackagingDetails()
	 * @generated
	 */
	int PACKAGING_DETAILS = 6;

	/**
	 * The feature id for the '<em><b>Increment Version Automatically</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGING_DETAILS__INCREMENT_VERSION_AUTOMATICALLY = 0;

	/**
	 * The feature id for the '<em><b>Exculed Manifest Entries</b></em>' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGING_DETAILS__EXCULED_MANIFEST_ENTRIES = 1;

	/**
	 * The number of structural features of the the '<em>Packaging Details</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PACKAGING_DETAILS_FEATURE_COUNT = 2;

	/**
	 * The meta object id for the '{@link org.eclipse.mtj.api.project.impl.ParameterImpl <em>Parameter</em>}' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see org.eclipse.mtj.api.project.impl.ParameterImpl
	 * @see org.eclipse.mtj.api.project.impl.ProjectPackageImpl#getParameter()
	 * @generated
	 */
	int PARAMETER = 7;

	/**
	 * The feature id for the '<em><b>Name</b></em>' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER__NAME = 0;

	/**
	 * The number of structural features of the the '<em>Parameter</em>' class.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 * @ordered
	 */
	int PARAMETER_FEATURE_COUNT = 1;


	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.project.Project <em>Project</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Project</em>'.
	 * @see org.eclipse.mtj.api.project.Project
	 * @generated
	 */
	EClass getProject();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.project.Project#getType <em>Type</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Type</em>'.
	 * @see org.eclipse.mtj.api.project.Project#getType()
	 * @see #getProject()
	 * @generated
	 */
	EAttribute getProject_Type();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.mtj.api.project.Project#getTargetDevices <em>Target Devices</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Target Devices</em>'.
	 * @see org.eclipse.mtj.api.project.Project#getTargetDevices()
	 * @see #getProject()
	 * @generated
	 */
	EReference getProject_TargetDevices();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.mtj.api.project.Project#getDefaultTargetDevice <em>Default Target Device</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Default Target Device</em>'.
	 * @see org.eclipse.mtj.api.project.Project#getDefaultTargetDevice()
	 * @see #getProject()
	 * @generated
	 */
	EReference getProject_DefaultTargetDevice();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.mtj.api.project.Project#getObfuscationDetail <em>Obfuscation Detail</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Obfuscation Detail</em>'.
	 * @see org.eclipse.mtj.api.project.Project#getObfuscationDetail()
	 * @see #getProject()
	 * @generated
	 */
	EReference getProject_ObfuscationDetail();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.project.Project#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.mtj.api.project.Project#getName()
	 * @see #getProject()
	 * @generated
	 */
	EAttribute getProject_Name();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.mtj.api.project.Project#getPackagingDetails <em>Packaging Details</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Packaging Details</em>'.
	 * @see org.eclipse.mtj.api.project.Project#getPackagingDetails()
	 * @see #getProject()
	 * @generated
	 */
	EReference getProject_PackagingDetails();

	/**
	 * Returns the meta object for the reference '{@link org.eclipse.mtj.api.project.Project#getDefaultDeploymentDevice <em>Default Deployment Device</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the reference '<em>Default Deployment Device</em>'.
	 * @see org.eclipse.mtj.api.project.Project#getDefaultDeploymentDevice()
	 * @see #getProject()
	 * @generated
	 */
	EReference getProject_DefaultDeploymentDevice();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.project.ObfuscationDetail <em>Obfuscation Detail</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Obfuscation Detail</em>'.
	 * @see org.eclipse.mtj.api.project.ObfuscationDetail
	 * @generated
	 */
	EClass getObfuscationDetail();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.project.ObfuscationDetail#getLevel <em>Level</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Level</em>'.
	 * @see org.eclipse.mtj.api.project.ObfuscationDetail#getLevel()
	 * @see #getObfuscationDetail()
	 * @generated
	 */
	EAttribute getObfuscationDetail_Level();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.project.ObfuscationDetail#getAdditionalSettings <em>Additional Settings</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Additional Settings</em>'.
	 * @see org.eclipse.mtj.api.project.ObfuscationDetail#getAdditionalSettings()
	 * @see #getObfuscationDetail()
	 * @generated
	 */
	EAttribute getObfuscationDetail_AdditionalSettings();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.project.DebugConfiguration <em>Debug Configuration</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Debug Configuration</em>'.
	 * @see org.eclipse.mtj.api.project.DebugConfiguration
	 * @generated
	 */
	EClass getDebugConfiguration();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.project.TargetDevice <em>Target Device</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Target Device</em>'.
	 * @see org.eclipse.mtj.api.project.TargetDevice
	 * @generated
	 */
	EClass getTargetDevice();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.mtj.api.project.TargetDevice#getSigningDetails <em>Signing Details</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Signing Details</em>'.
	 * @see org.eclipse.mtj.api.project.TargetDevice#getSigningDetails()
	 * @see #getTargetDevice()
	 * @generated
	 */
	EReference getTargetDevice_SigningDetails();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.mtj.api.project.TargetDevice#getPreprocessingDetails <em>Preprocessing Details</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Preprocessing Details</em>'.
	 * @see org.eclipse.mtj.api.project.TargetDevice#getPreprocessingDetails()
	 * @see #getTargetDevice()
	 * @generated
	 */
	EReference getTargetDevice_PreprocessingDetails();

	/**
	 * Returns the meta object for the containment reference '{@link org.eclipse.mtj.api.project.TargetDevice#getRuntimePlatform <em>Runtime Platform</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference '<em>Runtime Platform</em>'.
	 * @see org.eclipse.mtj.api.project.TargetDevice#getRuntimePlatform()
	 * @see #getTargetDevice()
	 * @generated
	 */
	EReference getTargetDevice_RuntimePlatform();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.project.TargetDevice#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.mtj.api.project.TargetDevice#getName()
	 * @see #getTargetDevice()
	 * @generated
	 */
	EAttribute getTargetDevice_Name();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.project.TargetDevice#getDescription <em>Description</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Description</em>'.
	 * @see org.eclipse.mtj.api.project.TargetDevice#getDescription()
	 * @see #getTargetDevice()
	 * @generated
	 */
	EAttribute getTargetDevice_Description();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.project.TargetDevice#getDevicePlatformName <em>Device Platform Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Device Platform Name</em>'.
	 * @see org.eclipse.mtj.api.project.TargetDevice#getDevicePlatformName()
	 * @see #getTargetDevice()
	 * @generated
	 */
	EAttribute getTargetDevice_DevicePlatformName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.project.TargetDevice#getDeviceName <em>Device Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Device Name</em>'.
	 * @see org.eclipse.mtj.api.project.TargetDevice#getDeviceName()
	 * @see #getTargetDevice()
	 * @generated
	 */
	EAttribute getTargetDevice_DeviceName();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.project.TargetDevice#getDeviceGroupName <em>Device Group Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Device Group Name</em>'.
	 * @see org.eclipse.mtj.api.project.TargetDevice#getDeviceGroupName()
	 * @see #getTargetDevice()
	 * @generated
	 */
	EAttribute getTargetDevice_DeviceGroupName();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.project.PreprocessingDetail <em>Preprocessing Detail</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Preprocessing Detail</em>'.
	 * @see org.eclipse.mtj.api.project.PreprocessingDetail
	 * @generated
	 */
	EClass getPreprocessingDetail();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.project.PreprocessingDetail#getCondition <em>Condition</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Condition</em>'.
	 * @see org.eclipse.mtj.api.project.PreprocessingDetail#getCondition()
	 * @see #getPreprocessingDetail()
	 * @generated
	 */
	EAttribute getPreprocessingDetail_Condition();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.project.SigningDetail <em>Signing Detail</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Signing Detail</em>'.
	 * @see org.eclipse.mtj.api.project.SigningDetail
	 * @generated
	 */
	EClass getSigningDetail();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.project.SigningDetail#getKeystore <em>Keystore</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Keystore</em>'.
	 * @see org.eclipse.mtj.api.project.SigningDetail#getKeystore()
	 * @see #getSigningDetail()
	 * @generated
	 */
	EAttribute getSigningDetail_Keystore();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.project.SigningDetail#getAlias <em>Alias</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Alias</em>'.
	 * @see org.eclipse.mtj.api.project.SigningDetail#getAlias()
	 * @see #getSigningDetail()
	 * @generated
	 */
	EAttribute getSigningDetail_Alias();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.project.PackagingDetails <em>Packaging Details</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Packaging Details</em>'.
	 * @see org.eclipse.mtj.api.project.PackagingDetails
	 * @generated
	 */
	EClass getPackagingDetails();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.project.PackagingDetails#isIncrementVersionAutomatically <em>Increment Version Automatically</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Increment Version Automatically</em>'.
	 * @see org.eclipse.mtj.api.project.PackagingDetails#isIncrementVersionAutomatically()
	 * @see #getPackagingDetails()
	 * @generated
	 */
	EAttribute getPackagingDetails_IncrementVersionAutomatically();

	/**
	 * Returns the meta object for the containment reference list '{@link org.eclipse.mtj.api.project.PackagingDetails#getExculedManifestEntries <em>Exculed Manifest Entries</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the containment reference list '<em>Exculed Manifest Entries</em>'.
	 * @see org.eclipse.mtj.api.project.PackagingDetails#getExculedManifestEntries()
	 * @see #getPackagingDetails()
	 * @generated
	 */
	EReference getPackagingDetails_ExculedManifestEntries();

	/**
	 * Returns the meta object for class '{@link org.eclipse.mtj.api.project.Parameter <em>Parameter</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for class '<em>Parameter</em>'.
	 * @see org.eclipse.mtj.api.project.Parameter
	 * @generated
	 */
	EClass getParameter();

	/**
	 * Returns the meta object for the attribute '{@link org.eclipse.mtj.api.project.Parameter#getName <em>Name</em>}'.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the meta object for the attribute '<em>Name</em>'.
	 * @see org.eclipse.mtj.api.project.Parameter#getName()
	 * @see #getParameter()
	 * @generated
	 */
	EAttribute getParameter_Name();

	/**
	 * Returns the factory that creates the instances of the model.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @return the factory that creates the instances of the model.
	 * @generated
	 */
	ProjectFactory getProjectFactory();

} //ProjectPackage
