/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.runtimes.impl;

import java.util.Collection;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

import org.eclipse.mtj.api.devices.Device;
import org.eclipse.mtj.api.devices.DevicesPackage;

import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.RuntimePlatformDefinition;
import org.eclipse.mtj.api.runtimes.RuntimesPackage;
import org.eclipse.mtj.api.runtimes.ServiceApi;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Runtime Platform Definition</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link org.eclipse.mtj.api.runtimes.impl.RuntimePlatformDefinitionImpl#getDevices <em>Devices</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.runtimes.impl.RuntimePlatformDefinitionImpl#getDeviceProfiles <em>Device Profiles</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.runtimes.impl.RuntimePlatformDefinitionImpl#getServiceApis <em>Service Apis</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.runtimes.impl.RuntimePlatformDefinitionImpl#getDeviceConfigurations <em>Device Configurations</em>}</li>
 *   <li>{@link org.eclipse.mtj.api.runtimes.impl.RuntimePlatformDefinitionImpl#getName <em>Name</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class RuntimePlatformDefinitionImpl extends EObjectImpl implements RuntimePlatformDefinition {
	/**
	 * The cached value of the '{@link #getDevices() <em>Devices</em>}' reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDevices()
	 * @generated
	 * @ordered
	 */
	protected EList devices = null;

	/**
	 * The cached value of the '{@link #getDeviceProfiles() <em>Device Profiles</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeviceProfiles()
	 * @generated
	 * @ordered
	 */
	protected EList deviceProfiles = null;

	/**
	 * The cached value of the '{@link #getServiceApis() <em>Service Apis</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getServiceApis()
	 * @generated
	 * @ordered
	 */
	protected EList serviceApis = null;

	/**
	 * The cached value of the '{@link #getDeviceConfigurations() <em>Device Configurations</em>}' containment reference list.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getDeviceConfigurations()
	 * @generated
	 * @ordered
	 */
	protected EList deviceConfigurations = null;

	/**
	 * The default value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected static final String NAME_EDEFAULT = null;

	/**
	 * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #getName()
	 * @generated
	 * @ordered
	 */
	protected String name = NAME_EDEFAULT;

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected RuntimePlatformDefinitionImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected EClass eStaticClass() {
		return RuntimesPackage.eINSTANCE.getRuntimePlatformDefinition();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getDevices() {
		if (devices == null) {
			devices = new EObjectWithInverseResolvingEList.ManyInverse(Device.class, this, RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__DEVICES, DevicesPackage.DEVICE__RUNTIME_PLATFORM_DEFINITIONS);
		}
		return devices;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getDeviceProfiles() {
		if (deviceProfiles == null) {
			deviceProfiles = new EObjectContainmentEList(DeviceProfile.class, this, RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__DEVICE_PROFILES);
		}
		return deviceProfiles;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getServiceApis() {
		if (serviceApis == null) {
			serviceApis = new EObjectContainmentEList(ServiceApi.class, this, RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__SERVICE_APIS);
		}
		return serviceApis;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EList getDeviceConfigurations() {
		if (deviceConfigurations == null) {
			deviceConfigurations = new EObjectContainmentEList(DeviceConfiguration.class, this, RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__DEVICE_CONFIGURATIONS);
		}
		return deviceConfigurations;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String getName() {
		return name;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void setName(String newName) {
		String oldName = name;
		name = newName;
		if (eNotificationRequired())
			eNotify(new ENotificationImpl(this, Notification.SET, RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__NAME, oldName, name));
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__DEVICES:
					return ((InternalEList)getDevices()).basicAdd(otherEnd, msgs);
				default:
					return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
			}
		}
		if (eContainer != null)
			msgs = eBasicRemoveFromContainer(msgs);
		return eBasicSetContainer(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
		if (featureID >= 0) {
			switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
				case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__DEVICES:
					return ((InternalEList)getDevices()).basicRemove(otherEnd, msgs);
				case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__DEVICE_PROFILES:
					return ((InternalEList)getDeviceProfiles()).basicRemove(otherEnd, msgs);
				case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__SERVICE_APIS:
					return ((InternalEList)getServiceApis()).basicRemove(otherEnd, msgs);
				case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__DEVICE_CONFIGURATIONS:
					return ((InternalEList)getDeviceConfigurations()).basicRemove(otherEnd, msgs);
				default:
					return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
			}
		}
		return eBasicSetContainer(null, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Object eGet(EStructuralFeature eFeature, boolean resolve) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__DEVICES:
				return getDevices();
			case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__DEVICE_PROFILES:
				return getDeviceProfiles();
			case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__SERVICE_APIS:
				return getServiceApis();
			case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__DEVICE_CONFIGURATIONS:
				return getDeviceConfigurations();
			case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__NAME:
				return getName();
		}
		return eDynamicGet(eFeature, resolve);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eSet(EStructuralFeature eFeature, Object newValue) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__DEVICES:
				getDevices().clear();
				getDevices().addAll((Collection)newValue);
				return;
			case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__DEVICE_PROFILES:
				getDeviceProfiles().clear();
				getDeviceProfiles().addAll((Collection)newValue);
				return;
			case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__SERVICE_APIS:
				getServiceApis().clear();
				getServiceApis().addAll((Collection)newValue);
				return;
			case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__DEVICE_CONFIGURATIONS:
				getDeviceConfigurations().clear();
				getDeviceConfigurations().addAll((Collection)newValue);
				return;
			case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__NAME:
				setName((String)newValue);
				return;
		}
		eDynamicSet(eFeature, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public void eUnset(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__DEVICES:
				getDevices().clear();
				return;
			case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__DEVICE_PROFILES:
				getDeviceProfiles().clear();
				return;
			case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__SERVICE_APIS:
				getServiceApis().clear();
				return;
			case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__DEVICE_CONFIGURATIONS:
				getDeviceConfigurations().clear();
				return;
			case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__NAME:
				setName(NAME_EDEFAULT);
				return;
		}
		eDynamicUnset(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public boolean eIsSet(EStructuralFeature eFeature) {
		switch (eDerivedStructuralFeatureID(eFeature)) {
			case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__DEVICES:
				return devices != null && !devices.isEmpty();
			case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__DEVICE_PROFILES:
				return deviceProfiles != null && !deviceProfiles.isEmpty();
			case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__SERVICE_APIS:
				return serviceApis != null && !serviceApis.isEmpty();
			case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__DEVICE_CONFIGURATIONS:
				return deviceConfigurations != null && !deviceConfigurations.isEmpty();
			case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION__NAME:
				return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
		}
		return eDynamicIsSet(eFeature);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String toString() {
		if (eIsProxy()) return super.toString();

		StringBuffer result = new StringBuffer(super.toString());
		result.append(" (name: ");
		result.append(name);
		result.append(')');
		return result.toString();
	}

} //RuntimePlatformDefinitionImpl
