/*******************************************************************************
* Copyright (c) 2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/
package org.eclipse.mtj.api.runtimes.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;

import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;

import org.eclipse.mtj.api.runtimes.*;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model <b>Factory</b>.
 * <!-- end-user-doc -->
 * @generated
 */
public class RuntimesFactoryImpl extends EFactoryImpl implements RuntimesFactory {
	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static RuntimesFactory init() {
		try {
			RuntimesFactory theRuntimesFactory = (RuntimesFactory)EPackage.Registry.INSTANCE.getEFactory("http:///org/eclipse/mtj/api/runtimes.ecore"); 
			if (theRuntimesFactory != null) {
				return theRuntimesFactory;
			}
		}
		catch (Exception exception) {
			EcorePlugin.INSTANCE.log(exception);
		}
		return new RuntimesFactoryImpl();
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RuntimesFactoryImpl() {
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public EObject create(EClass eClass) {
		switch (eClass.getClassifierID()) {
			case RuntimesPackage.RUNTIME_PLATFORM_DEFINITION: return createRuntimePlatformDefinition();
			case RuntimesPackage.DEVICE_PROFILE: return createDeviceProfile();
			case RuntimesPackage.SERVICE_API: return createServiceApi();
			case RuntimesPackage.DEVICE_CONFIGURATION: return createDeviceConfiguration();
			case RuntimesPackage.IMPLEMENTATION_REF: return createImplementationRef();
			case RuntimesPackage.JVM_IMPLEMENTATION: return createJvmImplementation();
			case RuntimesPackage.RUNTIME_PLATFORM: return createRuntimePlatform();
			default:
				throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RuntimePlatformDefinition createRuntimePlatformDefinition() {
		RuntimePlatformDefinitionImpl runtimePlatformDefinition = new RuntimePlatformDefinitionImpl();
		return runtimePlatformDefinition;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeviceProfile createDeviceProfile() {
		DeviceProfileImpl deviceProfile = new DeviceProfileImpl();
		return deviceProfile;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ServiceApi createServiceApi() {
		ServiceApiImpl serviceApi = new ServiceApiImpl();
		return serviceApi;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DeviceConfiguration createDeviceConfiguration() {
		DeviceConfigurationImpl deviceConfiguration = new DeviceConfigurationImpl();
		return deviceConfiguration;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public ImplementationRef createImplementationRef() {
		ImplementationRefImpl implementationRef = new ImplementationRefImpl();
		return implementationRef;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public JvmImplementation createJvmImplementation() {
		JvmImplementationImpl jvmImplementation = new JvmImplementationImpl();
		return jvmImplementation;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RuntimePlatform createRuntimePlatform() {
		RuntimePlatformImpl runtimePlatform = new RuntimePlatformImpl();
		return runtimePlatform;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public RuntimesPackage getRuntimesPackage() {
		return (RuntimesPackage)getEPackage();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	public static RuntimesPackage getPackage() {
		return RuntimesPackage.eINSTANCE;
	}

} //RuntimesFactoryImpl
