/*******************************************************************************
* Copyright (c) 2006 IBM Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
* Contributors:
*IBM - initial API and implementation
*******************************************************************************/
package org.eclipse.mtj.jad.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;

/**
 * @author khorowit
 *
 * To change the template for this generated type comment go to
 * Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments
 */
public class ConvertNativeToUTF8 {
	/*
	 * Given an inputStream, convert the stream to UTF8
	 * 
	 * @input inputStream
	 * @return UTF8 version of inputStream
	 */
	public static InputStream convertNativeToUTF8 (InputStream inputStream)
	{
		if (inputStream == null)
			return null;
		ByteArrayOutputStream dais = null;
		try 
		{
			BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "utf8")); //$NON-NLS-1$
			dais = new ByteArrayOutputStream ();
			OutputStreamWriter osw = new OutputStreamWriter (dais, "utf8"); //$NON-NLS-1$
			BufferedWriter bw = new BufferedWriter (osw);
			String tmpString = ""; //$NON-NLS-1$
			while (tmpString != null)
			{
				tmpString = bufferedReader.readLine();
				if (tmpString != null)
				{
//					System.out.println ("ConvertNativeToUTF8.convertNativeToUTF8 String " + tmpString.trim());
					String outputString = tmpString.trim() + "\n"; //$NON-NLS-1$
					bw.write (outputString);
				}
			}
			bw.close();
		} 
		catch (EOFException e)
		{
		}
		catch (IOException e) 
		{
			e.printStackTrace();
		}
		ByteArrayInputStream bais;
		if (dais != null)
			bais = new ByteArrayInputStream (dais.toByteArray());
		else
			bais = new ByteArrayInputStream ("".getBytes()); //$NON-NLS-1$
		return bais;

	}
	
	/**
	 * Convert a string that is in UTF8 format to the current native encoding.
	 * @param inputString UTF8 Format String
	 * @return local System encoding version of string
	 */
	public static String convertUTF8ToNative (String inputString)
	{
		if (inputString == null)
			return null;
		try {
			String outputString = new String (inputString.getBytes(), "utf8"); //$NON-NLS-1$
			return outputString;
		} catch (UnsupportedEncodingException e) {
		}
		return ""; //$NON-NLS-1$
	}
	
	public static String convertNativeToUTF8 (String inputString)
	{
		if (inputString == null)
			return null;
		try {
			String outputString = new String (inputString.getBytes("utf8")); //$NON-NLS-1$
			return outputString;
		} catch (UnsupportedEncodingException e) {
		}
		return ""; //$NON-NLS-1$
	}
//	
//	
//	public static InputStream convertUTF8ToNative (InputStream testStream)
//	{
//		if (testStream == null)
//		{
//			System.out.println ("ConvertUTF8ToNative.convertUTF8ToNative received null stream");
//			return testStream;
//		} 
//			
//		String inputLine = "";
//
//		ByteArrayOutputStream dais = new ByteArrayOutputStream ();
//
//		try 
//		{
//			InputStreamReader isr = new InputStreamReader (testStream, "utf8");
//			while (inputLine != null && isr.ready())
//			{
//				char[] characterArray = new char[1024];
//				int count = isr.read(characterArray);
//				if (count != -1)
//					inputLine = new String (characterArray, 0, count);
//				else
//					inputLine = null;
//				if (inputLine != null)
//				{
//					if (inputLine.compareTo ("\n") == 0)
//						dais.write(inputLine.getBytes());
//					else
//						dais.write(inputLine.trim().getBytes());
//				}
//			}
//		} 
//		catch (EOFException e)
//		{
//			System.out.println ("ConvertUTF8ToNative.convertUTF8ToNative.EOF");
//		}
//		catch (IOException e) 
//		{
//			e.printStackTrace();
//		}
//		ByteArrayInputStream bais = new ByteArrayInputStream (dais.toByteArray());
//		return bais;
//	}	
//	
//	
//	public static void main (String[] args)
//	{
//		String test = "\nbcd";
//		try 
//		{
//			String inputLine = "";
//			ByteArrayInputStream testStream = new ByteArrayInputStream (test.getBytes());
//			BufferedReader testReader = new BufferedReader (new InputStreamReader (testStream));
//			try 
//			{
//				while (inputLine != null)
//				{
//					inputLine = testReader.readLine();
//					if (inputLine != null)
//					{
//						System.out.println ("Initializing:Read " + inputLine.trim());
//					}
//				}
//			}
//			catch (EOFException e)
//			{
//				System.out.println ("Main.EOF");
//			}
//			catch (IOException e)
//			{
//				e.printStackTrace();
//			}
//			
//			testStream = new ByteArrayInputStream (test.getBytes());
//			InputStream is = convertNativeToUTF8(testStream);
//			BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
//	
//			inputLine ="";
//			while (inputLine != null)
//			{
//				inputLine = bufferedReader.readLine();
//				if (inputLine != null)
//				{
//				
//				System.out.println ("FromStream:Read " + inputLine.trim());
//				String back = convertUTF8ToNative(inputLine.trim());
//				System.out.println ("ConvertedBackToNative " + back);
//				String thirdTry = convertNativeToUTF8(back);
//				System.out.println ("BackToUTF8 " + thirdTry);
//				//System.out.println ("a " + System.getProperty("console.encoding") + " b " + System.getProperty("file.encoding"));
//				}
//			}
//		} 
//		catch (EOFException e)
//		{
//			System.out.println ("Main2.EOF");
//		}
//		catch (IOException e)
//		{
//			e.printStackTrace();
//		}
//		
//		
//	}
}
