/*******************************************************************************
* Copyright  2005 Nokia Corporation
* All rights reserved. This program and the accompanying materials
* are made available under the terms of the Eclipse Public License v1.0
* which accompanies this distribution, and is available at
* http://www.eclipse.org/legal/epl-v10.html
 *
*******************************************************************************/

package org.eclipse.mtj.executable.uei;

import java.io.File;

import org.eclipse.mtj.api.runtimes.DeviceConfiguration;
import org.eclipse.mtj.api.runtimes.DeviceProfile;
import org.eclipse.mtj.api.runtimes.ServiceApi;

public abstract class AbstractServiceApiImporter implements IServiceApiImporter {
	
	public static final IServiceApiImporter[] SERVICE_API_IMPORTERS = new IServiceApiImporter[] { ServiceApiManifestImporter.getInstance(), ServiceApiImporter.getInstance()}; 

//	private static AbstractServiceApiImporter instance;
//	
//	private AbstractServiceApiImporter(){
//		super();
//	}
//	
//	public static IServiceApiImporter getInstance(){
//		
//		if(instance == null){
//			instance = new AbstractServiceApiImporter();
//		}
//		
//		return instance;
//	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.mtj.executable.uei.IServiceApiImporter#getServiceApis(java.lang.String)
	 */
	public ServiceApi[] getServiceApis(String bootclasspath){
		return getServiceApis(new File(bootclasspath));
	}

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.executable.uei.IServiceApiImporter#getServiceApi(java.io.File)
	 */
	//public abstract ServiceApi getServiceApi(File serviceApiFile);

	public abstract ServiceApi[] getServiceApis(File libraryFile);

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.executable.uei.IServiceApiImporter#getConfigurationApis(java.io.File)
	 */
	public abstract DeviceConfiguration[] getConfigurationApis(File libraryFile);
		

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.executable.uei.IServiceApiImporter#getConfigurationApis(java.lang.String)
	 */
	public DeviceConfiguration[] getConfigurationApis(String bootclasspath) {
		return getConfigurationApis(new File(bootclasspath));
	}

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.executable.uei.IServiceApiImporter#getProfileApis(java.io.File)
	 */
	public abstract DeviceProfile[] getProfileApis(File libraryFile);

	/* (non-Javadoc)
	 * @see org.eclipse.mtj.executable.uei.IServiceApiImporter#getProfileApis(java.lang.String)
	 */
	public DeviceProfile[] getProfileApis(String bootclasspath) {
		return getProfileApis(new File(bootclasspath));
	}
	
	
}
