/**
 * Copyright (c) 2003-2005 Craig Setera
 * All Rights Reserved.
 * Licensed under the Eclipse Public License - v 1.0
 * For more information see http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.mtj.extension.devide.jadeditor;

/**
 * This class represents an application descriptor property description.
 * <p>
 * <b>Note:</b> This class/interface is part of an interim API that is still 
 * under development and expected to change before reaching stability. It is 
 * being made available at this early stage to solicit feedback 
 * from pioneering adopters on the understanding that any code that uses 
 * this API will almost certainly be broken as the API evolves.
 * </p>
 * Copyright (c) 2003-2005 Craig Setera<br>
 * All Rights Reserved.<br>
 * Licensed under the Eclipse Public License - v 1.0<p/>
 * <br>
 * $Revision: 1.1.1.1 $
 * <br>
 * $Date: 2006/08/30 18:51:23 $
 * <br>
 * @author Craig Setera
 */

public class DescriptorPropertyDescription {
	/** String property type */
	public static final int DATATYPE_STRING = 1;
	
	/** URL property type */
	public static final int DATATYPE_URL = 2;
	
	/** Integer property type */
	public static final int DATATYPE_INT = 3;
	
	/** List property type */
	public static final int DATATYPE_LIST = 4;
	
	// The name of the underlying property
	private String propertyName;
	
	// The displayable name for this property
	private String displayName;
	
	// The data type for this property
	private int dataType;
	
	/**
	 * Constructor 
	 */
	public DescriptorPropertyDescription(
		String propertyName, 
		String displayName,
		int dataType) 
	{
		super();
		this.propertyName = propertyName;
		this.displayName = displayName;
		this.dataType = dataType;
	}

	/**
	 * @return the data type
	 */
	public int getDataType() {
		return dataType;
	}

	/**
	 * @return the display name
	 */
	public String getDisplayName() {
		return displayName;
	}

	/**
	 * @return the property name
	 */
	public String getPropertyName() {
		return propertyName;
	}

	/**
	 * @param i the data type
	 */
	public void setDataType(int i) {
		dataType = i;
	}

	/**
	 * @param string the display name
	 */
	public void setDisplayName(String string) {
		displayName = string;
	}

	/**
	 * @param string the property name
	 */
	public void setPropertyName(String string) {
		propertyName = string;
	}
}
