/**
 * Copyright (c) 2003-2005 Craig Setera
 * All Rights Reserved.
 * Licensed under the Eclipse Public License - v 1.0
 * For more information see http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.mtj.extension.devide.jadeditor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.mtj.core.MtjCorePlugin;
import org.eclipse.mtj.core.jad.IJADConstants;
import org.eclipse.mtj.extension.devide.MtjDevIdePlugin;
import org.eclipse.mtj.extension.devide.config.LibrarySpecification;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.PlatformUI;

/**
 * JAD editor page for handling the required properties.
 * <p />
 * Copyright (c) 2003-2005 Craig Setera<br>
 * All Rights Reserved.<br>
 * Licensed under the Eclipse Public License - v 1.0<p/>
 * <br>
 * $Revision: 1.2 $
 * <br>
 * $Date: 2006/09/05 15:12:25 $
 * <br>
 * @author Craig Setera
 */
public class JADRequiredPropertiesEditorPage extends JADPropertiesEditorPage {
	public static final String ID = "required";
	
	/**
	 * Required property descriptors.
	 */
	private static final DescriptorPropertyDescription[] 
		REQUIRED_DESCRIPTORS = new DescriptorPropertyDescription[] {
			new DescriptorPropertyDescription(
				IJADConstants.JAD_MIDLET_JAR_URL,
				JadEditorStrings.property_jad_midlet_jar_url,
				DescriptorPropertyDescription.DATATYPE_URL),
			new DescriptorPropertyDescription(
				IJADConstants.JAD_MIDLET_NAME,
				JadEditorStrings.property_jad_midlet_name,
				DescriptorPropertyDescription.DATATYPE_STRING),
			new DescriptorPropertyDescription(
				IJADConstants.JAD_MIDLET_VENDOR,
				JadEditorStrings.property_jad_midlet_vendor,
				DescriptorPropertyDescription.DATATYPE_STRING),
			new DescriptorPropertyDescription(
				IJADConstants.JAD_MIDLET_VERSION,
				JadEditorStrings.property_jad_midlet_version,
				DescriptorPropertyDescription.DATATYPE_STRING),
			new ListDescriptorPropertyDescription(
				IJADConstants.JAD_MICROEDITION_CONFIG,
				JadEditorStrings.property_jad_microedition_configuration,
				getConfigurationNamesAndValues()),
			new ListDescriptorPropertyDescription(
				IJADConstants.JAD_MICROEDITION_PROFILE,
				JadEditorStrings.property_jad_microedition_profile,
				getProfileNamesAndValues()),
		};

	/**
	 * Return the J2ME configuration names and values.
	 * 
	 * @return
	 */
	private static String[][] getConfigurationNamesAndValues()
	{
		String[][] namesAndValues = null;

		try {
			LibrarySpecification[] specifications =
				MtjDevIdePlugin.getConfigurationSpecifications();
			
			namesAndValues = new String[specifications.length][];
			for (int i = 0; i < specifications.length; i++) {
				LibrarySpecification spec = specifications[i];
				namesAndValues[i] = new String[2];
				namesAndValues[i][0] = spec.getName();
				namesAndValues[i][1] = spec.getIdentifier();
			}
		} catch (CoreException e) {
			namesAndValues = new String[0][0];
			MtjCorePlugin.log(IStatus.WARNING, e);
		}
		
		return namesAndValues;
	}
	
	/**
	 * Return the J2ME profile names and values.
	 * 
	 * @return
	 */
	private static String[][] getProfileNamesAndValues()
	{
		String[][] namesAndValues = null;

		try {
			LibrarySpecification[] specifications =
				MtjDevIdePlugin.getProfileSpecifications();
			
			namesAndValues = new String[specifications.length][];
			for (int i = 0; i < specifications.length; i++) {
				LibrarySpecification spec = specifications[i];
				namesAndValues[i] = new String[2];
				namesAndValues[i][0] = spec.getName();
				namesAndValues[i][1] = spec.getIdentifier();
			}
		} catch (CoreException e) {
			namesAndValues = new String[0][0];
			MtjCorePlugin.log(IStatus.WARNING, e);
		}
		
		return namesAndValues;
	}
	
	/**
	 * Constract a new required properties editor.
	 * 
	 * @param editor
	 */
	public JADRequiredPropertiesEditorPage(JADEditor editor) {
		super(editor, ID, "Required", REQUIRED_DESCRIPTORS);
	}

	/**
	 * @see org.eclipse.mtj.extension.devide.jadeditor.AbstractJADEditorPage#getSectionTitle()
	 */
	protected String getSectionTitle() {
		return "Required Properties";
	}

	/**
	 * @see org.eclipse.mtj.extension.devide.jadeditor.AbstractJADEditorPage#getSectionDescription()
	 */
	protected String getSectionDescription() {
		return "Required midlet suite properties must be specified on this page";
	}
	
	protected void addContextHelp(Composite c)
	{
		PlatformUI.getWorkbench().getHelpSystem().setHelp(c, "eclipseme.ui.help_JADRequiredPropertiesEditorPage");
	}
}
